/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.bamboo.action;

import com.atlassian.bamboo.security.xsrf.XsrfTokenUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.crowd.common.handler.MoPluginConfigurationHandler;
import com.miniorange.crowd.common.handler.MoPluginConfigurationManager;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class MoCrowdLookAndFeelAction
extends BambooActionSupport {
    private static Log LOGGER = LogFactory.getLog(MoCrowdLookAndFeelAction.class);
    private I18nResolver i18nResolver;
    private String platform;
    private Boolean useErrorTemplate;
    private String errorTemplate;
    private Boolean useLoginTemplate;
    private String loginTemplate;
    private Boolean submitted;
    private Boolean error = Boolean.FALSE;
    private MoPluginConfigurationManager pluginConfigurationManager;
    private String xsrfToken;
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;

    public MoCrowdLookAndFeelAction(MoPluginConfigurationManager pluginConfigurationManager, I18nResolver i18nResolver, UserManager userManager, LoginUriProvider loginUriProvider) {
        this.i18nResolver = i18nResolver;
        this.loginUriProvider = loginUriProvider;
        this.userManager = userManager;
        this.pluginConfigurationManager = pluginConfigurationManager;
    }

    public void doValidation() {
        this.error = Boolean.FALSE;
        if (!BooleanUtils.toBoolean((Boolean)this.submitted)) {
            return;
        }
    }

    public String execute() throws Exception {
        LOGGER.debug((Object)"CrowdLookAndFeelActionConfiguration execute called");
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.xsrfToken = XsrfTokenUtils.getXsrfToken((HttpServletRequest)request);
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            try {
                if (!this.pluginConfigurationManager.isLicenseValid().booleanValue()) {
                    LOGGER.error((Object)"Invalid license");
                    return "upm";
                }
                this.doValidation();
                if (BooleanUtils.toBoolean((Boolean)this.submitted) && !BooleanUtils.toBoolean((Boolean)this.error)) {
                    LOGGER.debug((Object)"CrowdLookAndFeelAction: configuration submitted");
                    LOGGER.debug((Object)(" Use error template : " + this.useErrorTemplate + ", Error template : " + this.errorTemplate + ", useLoginTemplate : " + this.useLoginTemplate + ", loginTemplate" + this.loginTemplate));
                    MoPluginConfigurationHandler.saveLookAndFeelConfiguration(this.useErrorTemplate, this.errorTemplate, this.useLoginTemplate, this.loginTemplate);
                    this.initializeSAMLConfig();
                    this.addActionMessage(this.i18nResolver.getText("crowdsso.success.redirection"));
                    return "success";
                }
                LOGGER.debug((Object)"Reached initialize config");
                this.initializeSAMLConfig();
                return "success";
            }
            catch (Exception e) {
                e.printStackTrace();
                this.addActionError(this.i18nResolver.getText("crowdsso.error.saving.redirection.settings"));
                return "error";
            }
        }
        LOGGER.error((Object)"User does not have permission to access Crowd Configuration page");
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        return null;
    }

    private void initializeSAMLConfig() {
        LOGGER.debug((Object)"inside initialise config");
        this.platform = this.i18nResolver.getText("my.plugin.platform");
        this.useErrorTemplate = this.pluginConfigurationManager.getUseErrorTemplate();
        this.errorTemplate = this.pluginConfigurationManager.getErrorTemplate();
        this.useLoginTemplate = this.pluginConfigurationManager.getUseLoginTemplate();
        this.loginTemplate = this.pluginConfigurationManager.getLoginTemplate();
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setUseLoginTemplate(Boolean useLoginTemplate) {
        this.useLoginTemplate = useLoginTemplate;
    }

    public Boolean getUseLoginTemplate() {
        return this.useLoginTemplate;
    }

    public void setLoginTemplate(String loginTemplate) {
        this.loginTemplate = loginTemplate;
    }

    public String getLoginTemplate() {
        return this.loginTemplate;
    }

    public Boolean getUseErrorTemplate() {
        return this.useErrorTemplate;
    }

    public void setUseErrorTemplate(Boolean useErrorTemplate) {
        this.useErrorTemplate = useErrorTemplate;
    }

    public String getErrorTemplate() {
        return this.errorTemplate;
    }

    public void setErrorTemplate(String errorTemplate) {
        this.errorTemplate = errorTemplate;
    }

    public I18nResolver getI18nResolver() {
        return this.i18nResolver;
    }

    public void setI18nResolver(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public MoPluginConfigurationManager getPluginConfigurationManager() {
        return this.pluginConfigurationManager;
    }

    public void setPluginConfigurationManager(MoPluginConfigurationManager pluginConfigurationManager) {
        this.pluginConfigurationManager = pluginConfigurationManager;
    }

    public Boolean getSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(Boolean submitted) {
        this.submitted = submitted;
    }

    public Boolean getError() {
        return this.error;
    }

    public void setError(Boolean error) {
        this.error = error;
    }
}

