/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.common.servlet.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.log4j.Logger;

public class RestReadingServletRequest
extends HttpServletRequestWrapper {
    private static final Logger log = Logger.getLogger(RestReadingServletRequest.class);
    private final byte[] body;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RestReadingServletRequest(HttpServletRequest request) throws IOException {
        ByteArrayOutputStream baos;
        block10: {
            super(request);
            BufferedInputStream bis = null;
            baos = new ByteArrayOutputStream();
            try {
                ServletInputStream inputStream = request.getInputStream();
                if (inputStream != null) {
                    bis = new BufferedInputStream((InputStream)inputStream);
                    byte[] byteBuffer = new byte[1024];
                    int bytesRead = -1;
                    while ((bytesRead = bis.read(byteBuffer)) > 0) {
                        baos.write(byteBuffer, 0, bytesRead);
                    }
                }
                if (bis == null) break block10;
            }
            catch (IOException ex) {
                try {
                    log.error((Object)String.format("Error reading request input stream: %s", ex.getMessage()));
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (bis == null) throw throwable;
                    try {
                        bis.close();
                        baos.close();
                        throw throwable;
                    }
                    catch (IOException ex2) {
                        log.error((Object)String.format("Error closing request input stream: %s", ex2.getMessage()));
                        throw ex2;
                    }
                }
            }
            try {
                bis.close();
                baos.close();
            }
            catch (IOException ex) {
                log.error((Object)String.format("Error closing request input stream: %s", ex.getMessage()));
                throw ex;
            }
        }
        this.body = baos.toByteArray();
    }

    public ServletInputStream getInputStream() throws IOException {
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.body);
        ServletInputStream servletInputStream = new ServletInputStream(){

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() throws IOException {
                return byteArrayInputStream.read();
            }
        };
        return servletInputStream;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public String getBody() {
        try {
            return new String(this.body, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(this.body);
        }
    }
}

