/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.common.servlet.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class MoHttpRequestWrapper
extends HttpServletRequestWrapper {
    private final byte[] cachedBody;

    public MoHttpRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        byte[] body;
        try {
            int bytesRead;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ServletInputStream inputStream = request.getInputStream();
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, bytesRead);
            }
            body = baos.toByteArray();
        }
        catch (IOException e) {
            body = new byte[]{};
        }
        this.cachedBody = body;
    }

    public ServletInputStream getInputStream() throws IOException {
        return new ServletInputStream(){
            private final ByteArrayInputStream byteArrayInputStream;
            {
                this.byteArrayInputStream = new ByteArrayInputStream(MoHttpRequestWrapper.this.cachedBody);
            }

            public int read() throws IOException {
                return this.byteArrayInputStream.read();
            }

            public boolean isFinished() {
                return this.byteArrayInputStream.available() == 0;
            }

            public boolean isReady() {
                return true;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }

    public BufferedReader getReader() throws IOException {
        try {
            return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            return new BufferedReader(new InputStreamReader((InputStream)super.getInputStream(), StandardCharsets.UTF_8));
        }
    }

    public String getCachedBody() {
        return new String(this.cachedBody, StandardCharsets.UTF_8);
    }
}

