/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.common.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.velocity.one.six.VelocityTemplateRenderer;
import com.miniorange.crowd.common.handler.MoPlatformDecisionHandler;
import com.miniorange.crowd.common.handler.MoPluginConfigurationManager;
import com.miniorange.crowd.common.servlet.utils.MoHttpUtils;
import com.miniorange.crowd.common.servlet.utils.MoPlatformUtils;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.WebUtils;

@UnrestrictedAccess
public class MoSSOLoginFilter
implements Filter {
    private static Logger LOGGER = LoggerFactory.getLogger(MoSSOLoginFilter.class);
    private MoPluginConfigurationManager settings;
    private I18nResolver i18nResolver;
    private MoPluginConfigurationManager pluginConfigurationManager;
    private VelocityTemplateRenderer renderer;

    public MoSSOLoginFilter(MoPluginConfigurationManager settings, I18nResolver i18nResolver, MoPluginConfigurationManager pluginConfigurationManager, VelocityTemplateRenderer renderer) {
        this.settings = settings;
        this.i18nResolver = i18nResolver;
        this.pluginConfigurationManager = pluginConfigurationManager;
        this.renderer = renderer;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            if (!this.pluginConfigurationManager.isLicenseDefined() || this.pluginConfigurationManager.isEvaluationOrSubscriptionLicense().booleanValue() && (!this.pluginConfigurationManager.isEvaluationOrSubscriptionLicense().booleanValue() || !this.pluginConfigurationManager.isLicenseValid().booleanValue()) && !this.pluginConfigurationManager.hasValidLicenseKey().booleanValue() || this.pluginConfigurationManager.isLicenseExpired().booleanValue()) {
                LOGGER.error("License is not valid or SSO is disabled");
                chain.doFilter(request, response);
                return;
            }
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            String application = this.i18nResolver.getText("my.plugin.platform");
            if (req.getRequestURL().toString().contains("/servicedesk/customer/")) {
                application = "jsd";
            }
            String platform = this.settings.getPlatform();
            MoPlatformUtils platformUtils = MoPlatformDecisionHandler.getPlatFormUtils(platform);
            LOGGER.debug("Inside Login Filter:" + req.getParameter("return_to"));
            if (platformUtils != null && platformUtils.isUserLoggedIn()) {
                LOGGER.debug("Already Logged in");
                chain.doFilter(request, response);
                return;
            }
            if (MoHttpUtils.isCookieSet(req, "samlsso_idp.key") && MoHttpUtils.isCookieSet(req, "SAMLCOOKIE") && (req.getParameter("logout") == null || !StringUtils.equals((CharSequence)req.getParameter("logout"), (CharSequence)"true"))) {
                LOGGER.debug("SSO Failed");
                this.clearCookie(req, resp, "samlsso_idp.key");
                String baseURL = "";
                baseURL = this.pluginConfigurationManager.getBaseUrl();
                HashMap<String, String> context = new HashMap<String, String>();
                context.put("platform", this.i18nResolver.getText("my.plugin.platform"));
                context.put("baseUrl", baseURL);
                if (BooleanUtils.toBoolean((Boolean)this.pluginConfigurationManager.getUseErrorTemplate())) {
                    String result = this.renderer.renderFragment(this.pluginConfigurationManager.getErrorTemplate(), context);
                    response.setContentType("text/html;charset=utf-8");
                    response.getWriter().write(result);
                } else {
                    StringBuilder output = new StringBuilder("<div style='display:none'>");
                    output.append("</div>");
                    output.append("<html> \n<head> \n <meta name='decorator' content='atl.general'> \n <style>  #main.aui-page-panel {  border: 1px solid #ccc;  border-radius: 5px;  margin: 50px auto 0 auto; min-height: 200px; overflow: auto; max-width: 500px; }</style> \n </head> \n <body class='aui-layout aui-theme-default page-type-error'> \n <div class='aui-page-panel' style=''> \n <div class='aui-page-panel-inner'> \n <section class='aui-page-panel-content'> \n <header > \n </header> \n    <div id='page'> \n        <div id='full-height-container'> \n        <div id='login-container'>    \n            <div class='login-section '>  \n                 <div class='aui-message aui-message-error'> \n                    <p>We couldn't sign you in. Please contact your Administrator.<p>  \n                    <p>Click <a href='$baseUrl'>here</a> to go to the login page.</p> \n                 </div> \n             </div> \n         </div>  \n         </div>  \n     </div>  \n  </section> \n </div> \n </div> \n</body> \n</html> ");
                    String result = this.renderer.renderFragment(output.toString(), context);
                    response.setContentType("text/html;charset=utf-8");
                    response.getWriter().write(result);
                    LOGGER.debug("default template used");
                }
                return;
            }
            if (this.settings.getCrowdConnectorSSOConfigMap().size() != 1 && this.settings.getRedirectionRulesMap(application).size() > 0) {
                LOGGER.debug("Zero or multiple idp configured");
                chain.doFilter(request, response);
                return;
            }
            Boolean redirect = false;
            Boolean backdoor = false;
            String idp = "";
            Boolean backdoorEnabled = this.settings.getBackdoorEnabled();
            Boolean enableAutoRedirectDelay = this.settings.getEnableAutoRedirectDelay();
            LOGGER.debug("Application=" + application);
            String defaultIDP = application.equals("jsd") ? this.settings.getDefaultJsdIDP() : this.settings.getDefaultAppIDP();
            LOGGER.debug("Default_IDP=" + defaultIDP);
            if (MoHttpUtils.sanitizeText(req.getParameter(this.settings.getBackdoorKey())) != null) {
                backdoor = MoHttpUtils.sanitizeText(req.getParameter(this.settings.getBackdoorKey())).equals(this.settings.getBackdoorValue());
            }
            if (this.settings.getAutoRedirectToIDP().booleanValue() && this.settings.getCrowdConnectorSSOConfigMap().size() == 1) {
                redirect = true;
            }
            if (this.settings.getRedirectionRulesMap(application).size() == 0 && !defaultIDP.equals("loginPage") && !defaultIDP.equals("redirectUrl")) {
                idp = defaultIDP;
                redirect = this.settings.getCrowdConnectorSSOConfigMap().get(idp).getSsoForJIRASoftware();
            }
            if (!redirect.booleanValue() || enableAutoRedirectDelay.booleanValue() || backdoorEnabled.booleanValue() && backdoor.booleanValue()) {
                LOGGER.debug("No redirection through filter");
                chain.doFilter(request, response);
                return;
            }
            StringBuffer buffer = new StringBuffer(this.settings.getCrowdDomainURL());
            buffer.append(this.settings.getSSOPath());
            String redirectTo = String.valueOf(req.getRequestURL());
            if (req.getParameter("os_destination") != null) {
                String os_destination = MoHttpUtils.sanitizeText(req.getParameter("os_destination")).replaceAll("&amp;", "&");
                redirectTo = req.getRequestURL() + "?os_destination=" + URLEncoder.encode(os_destination, "UTF-8");
            }
            if (req.getParameter("destination") != null) {
                String destination = MoHttpUtils.sanitizeText(req.getParameter("destination")).replaceAll("&amp;", "&");
                redirectTo = req.getRequestURL() + "?destination=" + URLEncoder.encode(destination, "UTF-8");
            }
            LOGGER.debug("redirectTo " + redirectTo);
            if (StringUtils.isNotBlank((CharSequence)redirectTo)) {
                LOGGER.debug("RedirectTo after sanitization and URL encoding " + redirectTo);
                buffer.append("?return_to=").append(URLEncoder.encode(redirectTo, "UTF-8"));
                if (StringUtils.isNotEmpty((CharSequence)idp)) {
                    buffer.append("&idp=").append(idp);
                }
            }
            LOGGER.debug("Redirecting to Idp.");
            LOGGER.debug("Buffer value: " + buffer);
            resp.sendRedirect(buffer.toString());
        }
        catch (Exception e) {
            chain.doFilter(request, response);
            LOGGER.error("Error occurred which redirecting to Idp", (Throwable)e);
        }
    }

    public void destroy() {
    }

    public void clearCookie(HttpServletRequest request, HttpServletResponse response, String cookieName) {
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)cookieName);
        if (cookie != null) {
            cookie.setPath("/");
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
    }
}

