/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.common.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.bamboo.user.LoginInformationManager;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.login.LoginManager;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.spring.container.ContainerManager;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.miniorange.crowd.common.handler.MoPluginConfigurationManager;
import com.miniorange.crowd.common.servlet.utils.CompatibilityRequestWrapper;
import com.miniorange.crowd.common.servlet.utils.RestReadingServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URI;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@UnrestrictedAccess
class MoLoginInterceptorFilter
implements Filter {
    private static Log LOGGER = LogFactory.getLog(MoLoginInterceptorFilter.class);
    private MoPluginConfigurationManager pluginConfigurationManager;
    private I18nResolver i18nResolver;
    private LoginUriProvider loginUriProvider;
    private CrowdService crowdService;

    public MoLoginInterceptorFilter(MoPluginConfigurationManager pluginConfigurationManager, I18nResolver i18nResolver, LoginUriProvider loginUriProvider, CrowdService crowdService) {
        this.pluginConfigurationManager = pluginConfigurationManager;
        this.i18nResolver = i18nResolver;
        this.loginUriProvider = loginUriProvider;
        this.crowdService = crowdService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        LOGGER.debug((Object)"inside init of LoginInterceptor");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block23: {
            LOGGER.debug((Object)"Inside doFilter of LoginInterceptorfilter");
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            if (this.pluginConfigurationManager.getAllowLocalAuthentication().booleanValue()) {
                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
                return;
            }
            try {
                if (this.pluginConfigurationManager.isLicenseDefined() && (!this.pluginConfigurationManager.isEvaluationOrSubscriptionLicense().booleanValue() || this.pluginConfigurationManager.isEvaluationOrSubscriptionLicense().booleanValue() && (this.pluginConfigurationManager.isLicenseValid().booleanValue() || this.pluginConfigurationManager.hasValidLicenseKey().booleanValue()) && !this.pluginConfigurationManager.isLicenseExpired().booleanValue())) {
                    String os_username;
                    HttpServletRequestWrapper cachedRequest;
                    String referer;
                    String jiraCaptcha;
                    String confluenceCaptcha;
                    String application;
                    String username;
                    block22: {
                        username = "";
                        application = this.i18nResolver.getText("my.plugin.platform");
                        String requestUrl = req.getRequestURI();
                        confluenceCaptcha = request.getParameter("captchaResponse");
                        jiraCaptcha = StringUtils.trimToNull((String)request.getParameter("os_captcha"));
                        referer = req.getHeader("referer");
                        cachedRequest = new RestReadingServletRequest(req);
                        cachedRequest = new CompatibilityRequestWrapper((HttpServletRequest)cachedRequest);
                        String requestBody = this.readRequestBody((HttpServletRequest)cachedRequest);
                        LOGGER.debug((Object)("URL=" + req.getRequestURL().toString()));
                        if (req.getRequestURL().toString().contains("/servicedesk/customer/")) {
                            application = "jsd";
                        }
                        LOGGER.debug((Object)("Application : " + application));
                        username = StringUtils.equalsIgnoreCase((CharSequence)application, (CharSequence)"bitbucket") ? request.getParameter("j_username") : (StringUtils.equalsIgnoreCase((CharSequence)application, (CharSequence)"fisheye") ? request.getParameter("username") : request.getParameter("os_username"));
                        LOGGER.debug((Object)"-------------MoLoginInterceptorFilter ---------------------------");
                        LOGGER.debug((Object)("username  : " + username));
                        os_username = request.getParameter("os_username");
                        if (!StringUtils.equalsIgnoreCase((CharSequence)application, (CharSequence)"fisheye") && !StringUtils.equalsIgnoreCase((CharSequence)application, (CharSequence)"bitbucket")) {
                            if (os_username == null) {
                                ObjectMapper mapper = new ObjectMapper();
                                String targetUrl = "";
                                try {
                                    JsonNode bodyNode = mapper.readTree(requestBody);
                                    username = bodyNode.has("username") ? bodyNode.get("username").asText() : "";
                                    jiraCaptcha = bodyNode.has("captchaId") ? bodyNode.get("captchaId").asText() : "";
                                    String string = targetUrl = bodyNode.has("targetUrl") ? bodyNode.get("targetUrl").asText() : "";
                                    if (StringUtils.contains((CharSequence)targetUrl, (CharSequence)"servicedesk")) {
                                        application = "jsd";
                                        break block22;
                                    }
                                    application = "jira";
                                }
                                catch (Exception e) {
                                    LOGGER.error((Object)"Failed to parse request body", (Throwable)e);
                                }
                            } else {
                                username = request.getParameter("os_username");
                                jiraCaptcha = request.getParameter("os_captcha");
                                application = StringUtils.contains((CharSequence)requestUrl, (CharSequence)"servicedesk") ? "jsd" : (this.i18nResolver.getText("my.plugin.platform").equals("bamboo") ? "bamboo" : "jira");
                            }
                        }
                    }
                    if ((referer != null && referer.contains(this.pluginConfigurationManager.getBackdoorKey() + "=" + this.pluginConfigurationManager.getBackdoorValue()) || confluenceCaptcha != null || jiraCaptcha != null && !jiraCaptcha.equals("")) && this.pluginConfigurationManager.getBackdoorEnabled().booleanValue()) {
                        LOGGER.debug((Object)"Backdoor is enabled.Allow user to login");
                    } else if (StringUtils.isNotEmpty((CharSequence)username) && !this.canUseLocalCredentials(username, application).booleanValue()) {
                        LoginManager loginManager;
                        LOGGER.debug((Object)"user is not authorized to access, redirecting user to the error page");
                        if (application.equals("jira")) {
                            loginManager = (LoginManager)ComponentAccessor.getComponentOfType(LoginManager.class);
                            loginManager.onLoginAttempt(req, username, false);
                        } else if (application.equals("confluence")) {
                            loginManager = (com.atlassian.confluence.security.login.LoginManager)ContainerManager.getComponent((String)"loginManager");
                            loginManager.onFailedLoginAttempt(username, req);
                        } else if (application.equals("bamboo")) {
                            LoginInformationManager loginInformationManager = (LoginInformationManager)ContainerManager.getComponent((String)"loginInformationManager");
                            loginInformationManager.incrementFailedCountAndCheckThreshold(username);
                        } else if (application.equals("fisheye")) {
                            LoginInformationManager fisheyeLoginInformationManager = (LoginInformationManager)ContainerManager.getComponent((String)"fisheyeLoginInformationManager");
                            fisheyeLoginInformationManager.incrementFailedCountAndCheckThreshold(username);
                        }
                        if (!StringUtils.equalsIgnoreCase((CharSequence)application, (CharSequence)"fisheye") && !StringUtils.equalsIgnoreCase((CharSequence)application, (CharSequence)"bitbucket") && os_username != null) {
                            resp.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(req)).toString());
                        }
                        return;
                    }
                    chain.doFilter((ServletRequest)cachedRequest, response);
                    break block23;
                }
                chain.doFilter(request, response);
            }
            catch (Exception e) {
                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            }
        }
    }

    public void destroy() {
    }

    private Boolean canUseLocalCredentials(String username, String application) {
        try {
            LOGGER.debug((Object)"Check if user is authorized to login using local credentials");
            JSONObject redirectionRule = this.pluginConfigurationManager.getIDPFromRedirectionRules(application, username);
            String idpName = redirectionRule.get("idpId").toString();
            String defaultRule = "";
            Boolean allowLocalAuthentication = this.pluginConfigurationManager.getAllowLocalAuthentication();
            if (redirectionRule.has("defaultRule")) {
                defaultRule = redirectionRule.get("defaultRule").toString();
            }
            LOGGER.debug((Object)("Found IDP " + idpName));
            LOGGER.debug((Object)("defaultRule " + defaultRule));
            if (StringUtils.isEmpty((CharSequence)idpName) && StringUtils.equalsIgnoreCase((CharSequence)defaultRule, (CharSequence)"loginPage") || StringUtils.equalsIgnoreCase((CharSequence)defaultRule, (CharSequence)"loginPage") || StringUtils.equalsIgnoreCase((CharSequence)idpName, (CharSequence)"loginPage")) {
                return Boolean.TRUE;
            }
            if (!allowLocalAuthentication.booleanValue() && !this.pluginConfigurationManager.getShowLoginPage().booleanValue()) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LOGGER.error((Object)"An error occurred while getting the user's IDP");
            e.printStackTrace();
            return Boolean.FALSE;
        }
    }

    private String readRequestBody(HttpServletRequest request) throws IOException {
        String line;
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader reader = request.getReader();
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
        }
        return stringBuilder.toString();
    }

    private URI getUri(HttpServletRequest request) {
        return URI.create("notAuthorized");
    }

    public MoPluginConfigurationManager getPluginConfigurationManager() {
        return this.pluginConfigurationManager;
    }

    public void setPluginConfigurationManager(MoPluginConfigurationManager pluginConfigurationManager) {
        this.pluginConfigurationManager = pluginConfigurationManager;
    }
}

