/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.common.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.message.I18nResolver;
import com.miniorange.crowd.common.config.MoConnectorConfigAjax;
import com.miniorange.crowd.common.handler.MoPluginConfigurationManager;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@UnrestrictedAccess
public class MoGuestLoginFilter
implements Filter {
    private static Log LOGGER = LogFactory.getLog(MoGuestLoginFilter.class);
    private MoPluginConfigurationManager settings;
    private I18nResolver i18nResolver;
    private MoConnectorConfigAjax connectorConfigAjax;

    public MoGuestLoginFilter(MoPluginConfigurationManager settings, I18nResolver i18nResolver, MoConnectorConfigAjax connectorConfigAjax) {
        this.settings = settings;
        this.i18nResolver = i18nResolver;
        this.connectorConfigAjax = connectorConfigAjax;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String url;
        LOGGER.debug((Object)"doFilter called...");
        HttpServletResponse res = (HttpServletResponse)response;
        HttpServletRequest req = (HttpServletRequest)request;
        if (!(!StringUtils.isBlank((CharSequence)this.getCurrentLoggedInUser()) || this.skipUrl(req).booleanValue() || (url = req.getRequestURL().toString()).matches("(.*)/login.action(.*)") || url.matches("(.*)/index.action(.*)") || url.matches("(.*)/dologin.action(.*)"))) {
            if (this.settings.getConnectorSSOConfig().size() > 0 && !this.settings.getAllowAnonymousAccess().booleanValue()) {
                String contextPath = req.getContextPath();
                LOGGER.debug((Object)("context path = " + contextPath));
                String requestUri = null;
                requestUri = this.settings.getBaseUrl().indexOf(contextPath) < 0 ? req.getRequestURI().toString() : req.getRequestURI().substring(contextPath.length());
                LOGGER.debug((Object)("Request URI: " + requestUri));
                url = this.settings.getBaseUrl() + "/login.action?os_destination=" + URLEncoder.encode(requestUri + (req.getQueryString() != null ? "?" + req.getQueryString() : ""), "UTF-8");
                res.sendRedirect(url);
                return;
            }
            chain.doFilter(request, response);
            return;
        }
        LOGGER.debug((Object)"Skipping url...either login.action or index.action");
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private String getCurrentLoggedInUser() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        LOGGER.debug((Object)("confluence user = " + confluenceUser));
        if (confluenceUser == null) {
            return "";
        }
        LOGGER.debug((Object)(" returning name = " + confluenceUser.getName()));
        return confluenceUser.getName();
    }

    private Boolean skipUrl(HttpServletRequest req) {
        String url = req.getRequestURL().toString();
        if (url.matches("(.*)plugins/servlet/samlsso/logout(.*)") || url.matches("(.*)batch.css(.*)") || url.matches("(.*)batch.js(.*)") || url.matches("(.*)login.js(.*)") || url.matches("(.*)adgs-icons.ttf(.*)") || url.matches("(.*)plugins/servlet/samlsso/moapi(.*)") || url.matches("(.*)/rest(.*)") || url.matches("(.*)forgotuserpassword.action(.*)") || url.matches("(.*)doforgotuserpassword.action(.*)") || url.matches("(.*)resetuserpassword.action(.*)") || url.matches("(.*)signup.action(.*)") || url.matches("(.*)/plugins/servlet/secureshare/accesslink(.*)") || url.matches("(.*)/images/logo/(.*)") || url.matches("(.*)/oauth/consumer-info(.*)") || url.matches("(.*)/plugins/servlet/capabilities(.*)") || url.matches("(.*)/plugins/servlet/samlsso/getconfig(.*)") || url.matches("(.*)/jcaptcha(.*)") || url.matches("(.*)/images(.*)") || url.matches("(.*)/plugins/servlet/samlsso/verifydomain(.*)")) {
            return true;
        }
        return false;
    }
}

