/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.common.config;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.crowd.common.handler.MoPluginConfigurationManager;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoResetSettingsServlet
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoResetSettingsServlet.class);
    @ComponentImport
    private UserManager userManager;
    private MoPluginConfigurationManager pluginConfigurationManager;

    public MoResetSettingsServlet(UserManager userManager, MoPluginConfigurationManager pluginConfigurationManager) {
        this.userManager = userManager;
        this.pluginConfigurationManager = pluginConfigurationManager;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            UserProfile user = this.userManager.getRemoteUser();
            if (user != null && this.userManager.isAdmin(user.getUserKey())) {
                this.pluginConfigurationManager.clearPluginSettings();
                LOGGER.debug((Object)"Plugin setting is clear. Redirecting to the configure action");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"An error occurred while resetting to old plugin configuration ", (Throwable)e);
        }
        response.sendRedirect(this.pluginConfigurationManager.getManageAddOnURL());
    }
}

