/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.common.config;

import com.miniorange.crowd.common.handler.MoPluginConfigurationHandler;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoCrowdDownloadConfigurationsServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoCrowdDownloadConfigurationsServlet.class);
    private MoPluginConfigurationHandler pluginConfigurationsHandler;

    public MoCrowdDownloadConfigurationsServlet(MoPluginConfigurationHandler pluginConfigurationHandler) {
        this.pluginConfigurationsHandler = pluginConfigurationHandler;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        LOGGER.info("Downloading app's Configuration.");
        try {
            String jsonConfigurations = this.pluginConfigurationsHandler.generateConfigurationsJson();
            response.setHeader("Content-Disposition", "attachment; filename=\"app_configurations.json\"");
            response.setHeader("Cache-Control", "max-age=0");
            response.setHeader("Pragma", "");
            response.setContentType("application/json");
            response.getOutputStream().write(jsonConfigurations.getBytes());
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while downloading the json." + e.getMessage());
        }
    }

    public void setPluginConfigurationsHandler(MoPluginConfigurationHandler pluginConfigurationsHandler) {
        this.pluginConfigurationsHandler = pluginConfigurationsHandler;
    }
}

