/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.crowd.bamboo.logout;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.crowd.common.handler.MoPluginConfigurationManager;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoLogoutServlet
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoLogoutServlet.class);
    private MoPluginConfigurationManager pluginConfigurationManager;
    private final TemplateRenderer renderer;

    MoLogoutServlet(MoPluginConfigurationManager pluginConfigurationManager, TemplateRenderer renderer) {
        this.pluginConfigurationManager = pluginConfigurationManager;
        this.renderer = renderer;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug((Object)"Request received in Logout servlet");
        HttpSession session = request.getSession();
        session.invalidate();
        try {
            if (StringUtils.isNotBlank((CharSequence)request.getParameter("slo_con"))) {
                this.handleSAMLLogout(request, response);
                return;
            }
            if (this.pluginConfigurationManager.getEnableSingleLogoutURL().booleanValue()) {
                String redirectLogoutURL = this.pluginConfigurationManager.getCrowdDomainURL() + "/plugins/servlet/saml/logout?Conn_redirect_url=" + this.pluginConfigurationManager.getBaseUrl() + "/plugins/servlet/samlsso/logout?slo_con=confluence";
                MoLogoutServlet.httpRedirect(response, redirectLogoutURL);
                return;
            }
            this.handleSAMLLogout(request, response);
            return;
        }
        catch (IOException ie) {
            LOGGER.error((Object)("Exception while logout :" + ie.getMessage()));
            LOGGER.debug((Object)"session invalidated");
            response.sendRedirect(this.pluginConfigurationManager.getApplicationBaseUrl());
            return;
        }
    }

    public void handleSAMLLogout(HttpServletRequest request, HttpServletResponse response) {
        try {
            if (StringUtils.isNotEmpty((CharSequence)this.pluginConfigurationManager.getLogoutUrl())) {
                LOGGER.debug((Object)("Logout url configured. Rediredting to : " + this.pluginConfigurationManager.getLogoutUrl()));
                this.clearCookie(request, response, "samlsso_idp.key");
                MoLogoutServlet.httpRedirect(response, this.pluginConfigurationManager.getLogoutUrl());
            } else if (this.pluginConfigurationManager.getUseLogoutTemplate().booleanValue()) {
                LOGGER.debug((Object)"Using servlet template");
                this.clearCookie(request, response, "samlsso_idp.key");
                String baseURL = this.pluginConfigurationManager.getApplicationBaseUrl();
                HashMap<String, String> context = new HashMap<String, String>();
                context.put("baseUrl", baseURL);
                String result = this.renderer.renderFragment(this.pluginConfigurationManager.getLogoutTemplate(), context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
            } else {
                LOGGER.debug((Object)"Simple Logout");
                this.clearCookie(request, response, "samlsso_idp.key");
                MoLogoutServlet.httpRedirect(response, this.pluginConfigurationManager.getApplicationBaseUrl());
            }
            return;
        }
        catch (IOException ie) {
            LOGGER.error((Object)("Exception while logout :" + ie.getMessage()));
            return;
        }
    }

    public void clearCookie(HttpServletRequest request, HttpServletResponse response, String cookieName) {
        Cookie cookie = this.getCookie(request, cookieName);
        if (cookie != null) {
            LOGGER.debug((Object)"Cookie found. Deleting the samlsso idp key cookie");
            cookie.setPath("/");
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
    }

    private Cookie getCookie(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                return cookie;
            }
        }
        return null;
    }

    public static void httpRedirect(HttpServletResponse response, String redirectUrl) throws IOException {
        response.sendRedirect(redirectUrl);
    }

    public MoPluginConfigurationManager getPluginConfigurationManager() {
        return this.pluginConfigurationManager;
    }

    public void setPluginConfigurationManager(MoPluginConfigurationManager pluginConfigurationManager) {
        this.pluginConfigurationManager = pluginConfigurationManager;
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }
}

