/*
 * Decompiled with CFR 0.152.
 */
package com.mergebase.util;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;

public class Util {
    private static final int REGULAR_CLOSE = 0;
    private static final int CLOSE_AND_COMMIT = 1;

    public static void close(Object o1) {
        Util.close(o1, null, null, null, null);
    }

    public static void close(Object o1, Object o2) {
        Util.close(o1, o2, null, null, null);
    }

    public static void close(Object o1, Object o2, Object o3) {
        Util.close(o1, o2, o3, null, null);
    }

    public static void close(Object o1, Object o2, Object o3, Object o4) {
        Util.close(o1, o2, o3, o4, null);
    }

    public static void close(Object o1, Object o2, Object o3, Object o4, Object o5) {
        Util.close(0, o1, o2, o3, o4, o5);
    }

    private static void close(int flag, Object ... closeArgs) {
        if (closeArgs == null || closeArgs.length == 0) {
            return;
        }
        LinkedList<Throwable> closingProblems = new LinkedList<Throwable>();
        for (Object o : closeArgs) {
            if (o == null) continue;
            try {
                if (o instanceof ResultSet) {
                    ((ResultSet)o).close();
                    continue;
                }
                if (o instanceof Statement) {
                    ((Statement)o).close();
                    continue;
                }
                if (o instanceof Connection) {
                    ((Connection)o).close();
                    continue;
                }
                if (o instanceof Reader) {
                    ((Reader)o).close();
                    continue;
                }
                if (o instanceof Writer) {
                    ((Writer)o).close();
                    continue;
                }
                if (o instanceof InputStream) {
                    ((InputStream)o).close();
                    continue;
                }
                if (o instanceof OutputStream) {
                    ((OutputStream)o).close();
                    continue;
                }
                if (o instanceof JarFile) {
                    ((JarFile)o).close();
                    continue;
                }
                if (o instanceof ZipFile) {
                    ((ZipFile)o).close();
                    continue;
                }
                if (o instanceof Process) {
                    ((Process)o).destroy();
                    continue;
                }
                if (o instanceof Closeable) {
                    ((Closeable)o).close();
                    continue;
                }
                throw new IllegalArgumentException("cannot close: " + o.getClass());
            }
            catch (Throwable t) {
                closingProblems.add(t);
            }
        }
        if (flag == 1 && !closingProblems.isEmpty()) {
            throw new CloseFailedException(closingProblems);
        }
        if (!closingProblems.isEmpty()) {
            Throwable t = (Throwable)closingProblems.get(0);
            Util.rethrowIfUnchecked(t);
            throw new RuntimeException("Failed to close something: " + t, t);
        }
    }

    public static void rethrowIfUnchecked(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
    }

    private static class CloseFailedException
    extends RuntimeException {
        public final LinkedList<Throwable> closingProblems;

        public CloseFailedException(LinkedList<Throwable> closingProblems) {
            this.closingProblems = closingProblems;
        }
    }
}

