/*
 * Decompiled with CFR 0.152.
 */
package com.mergebase.util;

import com.mergebase.util.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Paths;

public class ToolDownloader {
    private static String JAR_URL = "https://mergebase.com/wrapper/mergebase.jar";

    public static File ensureWrapperDownload(String wrapperPath) throws IOException {
        File file;
        block9: {
            File folder = new File(Paths.get(wrapperPath, ".mergebase/wrapper").toString());
            File file2 = new File(wrapperPath + "/mergebase.jar");
            if (file2.exists()) {
                return file2;
            }
            InputStream is = ToolDownloader.httpGet(JAR_URL, false);
            try {
                folder.mkdirs();
                ToolDownloader.streamToFile(is, file2, false);
                file = file2;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    throw new IOException(e);
                }
            }
            is.close();
        }
        return file;
    }

    private static InputStream httpGet(String url, boolean debug) throws IOException {
        URL u = new URL(url);
        HttpURLConnection c = (HttpURLConnection)u.openConnection();
        c.setInstanceFollowRedirects(false);
        c.connect();
        int httpCode = c.getResponseCode();
        String httpMsg = c.getResponseMessage();
        if (httpCode == 200) {
            return c.getInputStream();
        }
        String msg = "Cannot connect to MergeBase server " + url + ", RESPONSE=" + httpCode + " - " + httpMsg;
        throw new IOException(msg);
    }

    public static long streamToFile(InputStream in, File file, boolean doClose) throws IOException {
        return ToolDownloader.streamToFile(in, file, doClose, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long streamToFile(InputStream in, File file, boolean doClose, boolean doAppend) throws IOException {
        try (FileOutputStream fout = null;){
            fout = new FileOutputStream(file, doAppend);
            long l = ToolDownloader.streamToOut(in, fout, doClose);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long streamToOut(InputStream in, OutputStream out, boolean doClose) throws IOException {
        byte[] buf = new byte[32768];
        long writeCount = 0L;
        try {
            int read = -1;
            do {
                if ((read = in.read(buf)) <= 0) continue;
                writeCount += (long)read;
                out.write(buf, 0, read);
            } while (read >= 0);
        }
        finally {
            IOException ioe = null;
            try {
                out.flush();
                if (doClose) {
                    in.close();
                    out.close();
                    in = null;
                }
                out = null;
            }
            catch (IOException e) {
                ioe = e;
            }
            if (doClose) {
                Util.close(in, (Object)out);
            }
            if (ioe != null) {
                throw ioe;
            }
        }
        return writeCount;
    }
}

