/*
 * Decompiled with CFR 0.152.
 */
package com.mergebase;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.utils.process.ExternalProcess;
import com.mergebase.util.ToolDownloader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class MergebaseTask
implements TaskType {
    @ComponentImport
    private ProcessService processService;

    @Autowired
    public MergebaseTask(ProcessService processService) {
        this.processService = processService;
    }

    public TaskResult execute(TaskContext taskContext) throws TaskException {
        File file = null;
        try {
            file = ToolDownloader.ensureWrapperDownload(Paths.get(taskContext.getRootDirectory().getParent(), new String[0]).toString());
        }
        catch (IOException ioe) {
            throw new TaskException("Could not download MeregBase wrapper", (Throwable)ioe);
        }
        TaskResultBuilder builder = TaskResultBuilder.create((TaskContext)taskContext);
        BuildLogger buildLogger = taskContext.getBuildLogger();
        buildLogger.addBuildLogEntry("Scanning directory with MergeBase");
        ExternalProcess externalProcess = this.runTool(taskContext, file);
        return builder.checkReturnCode(externalProcess, 0).build();
    }

    private ExternalProcess runTool(TaskContext taskContext, File wrapperLocation) {
        ExternalProcess process = this.processService.createExternalProcess((CommonTaskContext)taskContext, new ExternalProcessBuilder().command(this.buildArgs(taskContext.getConfigurationMap(), wrapperLocation)).workingDirectory(taskContext.getWorkingDirectory()));
        process.execute();
        return process;
    }

    private List<String> buildArgs(ConfigurationMap configurationMap, File wrapperLocation) {
        String url = (String)configurationMap.get((Object)"mburl");
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("java");
        arguments.add("-Dmb.customer=" + (String)configurationMap.get((Object)"customerToken"));
        arguments.add("-Dmb.url=" + url);
        arguments.add("-jar");
        arguments.add(wrapperLocation.toPath().toAbsolutePath().toString());
        if (configurationMap.getAsBoolean("debugMode")) {
            arguments.add("--debug");
        }
        if (configurationMap.getAsBoolean("scanAll")) {
            arguments.add("--all");
        }
        if (configurationMap.getAsBoolean("jsonOutput")) {
            arguments.add("--json");
        }
        if (!configurationMap.getAsBoolean("killBuild")) {
            arguments.add("--exitZero");
        }
        arguments.add("--name=" + (String)configurationMap.get((Object)"mbProjectName"));
        arguments.add((String)configurationMap.getOrDefault((Object)"mbFilePath", (Object)"."));
        return arguments;
    }

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }
}

