/*
 * Decompiled with CFR 0.152.
 */
package com.mergebase;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeBaseTaskConfigurator
extends AbstractTaskConfigurator {
    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put("mbProjectName", params.getString("mbProjectName"));
        config.put("killBuild", String.valueOf(params.getBoolean("killBuild")));
        config.put("mbFilePath", params.getString("mbFilePath"));
        config.put("mburl", params.getString("mburl"));
        config.put("customerToken", params.getString("customerToken"));
        config.put("jsonOutput", String.valueOf(params.getBoolean("jsonOutput")));
        config.put("debugMode", String.valueOf(params.getBoolean("debugMode")));
        config.put("scanAll", String.valueOf(params.getBoolean("scanAll")));
        return config;
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("mbProjectName", "");
        context.put("killBuild", false);
        context.put("mbFilePath", ".");
        context.put("mburl", "");
        context.put("customerToken", "");
        context.put("jsonOutput", false);
        context.put("debugMode", false);
        context.put("scanAll", false);
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        context.put("mbProjectName", taskDefinition.getConfiguration().get("mbProjectName"));
        context.put("killBuild", taskDefinition.getConfiguration().get("killBuild"));
        context.put("mbFilePath", taskDefinition.getConfiguration().get("mbFilePath"));
        context.put("mburl", taskDefinition.getConfiguration().get("mburl"));
        context.put("customerToken", taskDefinition.getConfiguration().get("customerToken"));
        context.put("jsonOutput", taskDefinition.getConfiguration().get("jsonOutput"));
        context.put("debugMode", taskDefinition.getConfiguration().get("debugMode"));
        context.put("scanAll", taskDefinition.getConfiguration().get("scanAll"));
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        String scanPathValue;
        super.validate(params, errorCollection);
        String urlValue = params.getString("mburl");
        if (StringUtils.isEmpty((CharSequence)urlValue)) {
            errorCollection.addError("mburl", "You must add your MergeBase Dashboard URL. URL must be entered in the form https://[your-domain].mergebase.com.");
        } else if (!urlValue.toLowerCase(Locale.ROOT).startsWith("https://")) {
            errorCollection.addError("mburl", "You must add your MergeBase Dashboard URL. URL must be entered in the form https://[your-domain].mergebase.com.");
        }
        String tokenValue = params.getString("customerToken");
        if (StringUtils.isEmpty((CharSequence)tokenValue)) {
            errorCollection.addError("customerToken", "You must specify a customer token.");
        }
        if ((scanPathValue = params.getString("mbFilePath")) != null && scanPathValue.contains("../")) {
            errorCollection.addError("mbFilePath", "You cannot specific a path outside the current workspace.");
        }
    }

    public Set<Requirement> calculateRequirements(@NotNull TaskDefinition taskDefinition, @NotNull Job job) {
        return super.calculateRequirements(taskDefinition, job);
    }
}

