/*
 * Decompiled with CFR 0.152.
 */
package com.mabl.test.output;

import com.atlassian.extras.common.log.Logger;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.mabl.domain.ExecutionResult;
import com.mabl.test.output.TestSuite;
import com.mabl.test.output.TestSuiteSerializer;
import com.mabl.test.output.TestSuites;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class JUnitReportSerializer {
    private static final Logger.Log log = Logger.getInstance(JUnitReportSerializer.class);
    private final File reportFile;
    private final List<ExecutionResult.ExecutionSummary> summaries;

    public JUnitReportSerializer(File reportFile, List<ExecutionResult.ExecutionSummary> summaries) {
        this.reportFile = reportFile;
        this.summaries = summaries;
    }

    public void generate() {
        List suites = this.summaries.stream().map(suite -> new TestSuiteSerializer((ExecutionResult.ExecutionSummary)suite).serialize()).collect(Collectors.toList());
        TestSuites testSuites = new TestSuites((ImmutableCollection<TestSuite>)ImmutableList.copyOf(suites));
        this.outputTestSuiteXml(testSuites);
    }

    private void outputTestSuiteXml(TestSuites testSuites) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{TestSuites.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)testSuites, this.reportFile);
        }
        catch (JAXBException e) {
            log.error((Object)"There was an error trying to output test results in mabl.", (Throwable)e);
        }
    }
}

