/*
 * Decompiled with CFR 0.152.
 */
package com.mabl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.mabl.domain.ExecutionResult;
import org.apache.commons.lang.StringUtils;

public class Utils {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private Utils() {
    }

    public static String safePlanName(ExecutionResult.ExecutionSummary summary) {
        return summary.plan != null && !StringUtils.isEmpty((String)summary.plan.name) ? summary.plan.name : "<Unnamed Plan>";
    }

    public static String safeJourneyName(ExecutionResult.ExecutionSummary summary, String journeyId) {
        String journeyName = "<Unnamed Test>";
        for (ExecutionResult.JourneySummary journeySummary : summary.journeys) {
            if (!journeySummary.id.equals(journeyId) || journeySummary.name.isEmpty()) continue;
            journeyName = journeySummary.name;
            break;
        }
        return journeyName;
    }

    public static ObjectMapper getObjectMapperSingleton() {
        return objectMapper;
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        objectMapper.setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategies.SnakeCaseStrategy());
    }
}

