/*
 * Decompiled with CFR 0.152.
 */
package com.mabl;

import com.atlassian.extras.common.log.Logger;
import com.mabl.MablConstants;
import com.mabl.MablRestApiClientRetryHandler;
import com.mabl.ProxyConfiguration;
import com.mabl.Utils;
import com.mabl.domain.CreateDeploymentPayload;
import com.mabl.domain.CreateDeploymentProperties;
import com.mabl.domain.CreateDeploymentResult;
import com.mabl.domain.ExecutionResult;
import com.mabl.domain.GetApiKeyResult;
import com.mabl.domain.GetApplicationsResult;
import com.mabl.domain.GetEnvironmentsResult;
import com.mabl.domain.GetLabelsResult;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;

public class RestApiClient
implements AutoCloseable {
    private final String restApiBaseUrl;
    private final String restApiKey;
    private final ProxyConfiguration proxyConfiguration;
    private final HttpClientContext httpClientContext;
    private final CloseableHttpClient httpClient;
    private final Logger.Log log = Logger.getInstance(this.getClass());
    static final String REST_API_USERNAME_PLACEHOLDER = "key";
    static final Header JSON_TYPE_HEADER = new BasicHeader("Content-Type", "application/json");
    static final String DEPLOYMENT_TRIGGER_ENDPOINT = "/events/deployment";
    static final String DEPLOYMENT_RESULT_ENDPOINT_TEMPLATE = "/execution/result/event/%s";
    static final String GET_API_KEY_ENDPOINT = "/apiKeys/self";
    static final String GET_APPLICATIONS_ENDPOINT_TEMPLATE = "/applications?organization_id=%s";
    static final String GET_ENVIRONMENTS_ENDPOINT_TEMPLATE = "/environments?organization_id=%s";
    static final String GET_LABELS_ENDPOINT_TEMPLATE = "/schedule/runPolicy/labels?organization_id=%s";

    public RestApiClient(String restApiBaseUrl, String restApiKey, ProxyConfiguration proxyConfiguration) {
        this.restApiBaseUrl = restApiBaseUrl;
        HttpHost apiHost = HttpHost.create((String)restApiBaseUrl);
        this.restApiKey = restApiKey;
        this.proxyConfiguration = proxyConfiguration;
        CredentialsProvider credentialsProvider = RestApiClient.getCredentialsProvider(restApiKey, apiHost, proxyConfiguration);
        RequestConfig requestConfig = RestApiClient.requestConfig(proxyConfiguration);
        this.httpClientContext = RestApiClient.httpClientContext(apiHost, credentialsProvider);
        this.httpClient = this.getHttpClient(credentialsProvider, requestConfig);
    }

    public String getRestApiKey() {
        return this.restApiKey;
    }

    public CreateDeploymentResult createDeploymentEvent(String environmentId, String applicationId, Set<String> planLabels, String mablBranch, CreateDeploymentProperties properties) {
        HttpPost request = new HttpPost(this.restApiBaseUrl + DEPLOYMENT_TRIGGER_ENDPOINT);
        request.setEntity((HttpEntity)this.getCreateDeploymentPayloadEntity(environmentId, applicationId, planLabels, mablBranch, properties));
        request.addHeader(JSON_TYPE_HEADER);
        return this.parseApiResult(this.getResponse((HttpUriRequest)request), CreateDeploymentResult.class);
    }

    public ExecutionResult getExecutionResults(String eventId) {
        String url = this.restApiBaseUrl + String.format(DEPLOYMENT_RESULT_ENDPOINT_TEMPLATE, eventId);
        return this.parseApiResult(this.getResponse((HttpUriRequest)new HttpGet(url)), ExecutionResult.class);
    }

    public GetApiKeyResult getApiKeySelf() {
        String url = this.restApiBaseUrl + GET_API_KEY_ENDPOINT;
        return this.parseApiResult(this.getResponse((HttpUriRequest)new HttpGet(url)), GetApiKeyResult.class);
    }

    public GetApplicationsResult getApplicationsResult(String organizationId) {
        String url = this.restApiBaseUrl + String.format(GET_APPLICATIONS_ENDPOINT_TEMPLATE, organizationId);
        return this.parseApiResult(this.getResponse((HttpUriRequest)new HttpGet(url)), GetApplicationsResult.class);
    }

    public GetEnvironmentsResult getEnvironmentsResult(String organizationId) {
        String url = this.restApiBaseUrl + String.format(GET_ENVIRONMENTS_ENDPOINT_TEMPLATE, organizationId);
        return this.parseApiResult(this.getResponse((HttpUriRequest)new HttpGet(url)), GetEnvironmentsResult.class);
    }

    public GetLabelsResult getLabelsResult(String organizationId) {
        String url = this.restApiBaseUrl + String.format(GET_LABELS_ENDPOINT_TEMPLATE, organizationId);
        return this.parseApiResult(this.getResponse((HttpUriRequest)new HttpGet(url)), GetLabelsResult.class);
    }

    private CloseableHttpClient getHttpClient(CredentialsProvider credentialsProvider, RequestConfig requestConfig) {
        return HttpClients.custom().useSystemProperties().setProxy((HttpHost)this.proxyConfiguration.getProxy().orElse(null)).setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy()).setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)this.getRetryHandler()).setDefaultCredentialsProvider(credentialsProvider).setUserAgent(MablConstants.PLUGIN_USER_AGENT).setConnectionTimeToLive(MablConstants.CONNECTION_SECONDS_TO_LIVE.getSeconds(), TimeUnit.SECONDS).setDefaultRequestConfig(requestConfig).build();
    }

    protected MablRestApiClientRetryHandler getRetryHandler() {
        return RestApiClient.getRetryHandler(5, MablConstants.RETRY_HANDLER_RETRY_INTERVAL.toMillis());
    }

    protected static MablRestApiClientRetryHandler getRetryHandler(int maxRetries, long retryInterval) {
        return new MablRestApiClientRetryHandler(maxRetries, retryInterval);
    }

    private static CredentialsProvider getCredentialsProvider(String restApiKey, HttpHost apiHost, ProxyConfiguration proxyConfiguration) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        UsernamePasswordCredentials apiCreds = new UsernamePasswordCredentials(REST_API_USERNAME_PLACEHOLDER, restApiKey);
        provider.setCredentials(new AuthScope(apiHost), (Credentials)apiCreds);
        proxyConfiguration.getProxy().ifPresent(arg_0 -> RestApiClient.lambda$getCredentialsProvider$1(proxyConfiguration, (CredentialsProvider)provider, arg_0));
        return provider;
    }

    private static RequestConfig requestConfig(ProxyConfiguration proxyConfiguration) {
        return RequestConfig.custom().setConnectTimeout(Math.toIntExact(MablConstants.CONNECTION_TIMEOUT.toMillis())).setConnectionRequestTimeout(Math.toIntExact(MablConstants.CONNECTION_TIMEOUT.toMillis())).setSocketTimeout(Math.toIntExact(MablConstants.REQUEST_TIMEOUT.toMillis())).setProxy((HttpHost)proxyConfiguration.getProxy().orElse(null)).setProxyPreferredAuthSchemes(Collections.singletonList("Basic")).setTargetPreferredAuthSchemes(Collections.singletonList("Basic")).build();
    }

    private static HttpClientContext httpClientContext(HttpHost apiHost, CredentialsProvider credentialsProvider) {
        BasicAuthCache authCache = new BasicAuthCache();
        authCache.put(apiHost, (AuthScheme)new BasicScheme());
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider(credentialsProvider);
        context.setAuthCache((AuthCache)authCache);
        return context;
    }

    private AbstractHttpEntity getCreateDeploymentPayloadEntity(String environmentId, String applicationId, Set<String> planLabels, String mablBranch, CreateDeploymentProperties properties) {
        try {
            String jsonPayload = Utils.getObjectMapperSingleton().writeValueAsString((Object)new CreateDeploymentPayload(environmentId, applicationId, planLabels.isEmpty() ? null : planLabels, StringUtils.isEmpty((String)mablBranch) ? null : mablBranch, properties));
            return new ByteArrayEntity(jsonPayload.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            this.log.error((Object)String.format("Unable to create payloadEntity. Reason: '%s'", e.getMessage()));
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private HttpResponse getResponse(HttpUriRequest request) {
        try {
            return this.httpClient.execute(request, (HttpContext)this.httpClientContext);
        }
        catch (IOException e) {
            this.log.error((Object)String.format("Encountered exception trying to reach '%s'. Reason: '%s'", request.getURI(), e.getMessage()));
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private <ApiResult> ApiResult parseApiResult(HttpResponse response, Class<ApiResult> resultClass) {
        int statusCode = response.getStatusLine().getStatusCode();
        switch (statusCode) {
            case 200: 
            case 201: {
                return this.mapObject(response, resultClass);
            }
        }
        String message = String.format("Unexpected status returned from parse Api result during fetch %d%n: [%s]", statusCode, response.getStatusLine().getReasonPhrase());
        this.log.error((Object)message);
        throw new RuntimeException(message);
    }

    private <ApiResult> ApiResult mapObject(HttpResponse response, Class<ApiResult> resultClass) {
        try {
            return resultClass.cast(Utils.getObjectMapperSingleton().readerFor(resultClass).readValue(response.getEntity().getContent()));
        }
        catch (IOException e) {
            this.log.error((Object)String.format("Encountered exception trying to decode '%s'. Reason: '%s'", resultClass.getName(), e.getMessage()));
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void close() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                this.log.error((Object)String.format("Encountered exception trying to close httpClient. Reason: '%s'", e.getMessage()));
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    private static /* synthetic */ void lambda$getCredentialsProvider$1(ProxyConfiguration proxyConfiguration, CredentialsProvider provider, HttpHost proxy) {
        proxyConfiguration.getCredentials().ifPresent(credentials -> provider.setCredentials(new AuthScope(proxy), credentials));
    }
}

