/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import org.tmatesoft.svn.core.internal.util.SVNCertificateFailureKind;

public class SVNSSLUtil {
    public static StringBuffer getServerCertificatePrompt(X509Certificate cert, String realm, String hostName) {
        return SVNSSLUtil.getServerCertificatePrompt(cert, realm, hostName, EnumSet.noneOf(SVNCertificateFailureKind.class));
    }

    public static StringBuffer getServerCertificatePrompt(X509Certificate cert, String realm, String hostName, EnumSet<SVNCertificateFailureKind> trustCertificateFailureKinds) {
        int failures = SVNSSLUtil.getServerCertificateFailures(cert, hostName);
        int trustMask = SVNCertificateFailureKind.createMask(trustCertificateFailureKinds);
        failures &= ~trustMask;
        StringBuffer prompt = new StringBuffer();
        prompt.append("Error validating server certificate for '");
        prompt.append(realm);
        prompt.append("':\n");
        if ((failures & SVNCertificateFailureKind.UNKNOWN_CA.getCode()) != 0) {
            prompt.append(" - The certificate is not issued by a trusted authority. Use the\n   fingerprint to validate the certificate manually!\n");
        }
        if ((failures & SVNCertificateFailureKind.CN_MISMATCH.getCode()) != 0) {
            prompt.append(" - The certificate hostname does not match.\n");
        }
        if ((failures & SVNCertificateFailureKind.EXPIRED.getCode()) != 0) {
            prompt.append(" - The certificate has expired.\n");
        }
        if ((failures & SVNCertificateFailureKind.NOT_YET_VALID.getCode()) != 0) {
            prompt.append(" - The certificate is not yet valid.\n");
        }
        SVNSSLUtil.getServerCertificateInfo(cert, prompt);
        return prompt;
    }

    private static String getFingerprint(X509Certificate cert) {
        try {
            return SVNSSLUtil.getFingerprint(cert.getEncoded(), "SHA1");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getFingerprint(byte[] key, String digestAlgorithm) {
        StringBuffer s = new StringBuffer();
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm != null ? digestAlgorithm : "SHA1");
            md.update(key);
            byte[] digest = md.digest();
            for (int i = 0; i < digest.length; ++i) {
                int b;
                String hex;
                if (i != 0) {
                    s.append(':');
                }
                if ((hex = Integer.toHexString(b = digest[i] & 0xFF)).length() == 1) {
                    s.append('0');
                }
                s.append(hex.toLowerCase());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s.toString();
    }

    private static void getServerCertificateInfo(X509Certificate cert, StringBuffer info) {
        info.append("Certificate information:");
        info.append('\n');
        info.append(" - Subject: ");
        info.append(cert.getSubjectDN().getName());
        info.append('\n');
        info.append(" - Valid: ");
        info.append("from " + cert.getNotBefore() + " until " + cert.getNotAfter());
        info.append('\n');
        info.append(" - Issuer: ");
        info.append(cert.getIssuerDN().getName());
        info.append('\n');
        info.append(" - Fingerprint: ");
        info.append(SVNSSLUtil.getFingerprint(cert));
    }

    public static int getServerCertificateFailures(X509Certificate cert, String realHostName) {
        String certHostName;
        int index;
        int mask = 8;
        Date time = new Date(System.currentTimeMillis());
        if (time.before(cert.getNotBefore())) {
            mask |= 1;
        }
        if (time.after(cert.getNotAfter())) {
            mask |= 2;
        }
        if ((index = (certHostName = cert.getSubjectDN().getName()).indexOf("CN=")) >= 0) {
            if ((certHostName = certHostName.substring(index += 3)).indexOf(32) >= 0) {
                certHostName = certHostName.substring(0, certHostName.indexOf(32));
            }
            if (certHostName.indexOf(44) >= 0) {
                certHostName = certHostName.substring(0, certHostName.indexOf(44));
            }
        }
        if (!realHostName.equals(certHostName)) {
            try {
                Collection<List<?>> altNames = cert.getSubjectAlternativeNames();
                if (altNames != null) {
                    for (List<?> nameList : altNames) {
                        if (!(nameList instanceof Collection) || ((Collection)nameList).size() < 2) continue;
                        Object[] name = ((Collection)nameList).toArray();
                        Object type = name[0];
                        Object host = name[1];
                        if (!(type instanceof Integer) || !(host instanceof String) || (Integer)type != 2 || !host.equals(realHostName)) continue;
                        return mask;
                    }
                }
            }
            catch (CertificateParsingException e) {
                // empty catch block
            }
            mask |= 4;
        }
        return mask;
    }

    public static class CertificateDoesNotConformConstraints
    extends CertificateException {
        public CertificateDoesNotConformConstraints(String msg, Exception source) {
            super(msg, source);
        }
    }

    public static class CertificateNotTrustedException
    extends CertificateException {
        private static final long serialVersionUID = 4845L;

        public CertificateNotTrustedException(String msg, Throwable parent) {
            super(msg, parent);
        }
    }
}

