/*
 * Decompiled with CFR 0.152.
 */
package com.mabl.test.output;

import com.mabl.test.output.Failure;
import com.mabl.test.output.Properties;
import com.mabl.test.output.Skipped;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="testcase")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TestCase {
    @XmlAttribute(name="classname")
    private String plan;
    @XmlAttribute(name="name")
    private String journey;
    @XmlAttribute(name="time")
    private long duration;
    @XmlAttribute(name="xlink:type")
    private String linkType;
    @XmlAttribute(name="xlink:href")
    private String appHref;
    @XmlElement(name="failure")
    private Failure failure;
    @XmlElement(name="skipped")
    private Skipped skipped;
    @XmlElement(name="properties")
    private Properties properties;

    public TestCase() {
    }

    public TestCase(String plan, String journey, long duration, String appHref) {
        this(plan, journey, duration, appHref, null);
    }

    public TestCase(String plan, String journey, long duration, String appHref, Failure failure) {
        this.plan = plan;
        this.journey = journey;
        this.duration = duration;
        this.linkType = "simple";
        this.appHref = appHref;
        this.failure = failure;
    }

    public void setTestCaseIDs(Collection<String> testCaseIDs) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.addProperty("requirement", String.join((CharSequence)",", testCaseIDs));
    }

    public void setFailure(Failure failure) {
        this.failure = failure;
    }

    public void setSkipped() {
        this.skipped = new Skipped();
    }

    public String getPlan() {
        return this.plan;
    }

    public String getJourney() {
        return this.journey;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getAppHref() {
        return this.appHref;
    }

    public String getLinkType() {
        return this.linkType;
    }

    public Failure getFailure() {
        return this.failure;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Skipped getSkipped() {
        return this.skipped;
    }
}

