/*
 * Decompiled with CFR 0.152.
 */
package com.mabl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;

public class MablRestApiClientRetryHandler
implements ServiceUnavailableRetryStrategy {
    private static final ArrayList<Integer> retryStatusCodes = new ArrayList<Integer>(Arrays.asList(501, 502, 503, 504));
    private final int maxRetries;
    private final long retryIntervalMillis;

    public MablRestApiClientRetryHandler(int maxRetries, long retryIntervalMillis) {
        this.maxRetries = maxRetries;
        this.retryIntervalMillis = retryIntervalMillis;
    }

    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        return (this.is500GetRequestFromContext(context) || this.isRetryStatusCode(response.getStatusLine().getStatusCode())) && executionCount <= this.maxRetries;
    }

    private boolean is500GetRequestFromContext(HttpContext context) {
        return Optional.ofNullable(context).filter(con -> HttpClientContext.class.isAssignableFrom(con.getClass())).map(HttpClientContext.class::cast).filter(this::is500GetRequestFromClientContext).isPresent();
    }

    private boolean is500GetRequestFromClientContext(HttpClientContext context) {
        return Optional.ofNullable(context).filter(con -> Optional.ofNullable(con.getResponse()).map(HttpResponse::getStatusLine).map(StatusLine::getStatusCode).filter(sc -> 500 == sc).isPresent()).filter(con -> Optional.ofNullable(con.getRequest()).map(HttpRequest::getRequestLine).map(RequestLine::getMethod).filter(meth -> StringUtils.equalsIgnoreCase((CharSequence)"GET", (CharSequence)meth)).isPresent()).isPresent();
    }

    public long getRetryInterval() {
        return this.retryIntervalMillis;
    }

    private boolean isRetryStatusCode(int statusCode) {
        return retryStatusCodes.contains(statusCode);
    }
}

