/*
 * Decompiled with CFR 0.152.
 */
package com.mabl;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.build.test.TestReportProvider;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.mabl.Converter;
import com.mabl.MablConstants;
import com.mabl.MablOutputProvider;
import com.mabl.ProxyConfiguration;
import com.mabl.RestApiClient;
import com.mabl.domain.CreateDeploymentProperties;
import com.mabl.domain.CreateDeploymentResult;
import com.mabl.domain.ExecutionResult;
import com.mabl.test.output.JUnitReportSerializer;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

@Scanned
public class CreateDeployment
implements TaskType {
    private final TestCollationService testCollationService;
    private final CustomVariableContext customVariableContext;

    public CreateDeployment(@ComponentImport TestCollationService testCollationService, @ComponentImport CustomVariableContext customVariableContext) {
        this.testCollationService = testCollationService;
        this.customVariableContext = customVariableContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public TaskResult execute(@NotNull TaskContext taskContext) {
        ExecutionResult executionResult;
        File junitReport = new File(taskContext.getWorkingDirectory(), "report.xml");
        BuildLogger buildLogger = taskContext.getBuildLogger();
        TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        MablOutputProvider mablOutputProvider = new MablOutputProvider();
        String formApiKey = (String)taskContext.getConfigurationMap().get((Object)"mablRestApiKey");
        String environmentId = (String)taskContext.getConfigurationMap().get((Object)"mablEnvironmentId");
        String applicationId = (String)taskContext.getConfigurationMap().get((Object)"mablApplicationId");
        String labels = (String)taskContext.getConfigurationMap().get((Object)"mablPlanLabels");
        String mablBranch = (String)taskContext.getConfigurationMap().get((Object)"mablBranch");
        String proxyAddress = (String)taskContext.getConfigurationMap().get((Object)"mablProxyAddress");
        String proxyUsername = (String)taskContext.getConfigurationMap().get((Object)"mablProxyUsername");
        String proxyPassword = (String)taskContext.getConfigurationMap().get((Object)"mablProxyPassword");
        HashSet<String> planLabels = new HashSet<String>();
        if (!labels.isEmpty()) {
            planLabels.addAll(Arrays.asList(labels.split(",")));
        }
        boolean sendEnvVars = this.getSendEnvVarsValue();
        CreateDeploymentProperties properties = this.getMablProperties(sendEnvVars);
        buildLogger.addBuildLogEntry(this.createLogLine("'%s' is set to '%b'. Sending the following properties: '%s'", "mabl.sendvariables", sendEnvVars, properties.toString()));
        ProxyConfiguration proxyConfig = new ProxyConfiguration(proxyAddress, proxyUsername, proxyPassword);
        try (RestApiClient apiClient = new RestApiClient("https://api.mabl.com", formApiKey, proxyConfig);){
            CreateDeploymentResult deployment = apiClient.createDeploymentEvent(environmentId, applicationId, planLabels, mablBranch, properties);
            buildLogger.addBuildLogEntry(this.createLogLine("Created deployment at https://app.mabl.com/workspaces/%s/events/%s", deployment.workspaceId, deployment.id));
            this.customVariableContext.addCustomData("mabl.deployment.id", deployment.id);
            do {
                TimeUnit.MILLISECONDS.sleep(10000L);
                executionResult = apiClient.getExecutionResults(deployment.id);
                if (executionResult == null) {
                    buildLogger.addErrorLogEntry(this.createLogErrorLine("No deployment event found for id '%s' in Mabl.", deployment.id));
                    TaskResult taskResult = taskResultBuilder.failed().build();
                    return taskResult;
                }
                this.logAllJourneyExecutionStatuses(executionResult, buildLogger);
            } while (!this.allPlansComplete(executionResult));
        }
        catch (InterruptedException | RuntimeException e) {
            Thread.currentThread().interrupt();
            buildLogger.addErrorLogEntry(this.createLogErrorLine("Task Execution Exception: '%s'", e.getMessage()));
            return taskResultBuilder.failed().build();
        }
        if (!this.finalOutputStatusAllSuccesses(executionResult, buildLogger, mablOutputProvider)) {
            buildLogger.addErrorLogEntry(this.createLogErrorLine("One or more plans were unsuccessful", new Object[0]));
        } else {
            buildLogger.addBuildLogEntry(this.createLogLine("All plans were successful."));
        }
        new JUnitReportSerializer(junitReport, executionResult.executions).generate();
        this.testCollationService.collateTestResults(taskContext, (TestReportProvider)mablOutputProvider);
        return taskResultBuilder.checkTestFailures().build();
    }

    private CreateDeploymentProperties getMablProperties(boolean sendEnvVars) {
        CreateDeploymentProperties properties = new CreateDeploymentProperties();
        if (sendEnvVars) {
            properties = Converter.customVariableContextToCreateDeploymentProperties.apply(this.customVariableContext);
        }
        properties.setDeploymentOrigin(MablConstants.PLUGIN_USER_AGENT);
        return properties;
    }

    private boolean getSendEnvVarsValue() {
        Map context = this.customVariableContext.getVariableContexts();
        if (!context.containsKey("mabl.sendvariables")) {
            return false;
        }
        return Boolean.parseBoolean(((VariableDefinitionContext)context.get("mabl.sendvariables")).getValue());
    }

    private boolean finalOutputStatusAllSuccesses(ExecutionResult result, BuildLogger buildLogger, MablOutputProvider outputProvider) {
        buildLogger.addBuildLogEntry(this.createLogLine("The final Plan states in Mabl:"));
        HashSet<String> retriedPlanIDs = new HashSet<String>();
        result.executions.stream().filter(CreateDeployment::isRetriedPlanExecution).filter(summary -> summary.plan != null && summary.plan.id != null).forEach(summary -> retriedPlanIDs.add(summary.plan.id));
        for (ExecutionResult.ExecutionSummary summary2 : result.executions) {
            boolean retriedPlanExecution = CreateDeployment.isRetriedPlanExecution(summary2);
            boolean retriedPlan = CreateDeployment.isRetriedPlan(summary2, retriedPlanIDs);
            if (summary2.success || retriedPlan && !retriedPlanExecution) {
                buildLogger.addBuildLogEntry(this.formatPlanLog(false, summary2));
            } else {
                buildLogger.addErrorLogEntry(this.formatPlanLog(true, summary2));
            }
            for (ExecutionResult.TestRunResult testRunResult : summary2.testRunResults) {
                Long duration = null;
                if (testRunResult.stopTime != null && testRunResult.startTime != null) {
                    duration = testRunResult.stopTime - testRunResult.startTime;
                }
                String planName = CreateDeployment.safePlanName(summary2);
                String testName = CreateDeployment.safeJourneyName(summary2, testRunResult.id);
                testName = CreateDeployment.maybeAppendDataTableScenarioName(testName, testRunResult);
                if (testRunResult.success) {
                    outputProvider.addSuccess(planName, testName, duration);
                    continue;
                }
                if ("skipped".equals(testRunResult.status)) {
                    outputProvider.addSkipped(planName, testName);
                    continue;
                }
                if (!retriedPlanExecution && retriedPlan) continue;
                outputProvider.addFailure(planName, testName, duration);
            }
        }
        return result.eventStatus != null && result.eventStatus.succeeded != null && result.eventStatus.succeeded != false;
    }

    private boolean allPlansComplete(ExecutionResult result) {
        boolean isComplete = true;
        for (ExecutionResult.ExecutionSummary summary : result.executions) {
            isComplete &= MablConstants.COMPLETE_STATUSES.contains(summary.status.toLowerCase());
        }
        return isComplete;
    }

    private void logAllJourneyExecutionStatuses(ExecutionResult result, BuildLogger buildLogger) {
        buildLogger.addBuildLogEntry(this.createLogLine("Running Mabl test(s) status update:"));
        if (result.executions.isEmpty()) {
            buildLogger.addErrorLogEntry(this.createLogErrorLine("No executions exists for this plan.", new Object[0]));
        }
        for (ExecutionResult.ExecutionSummary summary : result.executions) {
            this.logPlanExecutionStatuses(summary, buildLogger);
        }
    }

    private void logPlanExecutionStatuses(ExecutionResult.ExecutionSummary planSummary, BuildLogger buildLogger) {
        buildLogger.addBuildLogEntry(this.createLogLine("  %sPlan '%s' is in state '%s'", CreateDeployment.maybeRetryPrefix(planSummary), CreateDeployment.safePlanName(planSummary), planSummary.status));
        for (ExecutionResult.TestRunResult testRunResult : planSummary.testRunResults) {
            Optional.ofNullable(testRunResult.status).ifPresent(status -> buildLogger.addBuildLogEntry(this.createLogLine("    Test '%s' is in state '%s'", CreateDeployment.safeJourneyName(planSummary, testRunResult.id), status)));
        }
    }

    private static String safePlanName(ExecutionResult.ExecutionSummary summary) {
        return summary.plan != null && !StringUtils.isEmpty((String)summary.plan.name) ? summary.plan.name : "<Unnamed Plan>";
    }

    private static String safeJourneyName(ExecutionResult.ExecutionSummary summary, String journeyId) {
        String journeyName = "<Unnamed Test>";
        for (ExecutionResult.JourneySummary journeySummary : summary.journeys) {
            if (!journeySummary.id.equals(journeyId) || journeySummary.name.isEmpty()) continue;
            journeyName = journeySummary.name;
            break;
        }
        return journeyName;
    }

    private static String maybeAppendDataTableScenarioName(String testName, ExecutionResult.TestRunResult testRunResult) {
        if (testRunResult.scenarioName == null) {
            return testName;
        }
        return testName + " (Scenario: " + testRunResult.scenarioName + ")";
    }

    private String createLogErrorLine(String template, Object ... args) {
        return this.createLogHelper(true, template, args);
    }

    private String createLogLine(String logline) {
        return this.createLogHelper(false, logline, new Object[0]);
    }

    private String createLogLine(String template, Object ... args) {
        return this.createLogHelper(false, template, args);
    }

    private String createLogHelper(boolean isError, String template, Object ... args) {
        if (isError) {
            template = "ERROR: " + template;
        }
        return String.format("[mabl]" + template, args);
    }

    private static boolean isRetriedPlan(ExecutionResult.ExecutionSummary summary, Collection<String> retriedPlanIDs) {
        return summary.plan != null && summary.plan.id != null && retriedPlanIDs.contains(summary.plan.id);
    }

    private static boolean isRetriedPlanExecution(ExecutionResult.ExecutionSummary summary) {
        return summary.planExecution != null && summary.planExecution.isRetry;
    }

    private static String maybeRetryPrefix(ExecutionResult.ExecutionSummary summary) {
        return CreateDeployment.isRetriedPlanExecution(summary) ? "RETRY" : "";
    }

    private String formatPlanLog(boolean isError, ExecutionResult.ExecutionSummary summary) {
        String successState = summary.success ? "SUCCEEDED" : "FAILED";
        String planName = CreateDeployment.safePlanName(summary);
        return this.createLogHelper(isError, "%sPlan '%s' has %s with state '%s'", CreateDeployment.maybeRetryPrefix(summary), planName, successState, summary.status);
    }
}

