/*
 * Decompiled with CFR 0.152.
 */
package com.mabl;

import com.atlassian.extras.common.log.Logger;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;

public class ProxyConfiguration {
    private static final Logger.Log log = Logger.getInstance(ProxyConfiguration.class);
    private Optional<HttpHost> maybeProxy = Optional.empty();
    private Optional<Credentials> maybeCredentials = Optional.empty();

    public ProxyConfiguration(String proxyAddress, String proxyUsername, String proxyPassword) {
        if (StringUtils.isNotBlank((CharSequence)proxyAddress)) {
            try {
                HttpHost proxy = HttpHost.create((String)proxyAddress);
                this.maybeProxy = Optional.of(proxy);
                if (StringUtils.isNotBlank((CharSequence)proxyUsername)) {
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                    this.maybeCredentials = Optional.of(credentials);
                }
            }
            catch (RuntimeException exception) {
                log.warn((Object)"Invalid proxy address", (Throwable)exception);
            }
        }
    }

    public Optional<HttpHost> getProxy() {
        return this.maybeProxy;
    }

    public Optional<Credentials> getCredentials() {
        return this.maybeCredentials;
    }
}

