/*
 * Decompiled with CFR 0.152.
 */
package com.mabl.test.output;

import com.atlassian.extras.common.log.Logger;
import com.mabl.Utils;
import com.mabl.domain.ExecutionResult;
import com.mabl.test.output.Failure;
import com.mabl.test.output.TestCase;
import com.mabl.test.output.TestSuite;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;

public class TestSuiteSerializer {
    private static final Logger.Log LOG = Logger.getInstance(TestSuiteSerializer.class);
    private final ExecutionResult.ExecutionSummary summary;

    public TestSuiteSerializer(ExecutionResult.ExecutionSummary summary) {
        this.summary = summary;
    }

    public TestSuite serialize() {
        String timestamp = Instant.ofEpochMilli(this.summary.startTime).toString();
        String planName = Utils.safePlanName(this.summary);
        TestSuite testSuite = new TestSuite(planName, TestSuiteSerializer.getDuration(this.summary), timestamp);
        HashMap<String, SortedSet> testCaseIDs = new HashMap<String, SortedSet>();
        block17: for (ExecutionResult.TestRunResult testRunResult : this.summary.testRunResults) {
            String testName = Utils.safeJourneyName(this.summary, testRunResult.id);
            TestCase testCase = new TestCase(planName, testName, TestSuiteSerializer.getDuration(testRunResult), testRunResult.appHref);
            if (testRunResult.testCases != null && !testRunResult.testCases.isEmpty()) {
                switch (testRunResult.status) {
                    case "failed": 
                    case "completed": 
                    case "skipped": {
                        SortedSet ids = testCaseIDs.computeIfAbsent(testRunResult.status + "-test-cases", k -> new TreeSet());
                        TreeSet<String> newIds = new TreeSet<String>();
                        for (ExecutionResult.TestCaseId id : testRunResult.testCases) {
                            newIds.add(id.caseId);
                        }
                        ids.addAll(newIds);
                        testCase.setTestCaseIDs(newIds);
                        break;
                    }
                }
            }
            testSuite.addToTestCases(testCase).incrementTests();
            if (testRunResult.success || null == testRunResult.status) continue;
            switch (testRunResult.status) {
                case "failed": 
                case "terminated": {
                    Failure failure = new Failure(testRunResult.status, testRunResult.statusCause);
                    testCase.setFailure(failure);
                    testSuite.incrementFailures();
                    continue block17;
                }
                case "skipped": {
                    testCase.setSkipped();
                    testSuite.incrementSkipped();
                    continue block17;
                }
            }
            LOG.warn((Object)String.format("unexpected status '%s' found for test '%s' in plan '%s'%n", testRunResult.status, planName, testName));
        }
        if (!testCaseIDs.isEmpty()) {
            for (Map.Entry entry : testCaseIDs.entrySet()) {
                testSuite.addProperty((String)entry.getKey(), String.join((CharSequence)",", (Iterable)entry.getValue()));
            }
        }
        return testSuite;
    }

    private static long getDuration(ExecutionResult.ExecutionSummary summary) {
        return summary.stopTime != null && summary.startTime != null ? TimeUnit.SECONDS.convert(summary.stopTime - summary.startTime, TimeUnit.MILLISECONDS) : 0L;
    }

    private static long getDuration(ExecutionResult.TestRunResult summary) {
        return summary.stopTime != null && summary.startTime != null ? TimeUnit.SECONDS.convert(summary.stopTime - summary.startTime, TimeUnit.MILLISECONDS) : 0L;
    }
}

