/*
 * Decompiled with CFR 0.152.
 */
package com.mabl;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.http.HttpResponse;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.protocol.HttpContext;

public class MablRestApiClientRetryHandler
implements ServiceUnavailableRetryStrategy {
    private static final ArrayList<Integer> retryStatusCodes = new ArrayList<Integer>(Arrays.asList(501, 502, 503));
    private final int maxRetries;
    private final long retryIntervalMillis;

    public MablRestApiClientRetryHandler(int maxRetries, long retryIntervalMillis) {
        this.maxRetries = maxRetries;
        this.retryIntervalMillis = retryIntervalMillis;
    }

    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        return this.isRetryStatusCode(response.getStatusLine().getStatusCode()) && executionCount <= this.maxRetries;
    }

    public long getRetryInterval() {
        return this.retryIntervalMillis;
    }

    private boolean isRetryStatusCode(int statusCode) {
        return retryStatusCodes.contains(statusCode);
    }
}

