/*
 * Decompiled with CFR 0.152.
 */
package com.mabl;

import com.atlassian.bamboo.build.test.TestCollectionResult;
import com.atlassian.bamboo.build.test.TestCollectionResultBuilder;
import com.atlassian.bamboo.build.test.TestReportProvider;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class MablOutputProvider
implements TestReportProvider {
    public Collection<TestResults> successfulTestResults = Lists.newArrayList();
    public Collection<TestResults> failedTestResults = Lists.newArrayList();
    public Collection<TestResults> skippedTestResults = Lists.newArrayList();

    @NotNull
    public TestCollectionResult getTestCollectionResult() {
        TestCollectionResultBuilder builder = new TestCollectionResultBuilder();
        return builder.addSuccessfulTestResults(this.successfulTestResults).addFailedTestResults(this.failedTestResults).addSkippedTestResults(this.skippedTestResults).build();
    }

    public boolean addSuccess(TestResults testResults) {
        testResults.setState(TestState.SUCCESS);
        return this.successfulTestResults.add(testResults);
    }

    public boolean addSuccess(String className, String methodName, @Nullable Long duration) {
        return this.addSuccess(new TestResults(className, methodName, duration));
    }

    public boolean addFailure(TestResults testResults) {
        testResults.setState(TestState.FAILED);
        return this.failedTestResults.add(testResults);
    }

    public boolean addFailure(String className, String methodName, @Nullable Long duration) {
        return this.addFailure(new TestResults(className, methodName, duration));
    }

    public boolean addSkipped(TestResults testResults) {
        testResults.setState(TestState.SKIPPED);
        return this.skippedTestResults.add(testResults);
    }

    public boolean addSkipped(String className, String methodName) {
        return this.addSkipped(new TestResults(className, methodName, Long.valueOf(0L)));
    }
}

