/*
 * Decompiled with CFR 0.152.
 */
package com.mabl;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.URL;
import java.time.Duration;
import java.util.Enumeration;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.commons.lang3.StringUtils;

class MablConstants {
    static final Set<String> COMPLETE_STATUSES = ImmutableSet.of((Object)"succeeded", (Object)"failed", (Object)"cancelled", (Object)"completed", (Object)"terminated");
    static final long EXECUTION_STATUS_POLLING_INTERNAL_MILLISECONDS = 10000L;
    private static final String PLUGIN_VERSION = MablConstants.getPluginVersion();
    private static final String PLUGIN_VERSION_UNKNOWN = "unknown";
    static final String PLUGIN_USER_AGENT = String.format("mabl-bamboo-plugin/%s (JVM: %s, Bamboo: %s)", PLUGIN_VERSION, System.getProperty("java.version"), MablConstants.getBambooVersion());
    static final String MABL_REST_API_BASE_URL = "https://api.mabl.com";
    static final Duration CONNECTION_TIMEOUT = Duration.ofSeconds(10L);
    static final Duration REQUEST_TIMEOUT = Duration.ofMinutes(30L);
    static final Duration CONNECTION_SECONDS_TO_LIVE = Duration.ofSeconds(30L);
    static final int RETRY_HANDLER_MAX_RETRIES = 5;
    static final Duration RETRY_HANDLER_RETRY_INTERVAL = Duration.ofMillis(6000L);
    static final String MABL_SEND_VARIABLES_FIELD = "mabl.sendvariables";
    static final String REST_API_KEY_FIELD = "mablRestApiKey";
    static final String REST_API_KEY_LABEL_PROPERTY = "createdeployment.restapikey.label";
    static final String APPLICATION_ID_FIELD = "mablApplicationId";
    static final String APPLICATION_ID_LABEL_PROPERTY = "createdeployment.applicationid.label";
    static final String ENVIRONMENT_ID_FIELD = "mablEnvironmentId";
    static final String ENVIRONMENT_ID_LABEL_PROPERTY = "createdeployment.environmentid.label";
    static final String PLAN_LABELS_FIELD = "mablPlanLabels";
    static final String PLAN_LABELS_LABEL_PROPERTY = "createdeployment.planlabels.label";
    static final String MABL_BRANCH_FIELD = "mablBranch";
    static final String PROXY_ADDRESS_FIELD = "mablProxyAddress";
    static final String PROXY_ADDRESS_LABEL_PROPERTY = "createdeployment.proxyaddress.label";
    static final String PROXY_USERNAME_FIELD = "mablProxyUsername";
    static final String PROXY_USERNAME_LABEL_PROPERTY = "createdeployment.proxyusername.label";
    static final String PROXY_PASSWORD_FIELD = "mablProxyPassword";
    static final String PROXY_PASSWORD_LABEL_PROPERTY = "createdeployment.proxypassword.label";
    static final String MABL_LOG_OUTPUT_PREFIX = "[mabl]";
    static final String MABL_JUNIT_REPORT_XML = "report.xml";
    private static final String PLUGIN_SYMBOLIC_NAME = "com.mabl.bamboo.plugin";

    MablConstants() {
    }

    private static String getPluginVersion() {
        try {
            Enumeration<URL> resources = MablConstants.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                Manifest manifest = new Manifest(resources.nextElement().openStream());
                String title = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
                if (!PLUGIN_SYMBOLIC_NAME.equalsIgnoreCase(title)) continue;
                String version = manifest.getMainAttributes().getValue("Bundle-Version");
                return version != null && !version.isEmpty() ? version : PLUGIN_VERSION_UNKNOWN;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return PLUGIN_VERSION_UNKNOWN;
    }

    private static String getBambooVersion() {
        return Optional.ofNullable(System.getProperty("atlassian.sdk.version")).orElseGet(() -> {
            String pluginVersion = System.getenv("AMPS_PLUGIN_VERSION");
            return StringUtils.isEmpty((CharSequence)pluginVersion) ? PLUGIN_VERSION_UNKNOWN : pluginVersion;
        });
    }
}

