/*
 * Decompiled with CFR 0.152.
 */
package com.mabl;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.extras.common.log.Logger;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.mabl.ProxyConfiguration;
import com.mabl.RestApiClient;
import com.mabl.domain.GetApplicationsResult;
import com.mabl.domain.GetEnvironmentsResult;
import com.mabl.domain.GetLabelsResult;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Scanned
public class CreateDeploymentConfigurator
extends AbstractTaskConfigurator {
    private I18nResolver i18nResolver;
    private final Logger.Log log = Logger.getInstance(((Object)((Object)this)).getClass());
    private static final String PROXY_FORMAT_ERROR_TEMPLATE = "%s: Use format <protocol>://<host>:<port>";

    public CreateDeploymentConfigurator(@ComponentImport I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put("mablRestApiKey", params.getString("mablRestApiKey"));
        config.put("mablEnvironmentId", params.getString("mablEnvironmentId"));
        config.put("mablApplicationId", params.getString("mablApplicationId"));
        config.put("mablPlanLabels", StringUtils.join((Object[])params.getStringArray("mablPlanLabels"), (String)","));
        config.put("mablBranch", params.getString("mablBranch"));
        config.put("mablProxyAddress", params.getString("mablProxyAddress"));
        config.put("mablProxyUsername", params.getString("mablProxyUsername"));
        config.put("mablProxyPassword", params.getString("mablProxyPassword"));
        return config;
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("mablRestApiKey", "");
        context.put("mablEnvironmentId", "");
        context.put("mablApplicationId", "");
        context.put("mablPlanLabels", "");
        context.put("mablBranch", "");
        context.put("mablProxyAddress", "");
        context.put("mablProxyUsername", "");
        context.put("mablProxyPassword", "");
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        String restApiKeyValue = (String)taskDefinition.getConfiguration().get("mablRestApiKey");
        String proxyAddress = (String)taskDefinition.getConfiguration().get("mablProxyAddress");
        String proxyUsername = (String)taskDefinition.getConfiguration().get("mablProxyUsername");
        String proxyPassword = (String)taskDefinition.getConfiguration().get("mablProxyPassword");
        ProxyConfiguration proxyConfig = new ProxyConfiguration(proxyAddress, proxyUsername, proxyPassword);
        context.put("mablProxyAddress", proxyAddress);
        context.put("mablProxyUsername", proxyUsername);
        context.put("mablProxyPassword", proxyPassword);
        context.put("mablRestApiKey", restApiKeyValue);
        context.put("mablEnvironmentId", taskDefinition.getConfiguration().get("mablEnvironmentId"));
        context.put("environmentsList", this.getEnvironmentsList(restApiKeyValue, proxyConfig));
        context.put("mablApplicationId", taskDefinition.getConfiguration().get("mablApplicationId"));
        context.put("applicationsList", this.getApplicationsList(restApiKeyValue, proxyConfig));
        context.put("mablPlanLabels", StringUtils.split((String)((String)taskDefinition.getConfiguration().get("mablPlanLabels")), (String)","));
        context.put("planLabelsList", this.getPlanLabelsList(restApiKeyValue, proxyConfig));
        context.put("mablBranch", taskDefinition.getConfiguration().get("mablBranch"));
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        ProxyConfiguration proxyConfig = this.validateProxyConfigs(params, errorCollection);
        String restApiKeyValue = params.getString("mablRestApiKey");
        String restApiKeyLabel = this.getLabel("createdeployment.restapikey.label");
        if (StringUtils.isBlank((CharSequence)restApiKeyValue)) {
            errorCollection.addError("mablRestApiKey", String.format("'%s' is required.", restApiKeyLabel));
        } else if (!this.restApiKeyIsValid(restApiKeyValue, proxyConfig)) {
            errorCollection.addError("mablRestApiKey", String.format("The entered '%s' is invalid.", restApiKeyLabel));
        }
        String environmentIdValue = params.getString("mablEnvironmentId");
        String applicationIdValue = params.getString("mablApplicationId");
        if (StringUtils.isBlank((CharSequence)environmentIdValue) && StringUtils.isBlank((CharSequence)applicationIdValue)) {
            String error = String.format("One of '%s' or '%s' is required.", this.getLabel("createdeployment.environmentid.label"), this.getLabel("createdeployment.applicationid.label"));
            errorCollection.addError("mablEnvironmentId", error);
            errorCollection.addError("mablApplicationId", error);
        }
    }

    private ProxyConfiguration validateProxyConfigs(ActionParametersMap params, ErrorCollection errorCollection) {
        String proxyAddress = params.getString("mablProxyAddress");
        if (!StringUtils.isBlank((CharSequence)proxyAddress)) {
            try {
                HttpHost proxy = HttpHost.create((String)proxyAddress);
                if (StringUtils.isBlank((CharSequence)proxy.getHostName())) {
                    errorCollection.addError("mablProxyAddress", String.format(PROXY_FORMAT_ERROR_TEMPLATE, "No hostname specified"));
                }
            }
            catch (Exception exception) {
                errorCollection.addError("mablProxyAddress", String.format(PROXY_FORMAT_ERROR_TEMPLATE, "Invalid proxy address provided"));
            }
        }
        String proxyUsername = params.getString("mablProxyUsername");
        String proxyPassword = params.getString("mablProxyPassword");
        return new ProxyConfiguration(proxyAddress, proxyUsername, proxyPassword);
    }

    private Map<String, String> getApplicationsList(String restApiKey, ProxyConfiguration proxyConfig) {
        HashMap<String, String> appMap = new HashMap<String, String>();
        try (RestApiClient apiClient = new RestApiClient("https://api.mabl.com", restApiKey, proxyConfig);){
            String organizationId = apiClient.getApiKeySelf().organization_id;
            GetApplicationsResult results = apiClient.getApplicationsResult(organizationId);
            for (GetApplicationsResult.Application application : results.applications) {
                appMap.put(application.id, application.name);
            }
        }
        catch (RuntimeException e) {
            this.log.error((Object)String.format("Unexpected results trying to fetch ApplicationsList: Reason '%s'", e.getMessage()));
        }
        return appMap;
    }

    private Map<String, String> getEnvironmentsList(String restApiKey, ProxyConfiguration proxyConfig) {
        HashMap<String, String> envMap = new HashMap<String, String>();
        try (RestApiClient apiClient = new RestApiClient("https://api.mabl.com", restApiKey, proxyConfig);){
            String organizationId = apiClient.getApiKeySelf().organization_id;
            GetEnvironmentsResult results = apiClient.getEnvironmentsResult(organizationId);
            for (GetEnvironmentsResult.Environment environment : results.environments) {
                envMap.put(environment.id, environment.name);
            }
        }
        catch (RuntimeException e) {
            this.log.error((Object)String.format("Unexpected results trying to fetch EnvironmentsList: Reason '%s'", e.getMessage()));
        }
        return envMap;
    }

    private Map<String, String> getPlanLabelsList(String restApiKey, ProxyConfiguration proxyConfig) {
        HashMap<String, String> envMap = new HashMap<String, String>();
        try (RestApiClient apiClient = new RestApiClient("https://api.mabl.com", restApiKey, proxyConfig);){
            String organizationId = apiClient.getApiKeySelf().organization_id;
            GetLabelsResult results = apiClient.getLabelsResult(organizationId);
            for (GetLabelsResult.Label label : results.labels) {
                envMap.put(label.name, label.name);
            }
        }
        catch (RuntimeException e) {
            this.log.error((Object)String.format("Unexpected results trying to fetch LabelsList: Reason '%s'", e.getMessage()));
        }
        return envMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean restApiKeyIsValid(String restApiKey, ProxyConfiguration proxyConfig) {
        try (RestApiClient apiClient = new RestApiClient("https://api.mabl.com", restApiKey, proxyConfig);){
            String organizationId = apiClient.getApiKeySelf().organization_id;
            boolean bl = StringUtils.isNotBlank((CharSequence)organizationId);
            return bl;
        }
        catch (RuntimeException e) {
            this.log.error((Object)String.format("Unexpected results trying to validate ApiKey: Reason '%s'", e.getMessage()));
            return false;
        }
    }

    private String getLabel(String key) {
        return this.i18nResolver.getText(key);
    }
}

