/*
 * Decompiled with CFR 0.152.
 */
package com.lifeincodes.issuepreview.bamboo.component;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.bamboo.applinks.CredentialsRequiredContextException;
import com.atlassian.bamboo.jira.jiraissues.JiraRemoteIssueManager;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.ResponseException;
import com.lifeincodes.issuepreview.bamboo.component.IssuePreviewComponent;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IssuePreviewComponentImpl
implements IssuePreviewComponent {
    private static final Logger LOG = LoggerFactory.getLogger(IssuePreviewComponentImpl.class);
    private static final String ISSUE_PREVIEW_FOR_JIRA_URL = "/rest/issuepreview/latest/getissue/";
    @ComponentImport
    private final ApplicationLinkService applicationLinkService;
    @ComponentImport
    private final JiraRemoteIssueManager jiraRemoteIssueManager;
    @ComponentImport
    private final ProjectManager projectManager;

    @Inject
    public IssuePreviewComponentImpl(ApplicationLinkService applicationLinkService, JiraRemoteIssueManager jiraRemoteIssueManager, ProjectManager projectManager) {
        this.applicationLinkService = applicationLinkService;
        this.jiraRemoteIssueManager = jiraRemoteIssueManager;
        this.projectManager = projectManager;
    }

    @Override
    public String getIssuePreview(String issueKey, String bambooProjectKey, String issueURL, String source) throws CredentialsRequiredException, ResponseException {
        ApplicationLink jiraApplicationLink = issueURL == null ? this.getApplicationLink(issueKey, bambooProjectKey) : this.getApplicationLink(issueURL);
        if (jiraApplicationLink == null) {
            return null;
        }
        ApplicationLinkRequest request = jiraApplicationLink.createImpersonatingAuthenticatedRequestFactory().createRequest(Request.MethodType.GET, jiraApplicationLink.getRpcUrl() + ISSUE_PREVIEW_FOR_JIRA_URL + issueKey + "?source=" + source);
        return request.execute();
    }

    private ApplicationLink getApplicationLink(String issueKey, String bambooProjectKey) {
        Project bambooProject = this.projectManager.getProjectByKey(bambooProjectKey);
        if (issueKey == null || !issueKey.contains("-") || bambooProject == null) {
            return null;
        }
        try {
            String jiraProjectKey = issueKey.substring(0, issueKey.indexOf("-"));
            return this.jiraRemoteIssueManager.getJiraApplicationLink(jiraProjectKey, bambooProject);
        }
        catch (CredentialsRequiredContextException | ResponseException e) {
            LOG.error("cannot connect to jira application link for issue key: " + issueKey);
            return null;
        }
    }

    private ApplicationLink getApplicationLink(String issueURL) {
        for (ApplicationLink applicationLink : this.applicationLinkService.getApplicationLinks()) {
            if (!"jira".equals(applicationLink.getType().toString()) || !issueURL.startsWith(applicationLink.getRpcUrl().toString())) continue;
            return applicationLink;
        }
        return null;
    }
}

