/*
 * Decompiled with CFR 0.152.
 */
package com.lifeincodes.issuepreview.bamboo.rest;

import com.atlassian.applinks.api.CredentialsRequiredException;
import com.lifeincodes.issuepreview.bamboo.component.IssuePreviewComponent;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/getissue")
public class IssuePreviewRest {
    private static final Logger LOG = LoggerFactory.getLogger(IssuePreviewRest.class);
    private final IssuePreviewComponent issuePreviewComponent;

    @Inject
    public IssuePreviewRest(IssuePreviewComponent issuePreviewComponent) {
        this.issuePreviewComponent = issuePreviewComponent;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{issueKey}")
    public Response getIssuePreview(@PathParam(value="issueKey") String issueKey, @QueryParam(value="issueURL") String issueURL, @QueryParam(value="bambooProjectKey") String bambooProjectKey, @QueryParam(value="source") String source) {
        LOG.info("/getissue/{}?issueURL={}&bambooProjectKey={}&source={}", (Object[])new String[]{issueKey, issueURL, bambooProjectKey, source});
        try {
            long startTime = System.currentTimeMillis();
            if ("null".equals(issueKey)) {
                issueKey = null;
            }
            if ("null".equals(issueURL)) {
                issueURL = null;
            }
            if ("null".equals(bambooProjectKey)) {
                bambooProjectKey = null;
            }
            String model = this.issuePreviewComponent.getIssuePreview(issueKey, bambooProjectKey, issueURL, source);
            LOG.debug("elapsedTime: {} milliseconds", (Object)(System.currentTimeMillis() - startTime));
            return Response.ok((Object)model).build();
        }
        catch (CredentialsRequiredException e) {
            LOG.debug("Issue Preview for Bamboo error: {}", (Object)e.getMessage());
            return null;
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }
}

