/*
 * Decompiled with CFR 0.152.
 */
package com.leapwork.leapwork_integration_for_bamboo.impl;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.utils.SystemProperty;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.leapwork.leapwork_integration_for_bamboo.impl.Utils;
import com.leapwork.leapwork_integration_for_bamboo.model.Failure;
import com.leapwork.leapwork_integration_for_bamboo.model.InvalidSchedule;
import com.leapwork.leapwork_integration_for_bamboo.model.LeapworkRun;
import com.leapwork.leapwork_integration_for_bamboo.model.RunCollection;
import com.leapwork.leapwork_integration_for_bamboo.model.RunItem;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Response;

public final class PluginHandler {
    private static PluginHandler pluginHandler = null;
    public static final String scheduleSeparatorRegex = "\r\n|\n|\\s+,\\s+|,\\s+|\\s+,|,";
    private static final String variableSeparatorRegex = "\\s+:\\s+|:\\s+|\\s+:|:";
    private static final String pathSeparatorRegex = "\\\\|\\/|\\|";
    private static final String STRING_EMPTY = "";

    private PluginHandler() {
    }

    public static PluginHandler getInstance() {
        if (pluginHandler == null) {
            pluginHandler = new PluginHandler();
        }
        return pluginHandler;
    }

    public String getScheduleVariablesRequestPart(String rawScheduleVariables, BuildLogger buildLogger) {
        if (Utils.isBlank(rawScheduleVariables)) {
            return STRING_EMPTY;
        }
        LinkedHashMap variables = new LinkedHashMap();
        String[] rawSplittedKeyValuePairs = rawScheduleVariables.split(scheduleSeparatorRegex);
        String[] stringArray = rawSplittedKeyValuePairs;
        int n = rawSplittedKeyValuePairs.length;
        int n2 = 0;
        while (n2 < n) {
            String rawKeyValuePair = stringArray[n2];
            String[] splittedKeyAndValue = rawKeyValuePair.split(variableSeparatorRegex);
            if (splittedKeyAndValue.length < 2) {
                buildLogger.addBuildLogEntry(String.format("Failed to parse variable: %1$s", rawKeyValuePair));
            } else {
                String key = splittedKeyAndValue[0];
                String value = splittedKeyAndValue[1];
                if (Utils.isBlank(key) || Utils.isBlank(value)) {
                    buildLogger.addBuildLogEntry(String.format("Failed to parse variable: %1$s", rawKeyValuePair));
                } else if (!Utils.tryAddToMap(variables, key, value)) {
                    buildLogger.addBuildLogEntry(String.format("Key value pair with the same key already exists: %1$s. This pair will be ignored", rawKeyValuePair));
                }
            }
            ++n2;
        }
        if (variables.isEmpty()) {
            return STRING_EMPTY;
        }
        String prefix = "?";
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : variables.entrySet()) {
            stringBuilder.append(prefix).append((String)entry.getKey()).append("=").append((String)entry.getValue());
            prefix = "&";
        }
        String string = stringBuilder.toString();
        buildLogger.addBuildLogEntry(String.format("Schedule variables request part: %1$s", string));
        return string;
    }

    public ArrayList<String> getRawScheduleList(String rawScheduleIds, String rawScheduleTitles) {
        ArrayList<String> rawScheduleList = new ArrayList<String>();
        String[] schidsArray = rawScheduleIds.split(scheduleSeparatorRegex);
        String[] testsArray = rawScheduleTitles.split(scheduleSeparatorRegex);
        rawScheduleList.addAll(Arrays.asList(schidsArray));
        rawScheduleList.addAll(Arrays.asList(testsArray));
        rawScheduleList.removeIf(sch -> sch.trim().length() == 0);
        return rawScheduleList;
    }

    public int getTimeDelay(String rawTimeDelay, BuildLogger buildLogger) {
        int defaultTimeDelay = 3;
        try {
            if (!rawTimeDelay.isEmpty() || !STRING_EMPTY.equals(rawTimeDelay)) {
                return Integer.parseInt(rawTimeDelay);
            }
            buildLogger.addBuildLogEntry(String.format("Time delay number is invalid, setting to default %1$s", defaultTimeDelay));
            return defaultTimeDelay;
        }
        catch (Exception e) {
            buildLogger.addErrorLogEntry(String.format("Time delay number is invalid, setting to default %1$s", defaultTimeDelay));
            return defaultTimeDelay;
        }
    }

    public boolean isDoneStatusAsSuccess(String doneStatusAs) {
        return doneStatusAs.contentEquals("Success");
    }

    public String getControllerApiHttpAdderess(String hostname, boolean isHttpsEnabled, String rawPort, BuildLogger buildLogger) {
        StringBuilder stringBuilder = new StringBuilder();
        int port = this.getPortNumber(rawPort, isHttpsEnabled, buildLogger);
        if (isHttpsEnabled) {
            stringBuilder.append("https://").append(hostname).append(":").append(port);
        } else {
            stringBuilder.append("http://").append(hostname).append(":").append(port);
        }
        return stringBuilder.toString();
    }

    private int getPortNumber(String rawPortStr, boolean isHttpsEnabled, BuildLogger buildLogger) {
        int defaultHttpPortNumber = 9001;
        int defaultHttpsPortNumber = 9002;
        try {
            if (!rawPortStr.isEmpty() || !STRING_EMPTY.equals(rawPortStr)) {
                return Integer.parseInt(rawPortStr);
            }
            int defaultPortNumber = isHttpsEnabled ? defaultHttpsPortNumber : defaultHttpPortNumber;
            buildLogger.addErrorLogEntry(String.format("Port number is invalid, setting to default %1$d", defaultPortNumber));
            return defaultPortNumber;
        }
        catch (Exception e) {
            int defaultPortNumber = isHttpsEnabled ? defaultHttpsPortNumber : defaultHttpPortNumber;
            buildLogger.addErrorLogEntry(String.format("Port number is invalid, setting to default %1$d", defaultPortNumber));
            return defaultPortNumber;
        }
    }

    public LinkedHashMap<UUID, String> getSchedulesIdTitleHashMap(AsyncHttpClient client, String accessKey, String controllerApiHttpAddress, ArrayList<String> rawScheduleList, BuildLogger buildLogger, ArrayList<InvalidSchedule> invalidSchedules) throws Exception {
        LinkedHashMap<UUID, String> schedulesIdTitleHashMap = new LinkedHashMap<UUID, String>();
        ArrayList<String> tempRawScheduleList = new ArrayList<String>(rawScheduleList);
        String scheduleListUri = String.format("%1$s/api/v4/schedules", controllerApiHttpAddress);
        Collections.sort(rawScheduleList);
        try {
            Response response = (Response)((BoundRequestBuilder)client.prepareGet(scheduleListUri).setHeader((CharSequence)"AccessKey", accessKey)).execute().get();
            switch (response.getStatusCode()) {
                case 200: {
                    JsonParser parser = new JsonParser();
                    JsonArray jsonScheduleList = parser.parse(response.getResponseBody()).getAsJsonArray();
                    for (String rawSchedule : rawScheduleList) {
                        boolean successfullyMapped = false;
                        for (JsonElement jsonScheduleElement : jsonScheduleList) {
                            JsonObject jsonSchedule = jsonScheduleElement.getAsJsonObject();
                            if (jsonSchedule.get("Type").getAsString().contentEquals("TemporaryScheduleInfo")) continue;
                            UUID Id = Utils.defaultUuidIfNull(jsonSchedule.get("Id"), UUID.randomUUID());
                            String Title = Utils.defaultStringIfNull(jsonSchedule.get("Title"), "null Title");
                            boolean isEnabled = Utils.defaultBooleanIfNull(jsonSchedule.get("IsEnabled"), false);
                            if (Id.toString().contentEquals(rawSchedule)) {
                                if (!schedulesIdTitleHashMap.containsValue(Title) && tempRawScheduleList.contains(Id.toString())) {
                                    tempRawScheduleList.remove(Id.toString());
                                    tempRawScheduleList.remove(Title);
                                    if (isEnabled) {
                                        schedulesIdTitleHashMap.put(Id, Title);
                                        buildLogger.addBuildLogEntry(String.format("Schedule %1$s[%2$s] successfully detected!", Title, rawSchedule));
                                    } else {
                                        invalidSchedules.add(new InvalidSchedule(rawSchedule, String.format("Schedule %1$s[%2$s] is disabled!", Title, Id)));
                                        buildLogger.addBuildLogEntry(String.format("Schedule %1$s[%2$s] is disabled!", Title, Id));
                                    }
                                }
                                successfullyMapped = true;
                            }
                            if (!Title.contentEquals(rawSchedule)) continue;
                            if (!schedulesIdTitleHashMap.containsKey(Id) && tempRawScheduleList.contains(Title)) {
                                tempRawScheduleList.remove(Id.toString());
                                tempRawScheduleList.remove(Title);
                                if (isEnabled) {
                                    schedulesIdTitleHashMap.put(Id, Title);
                                    buildLogger.addBuildLogEntry(String.format("Schedule %1$s[%2$s] successfully detected!", Title, rawSchedule));
                                } else {
                                    invalidSchedules.add(new InvalidSchedule(rawSchedule, String.format("Schedule %1$s[%2$s] is disabled!", Title, Id)));
                                }
                            }
                            successfullyMapped = true;
                        }
                        if (successfullyMapped) continue;
                        invalidSchedules.add(new InvalidSchedule(rawSchedule, "No such schedule! This may occur if try to run schedule that controller does not have. It can be deleted. Or you simply have forgotten to select schedules after changing controller address;"));
                    }
                    break;
                }
                case 401: {
                    StringBuilder errorMessage401 = new StringBuilder(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                    this.appendLine(errorMessage401, "Invalid or empty access key!");
                    PluginHandler.OnFailedToGetScheduleTitleIdMap(null, errorMessage401.toString(), buildLogger);
                }
                case 500: {
                    StringBuilder errorMessage500 = new StringBuilder(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                    this.appendLine(errorMessage500, "Controller responded with errors! Please check controller logs and try again! If does not help, try to restart controller.");
                    PluginHandler.OnFailedToGetScheduleTitleIdMap(null, errorMessage500.toString(), buildLogger);
                }
                default: {
                    StringBuilder errorMessage = new StringBuilder(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                    PluginHandler.OnFailedToGetScheduleTitleIdMap(null, errorMessage.toString(), buildLogger);
                    break;
                }
            }
        }
        catch (ConnectException | UnknownHostException e) {
            String connectionErrorMessage = String.format("Could not connect to %1$s! Check it and try again! ", e.getMessage());
            PluginHandler.OnFailedToGetScheduleTitleIdMap(e, connectionErrorMessage, buildLogger);
        }
        catch (InterruptedException e) {
            String interruptedExceptionMessage = String.format("Interrupted exception: %1$s!", e.getMessage());
            PluginHandler.OnFailedToGetScheduleTitleIdMap(e, interruptedExceptionMessage, buildLogger);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ConnectException || e.getCause() instanceof UnknownHostException) {
                String connectionErrorMessage = String.format("Could not connect to %1$s! Check it and try again! ", e.getCause().getMessage());
                PluginHandler.OnFailedToGetScheduleTitleIdMap(e, connectionErrorMessage, buildLogger);
            } else {
                String executionExceptionMessage = String.format("Execution exception: %1$s!", e.getMessage());
                PluginHandler.OnFailedToGetScheduleTitleIdMap(e, executionExceptionMessage, buildLogger);
            }
        }
        catch (IOException e) {
            String ioExceptionMessage = String.format("I/O exception: %1$s!", e.getMessage());
            PluginHandler.OnFailedToGetScheduleTitleIdMap(e, ioExceptionMessage, buildLogger);
        }
        return schedulesIdTitleHashMap;
    }

    private static HashMap<UUID, String> OnFailedToGetScheduleTitleIdMap(Exception e, String errorMessage, BuildLogger buildLogger) throws Exception {
        buildLogger.addErrorLogEntry("Tried to get schedule title or id!");
        if (errorMessage != null && !errorMessage.isEmpty()) {
            buildLogger.addErrorLogEntry(errorMessage);
        } else {
            errorMessage = "Tried to get schedule title or id!";
        }
        if (e == null) {
            e = new Exception(errorMessage);
        }
        throw e;
    }

    public UUID runSchedule(AsyncHttpClient client, String controllerApiHttpAddress, String accessKey, UUID scheduleId, String scheduleTitle, BuildLogger buildLogger, LeapworkRun run, String scheduleVariablesRequestPart) throws Exception {
        String uri = String.format("%1$s/api/v4/schedules/%2$s/runNow%3$s", controllerApiHttpAddress, scheduleId.toString(), scheduleVariablesRequestPart);
        try {
            Response response = (Response)((BoundRequestBuilder)((BoundRequestBuilder)client.preparePut(uri).setHeader((CharSequence)"AccessKey", accessKey)).setBody(STRING_EMPTY)).execute().get();
            switch (response.getStatusCode()) {
                case 200: {
                    String successMessage = String.format("Schedule %1$s[%2$s] Launched Successfully!", scheduleTitle, scheduleId);
                    buildLogger.addBuildLogEntry("//////////////////////////////////////////////////////////////////////////////////////");
                    buildLogger.addBuildLogEntry(successMessage);
                    JsonParser parser = new JsonParser();
                    JsonObject jsonRunObject = parser.parse(response.getResponseBody()).getAsJsonObject();
                    JsonElement jsonRunId = jsonRunObject.get("RunId");
                    String runIdStr = Utils.defaultStringIfNull(jsonRunId);
                    UUID runId = UUID.fromString(runIdStr);
                    return runId;
                }
                case 400: {
                    StringBuilder errorMessage400 = new StringBuilder(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                    this.appendLine(errorMessage400, "Variable name is invalid or variable with such name is already in request!");
                    return PluginHandler.OnScheduleRunFailure(errorMessage400, run, scheduleId, buildLogger);
                }
                case 401: {
                    StringBuilder errorMessage401 = new StringBuilder(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                    this.appendLine(errorMessage401, "Invalid or empty access key!");
                    return PluginHandler.OnScheduleRunFailure(errorMessage401, run, scheduleId, buildLogger);
                }
                case 404: {
                    StringBuilder errorMessage404 = new StringBuilder(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                    this.appendLine(errorMessage404, String.format("Could not find %1$s[%2$s] schedule! It was likely deleted!", scheduleTitle, scheduleId));
                    return PluginHandler.OnScheduleRunFailure(errorMessage404, run, scheduleId, buildLogger);
                }
                case 446: {
                    StringBuilder errorMessage446 = new StringBuilder(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                    this.appendLine(errorMessage446, "No enough disk space to start schedule!");
                    return PluginHandler.OnScheduleRunFailure(errorMessage446, run, scheduleId, buildLogger);
                }
                case 455: {
                    StringBuilder errorMessage455 = new StringBuilder(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                    this.appendLine(errorMessage455, "Data base is not responding!");
                    return PluginHandler.OnScheduleRunFailure(errorMessage455, run, scheduleId, buildLogger);
                }
                case 500: {
                    StringBuilder errorMessage500 = new StringBuilder(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                    this.appendLine(errorMessage500, "Controller responded with errors! Please check controller logs and try again! If does not help, try to restart controller.");
                    return PluginHandler.OnScheduleRunFailure(errorMessage500, run, scheduleId, buildLogger);
                }
            }
            StringBuilder errorMessage = new StringBuilder(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
            return PluginHandler.OnScheduleRunFailure(errorMessage, run, scheduleId, buildLogger);
        }
        catch (ExecutionException e) {
            if (!(e.getCause() instanceof ConnectException) && !(e.getCause() instanceof UnknownHostException)) {
                throw e;
            }
            PluginHandler.OnScheduleRunConnectionFailure(e, buildLogger);
            return null;
        }
    }

    private static UUID OnScheduleRunFailure(StringBuilder errorMessage, LeapworkRun failedRun, UUID scheduleId, BuildLogger buildLogger) {
        buildLogger.addErrorLogEntry(String.format("Failed to run %1$s[%2$s]!", failedRun.getScheduleTitle(), scheduleId.toString()));
        buildLogger.addErrorLogEntry(errorMessage.toString());
        failedRun.setError(errorMessage.toString());
        failedRun.incErrors();
        return null;
    }

    private static UUID OnScheduleRunConnectionFailure(Exception e, BuildLogger buildLogger) {
        buildLogger.addErrorLogEntry(String.format("Could not connect to %1$s! Check connection! The plugin is waiting for connection reestablishment! ", e.getCause().getMessage()));
        return null;
    }

    public boolean stopRun(String controllerApiHttpAddress, UUID runId, String scheduleTitle, String accessKey, BuildLogger buildLogger) {
        boolean isSuccessfullyStopped = false;
        buildLogger.addErrorLogEntry(String.format("Stopping schedule %1$s run %2$s!", scheduleTitle, runId));
        String uri = String.format("%1$s/api/v4/run/%2$s/stop", controllerApiHttpAddress, runId.toString());
        AsyncHttpClient client = Dsl.asyncHttpClient();
        try {
            try {
                Response response = (Response)((BoundRequestBuilder)((BoundRequestBuilder)client.preparePut(uri).setBody(STRING_EMPTY)).setHeader((CharSequence)"AccessKey", accessKey)).execute().get();
                client.close();
                switch (response.getStatusCode()) {
                    case 200: {
                        JsonParser parser = new JsonParser();
                        JsonObject jsonStopRunObject = parser.parse(response.getResponseBody()).getAsJsonObject();
                        JsonElement jsonStopSuccessfull = jsonStopRunObject.get("OperationCompleted");
                        isSuccessfullyStopped = Utils.defaultBooleanIfNull(jsonStopSuccessfull, false);
                        if (isSuccessfullyStopped) {
                            buildLogger.addErrorLogEntry(String.format("Schedule %1$s run %2$s stopped successfully!", scheduleTitle, runId.toString()));
                            break;
                        }
                        buildLogger.addErrorLogEntry(String.format("Failed to stop schedule %1$s run %2$s!", scheduleTitle, runId.toString()));
                        break;
                    }
                    case 401: {
                        buildLogger.addErrorLogEntry(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                        buildLogger.addErrorLogEntry("Invalid or empty access key!");
                        buildLogger.addErrorLogEntry(String.format("Failed to stop schedule %1$s run %2$s!", scheduleTitle, runId.toString()));
                    }
                    case 404: {
                        buildLogger.addErrorLogEntry(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                        buildLogger.addErrorLogEntry(String.format("Could not find run %1$s of %2$s schedule!", runId, scheduleTitle));
                        buildLogger.addErrorLogEntry(String.format("Failed to stop schedule %1$s run %2$s!", scheduleTitle, runId.toString()));
                    }
                    case 446: {
                        buildLogger.addErrorLogEntry(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                        buildLogger.addErrorLogEntry("No enough disk space to start schedule!");
                        buildLogger.addErrorLogEntry(String.format("Failed to stop schedule %1$s run %2$s!", scheduleTitle, runId.toString()));
                    }
                    case 455: {
                        buildLogger.addErrorLogEntry(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                        buildLogger.addErrorLogEntry("Data base is not responding!");
                        buildLogger.addErrorLogEntry(String.format("Failed to stop schedule %1$s run %2$s!", scheduleTitle, runId.toString()));
                    }
                    case 500: {
                        buildLogger.addErrorLogEntry(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                        buildLogger.addErrorLogEntry("Controller responded with errors! Please check controller logs and try again! If does not help, try to restart controller.");
                        buildLogger.addErrorLogEntry(String.format("Failed to stop schedule %1$s run %2$s!", scheduleTitle, runId.toString()));
                    }
                    default: {
                        buildLogger.addErrorLogEntry(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                        buildLogger.addErrorLogEntry(String.format("Failed to stop schedule %1$s run %2$s!", scheduleTitle, runId.toString()));
                        break;
                    }
                }
            }
            catch (Exception e) {
                buildLogger.addErrorLogEntry(String.format("Failed to stop schedule %1$s run %2$s!", scheduleTitle, runId.toString()));
                buildLogger.addErrorLogEntry(e.getMessage());
            }
        }
        catch (Throwable throwable) {}
        if (client != null) {
            try {
                client.close();
            }
            catch (IOException e) {
                buildLogger.addErrorLogEntry("Error while closing client: " + e.getMessage());
            }
        }
        return isSuccessfullyStopped;
    }

    public String getCorrectName(String reportFileName) {
        if (reportFileName.contains("/") || reportFileName.contains("\\") || reportFileName.contains("|")) {
            String[] ar = reportFileName.split(pathSeparatorRegex);
            String buff = ar[ar.length - 1];
            if (!buff.endsWith(".xml")) {
                buff = String.valueOf(buff) + ".xml";
            }
            reportFileName = buff;
        } else {
            if (reportFileName.isEmpty() || STRING_EMPTY.equals(reportFileName)) {
                reportFileName = "report.xml";
            }
            if (!reportFileName.contains(".xml")) {
                reportFileName = String.valueOf(reportFileName) + ".xml";
            }
        }
        return reportFileName;
    }

    public File createJUnitReport(TaskContext taskContext, String reportFileName, BuildLogger buildLogger, RunCollection buildResult) throws Exception {
        String bambooWorkspacePath = taskContext.getWorkingDirectory().getAbsolutePath();
        String JUnitReportFilePath = Paths.get(bambooWorkspacePath, reportFileName).toString();
        buildLogger.addBuildLogEntry(String.format("WORKSPACE: %1$s", bambooWorkspacePath));
        try {
            File reportFile = new File(JUnitReportFilePath);
            if (!reportFile.exists()) {
                reportFile.createNewFile();
            }
            reportFile.setLastModified(reportFile.lastModified() - SystemProperty.FS_TIMESTAMP_RESOLUTION_MS.getTypedValue() - 2000L);
            Throwable throwable = null;
            Object var9_13 = null;
            try (StringWriter writer = new StringWriter();){
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{RunCollection.class});
                Marshaller m = context.createMarshaller();
                m.setProperty("jaxb.formatted.output", (Object)true);
                m.marshal((Object)buildResult, (Writer)writer);
                Throwable throwable2 = null;
                Object var14_20 = null;
                try (StringWriter formattedWriter = new StringWriter();){
                    formattedWriter.append(writer.getBuffer().toString().replace("&amp;#xA;", "&#xA;"));
                    Throwable throwable3 = null;
                    Object var17_25 = null;
                    try (PrintStream out = new PrintStream(new FileOutputStream(reportFile.getAbsolutePath()));){
                        out.print(formattedWriter);
                        out.close();
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
            return reportFile;
        }
        catch (FileNotFoundException e) {
            buildLogger.addErrorLogEntry("Couldn't find report file! Wrong path! Press \"help\" button nearby \"report\" textbox! ");
            throw new Exception(e);
        }
        catch (IOException e) {
            buildLogger.addErrorLogEntry("Failed to create a report file!");
            throw new Exception(e);
        }
        catch (JAXBException e) {
            buildLogger.addErrorLogEntry("Failed to create a report file!");
            throw new Exception(e);
        }
    }

    public String getRunStatus(AsyncHttpClient client, String controllerApiHttpAddress, String accessKey, UUID runId) throws Exception {
        String uri = String.format("%1$s/api/v4/run/%2$s/status", controllerApiHttpAddress, runId.toString());
        Response response = (Response)((BoundRequestBuilder)client.prepareGet(uri).setHeader((CharSequence)"AccessKey", accessKey)).execute().get();
        switch (response.getStatusCode()) {
            case 200: {
                JsonParser parser = new JsonParser();
                JsonObject runStatusObject = parser.parse(response.getResponseBody()).getAsJsonObject();
                JsonElement jsonRunStatus = runStatusObject.get("Status");
                String runStatus = Utils.defaultStringIfNull(jsonRunStatus, "Queued");
                return runStatus;
            }
            case 401: {
                StringBuilder errorMessage401 = new StringBuilder(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                this.appendLine(errorMessage401, "Invalid or empty access key!");
                throw new Exception(errorMessage401.toString());
            }
            case 404: {
                StringBuilder errorMessage404 = new StringBuilder(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                this.appendLine(errorMessage404, String.format("No such run %1$s !", runId));
                throw new Exception(errorMessage404.toString());
            }
            case 455: {
                StringBuilder errorMessage455 = new StringBuilder(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                this.appendLine(errorMessage455, "Data base is not responding!");
                throw new Exception(errorMessage455.toString());
            }
            case 500: {
                StringBuilder errorMessage500 = new StringBuilder(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                this.appendLine(errorMessage500, "Controller responded with errors! Please check controller logs and try again! If does not help, try to restart controller.");
                throw new Exception(errorMessage500.toString());
            }
        }
        String errorMessage = String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText());
        throw new Exception(errorMessage);
    }

    public List<UUID> getRunRunItems(AsyncHttpClient client, String controllerApiHttpAddress, String accessKey, UUID runId) throws Exception {
        String uri = String.format("%1$s/api/v4/run/%2$s/runItemIds", controllerApiHttpAddress, runId.toString());
        Response response = (Response)((BoundRequestBuilder)client.prepareGet(uri).setHeader((CharSequence)"AccessKey", accessKey)).execute().get();
        switch (response.getStatusCode()) {
            case 200: {
                JsonParser parser = new JsonParser();
                JsonObject jsonRunItemsObject = parser.parse(response.getResponseBody()).getAsJsonObject();
                JsonElement jsonRunItemsElement = jsonRunItemsObject.get("RunItemIds");
                ArrayList<UUID> runItems = new ArrayList<UUID>();
                if (jsonRunItemsElement != null) {
                    JsonArray jsonRunItems = jsonRunItemsElement.getAsJsonArray();
                    int i = 0;
                    while (i < jsonRunItems.size()) {
                        UUID runItemId = UUID.fromString(jsonRunItems.get(i).getAsString());
                        runItems.add(runItemId);
                        ++i;
                    }
                }
                return runItems;
            }
            case 401: {
                StringBuilder errorMessage401 = new StringBuilder(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                this.appendLine(errorMessage401, "Invalid or empty access key!");
                throw new Exception(errorMessage401.toString());
            }
            case 404: {
                StringBuilder errorMessage404 = new StringBuilder(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                this.appendLine(errorMessage404, String.format("No such run %1$s !", runId));
                throw new Exception(errorMessage404.toString());
            }
            case 446: {
                StringBuilder errorMessage446 = new StringBuilder(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                this.appendLine(errorMessage446, "No enough disk space to start schedule!");
                throw new Exception(errorMessage446.toString());
            }
            case 455: {
                StringBuilder errorMessage455 = new StringBuilder(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                this.appendLine(errorMessage455, "Data base is not responding!");
                throw new Exception(errorMessage455.toString());
            }
            case 500: {
                StringBuilder errorMessage500 = new StringBuilder(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                this.appendLine(errorMessage500, "Controller responded with errors! Please check controller logs and try again! If does not help, try to restart controller.");
                throw new Exception(errorMessage500.toString());
            }
        }
        String errorMessage = String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText());
        throw new Exception(errorMessage);
    }

    public RunItem getRunItem(AsyncHttpClient client, String controllerApiHttpAddress, String accessKey, UUID runItemId, String scheduleTitle, boolean doneStatusAsSuccess, boolean writePassedKeyframes, BuildLogger buildLogger) throws Exception {
        String uri = String.format("%1$s/api/v4/runItems/%2$s", controllerApiHttpAddress, runItemId.toString());
        Response response = (Response)((BoundRequestBuilder)client.prepareGet(uri).setHeader((CharSequence)"AccessKey", accessKey)).execute().get();
        switch (response.getStatusCode()) {
            case 200: {
                Failure keyframes;
                JsonParser parser = new JsonParser();
                JsonObject jsonRunItem = parser.parse(response.getResponseBody()).getAsJsonObject();
                parser = null;
                JsonElement jsonFlowInfo = jsonRunItem.get("FlowInfo");
                JsonObject flowInfo = jsonFlowInfo.getAsJsonObject();
                JsonElement jsonFlowId = flowInfo.get("FlowId");
                UUID flowId = Utils.defaultUuidIfNull(jsonFlowId, UUID.randomUUID());
                JsonElement jsonFlowTitle = flowInfo.get("FlowTitle");
                String flowTitle = Utils.defaultStringIfNull(jsonFlowTitle);
                JsonElement jsonFlowStatus = flowInfo.get("Status");
                String flowStatus = Utils.defaultStringIfNull(jsonFlowStatus, "NoStatus");
                JsonElement jsonEnvironmentInfo = jsonRunItem.get("AgentInfo");
                JsonObject environmentInfo = jsonEnvironmentInfo.getAsJsonObject();
                JsonElement jsonEnvironmentId = environmentInfo.get("AgentId");
                UUID environmentId = Utils.defaultUuidIfNull(jsonEnvironmentId, UUID.randomUUID());
                JsonElement jsonEnvironmentTitle = environmentInfo.get("AgentTitle");
                String environmentTitle = Utils.defaultStringIfNull(jsonEnvironmentTitle);
                JsonElement jsonEnvironmentConnectionType = environmentInfo.get("ConnectionType");
                String environmentConnectionType = Utils.defaultStringIfNull(jsonEnvironmentConnectionType, "Not defined");
                JsonElement jsonRunId = jsonRunItem.get("AutomationRunId");
                UUID runId = Utils.defaultUuidIfNull(jsonRunId, UUID.randomUUID());
                String elapsed = Utils.defaultElapsedIfNull(jsonRunItem.get("Elapsed"));
                double milliseconds = Utils.defaultDoubleIfNull(jsonRunItem.get("ElapsedMilliseconds"), 0.0);
                RunItem runItem = new RunItem(flowTitle, flowStatus, milliseconds, scheduleTitle);
                if (flowStatus.contentEquals("Initializing") || flowStatus.contentEquals("Connecting") || flowStatus.contentEquals("Connected") || flowStatus.contentEquals("Running") || flowStatus.contentEquals("IsProcessing") || flowStatus.contentEquals("NoStatus") || flowStatus.contentEquals("Passed") && !writePassedKeyframes || flowStatus.contentEquals("Done") && doneStatusAsSuccess && !writePassedKeyframes) {
                    return runItem;
                }
                runItem.failure = keyframes = this.getRunItemKeyFrames(client, controllerApiHttpAddress, accessKey, runItemId, runItem, scheduleTitle, environmentTitle, buildLogger);
                return runItem;
            }
            case 401: {
                StringBuilder errorMessage401 = new StringBuilder(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                this.appendLine(errorMessage401, "Invalid or empty access key!");
                throw new Exception(errorMessage401.toString());
            }
            case 404: {
                StringBuilder errorMessage404 = new StringBuilder(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                this.appendLine(errorMessage404, String.format("Could not find run item %1$s of %2$s schedule!", runItemId, scheduleTitle));
                throw new Exception(errorMessage404.toString());
            }
            case 446: {
                StringBuilder errorMessage446 = new StringBuilder(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                this.appendLine(errorMessage446, "No enough disk space to start schedule!");
                throw new Exception(errorMessage446.toString());
            }
            case 455: {
                StringBuilder errorMessage455 = new StringBuilder(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                this.appendLine(errorMessage455, "Data base is not responding!");
                throw new Exception(errorMessage455.toString());
            }
            case 500: {
                StringBuilder errorMessage500 = new StringBuilder(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                this.appendLine(errorMessage500, "Controller responded with errors! Please check controller logs and try again! If does not help, try to restart controller.");
                throw new Exception(errorMessage500.toString());
            }
        }
        String errorMessage = String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText());
        throw new Exception(errorMessage);
    }

    public Failure getRunItemKeyFrames(AsyncHttpClient client, String controllerApiHttpAddress, String accessKey, UUID runItemId, RunItem runItem, String scheduleTitle, String environmentTitle, BuildLogger buildLogger) throws Exception {
        String uri = String.format("%1$s/api/v4/runItems/%2$s/keyframes", controllerApiHttpAddress, runItemId.toString());
        Response response = (Response)((BoundRequestBuilder)client.prepareGet(uri).setHeader((CharSequence)"AccessKey", accessKey)).execute().get();
        switch (response.getStatusCode()) {
            case 200: {
                JsonArray jsonKeyframes = PluginHandler.TryParseKeyframeJson(response.getResponseBody(), buildLogger);
                if (jsonKeyframes != null) {
                    buildLogger.addBuildLogEntry("----------------------------------------------------------------------------------------");
                    buildLogger.addBuildLogEntry(String.format("RunItem: %1$s | Status: %2$s | Elapsed: %3$s", runItem.getCaseName(), runItem.getCaseStatus(), runItem.getElapsedTime()));
                    StringBuilder fullKeyframes = new StringBuilder(STRING_EMPTY);
                    for (JsonElement jsonKeyFrame : jsonKeyframes) {
                        String level = Utils.defaultStringIfNull(jsonKeyFrame.getAsJsonObject().get("Level"), "Trace");
                        if (level.contentEquals(STRING_EMPTY) || level.contentEquals("Trace")) continue;
                        String keyFrameTimeStamp = jsonKeyFrame.getAsJsonObject().get("Timestamp").getAsJsonObject().get("Value").getAsString();
                        String keyFrameLogMessage = jsonKeyFrame.getAsJsonObject().get("LogMessage").getAsString();
                        String keyFrame = String.format("%1$s - %2$s", keyFrameTimeStamp, keyFrameLogMessage);
                        buildLogger.addBuildLogEntry(keyFrame);
                        fullKeyframes.append(keyFrame);
                        fullKeyframes.append("&#xA;");
                    }
                    fullKeyframes.append("Environment: ").append(environmentTitle).append("&#xA;");
                    fullKeyframes.append("Schedule: ").append(scheduleTitle);
                    buildLogger.addBuildLogEntry("Environment: " + environmentTitle);
                    buildLogger.addBuildLogEntry("Schedule: " + scheduleTitle);
                    return new Failure(fullKeyframes.toString());
                }
                buildLogger.addBuildLogEntry(String.format("Failed to parse response keyframe json array", new Object[0]));
                return new Failure("Failed to parse response keyframe json array");
            }
            case 401: {
                buildLogger.addErrorLogEntry(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                buildLogger.addErrorLogEntry("Invalid or empty access key!");
                break;
            }
            case 404: {
                buildLogger.addErrorLogEntry(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                buildLogger.addErrorLogEntry(String.format("Could not find run item %1$s of %2$s schedule!", runItemId, scheduleTitle));
                break;
            }
            case 446: {
                buildLogger.addErrorLogEntry(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                buildLogger.addErrorLogEntry("No enough disk space to start schedule!");
                break;
            }
            case 455: {
                buildLogger.addErrorLogEntry(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                buildLogger.addErrorLogEntry("Data base is not responding!");
                break;
            }
            case 500: {
                buildLogger.addErrorLogEntry(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
                buildLogger.addErrorLogEntry("Controller responded with errors! Please check controller logs and try again! If does not help, try to restart controller.");
                break;
            }
            default: {
                buildLogger.addErrorLogEntry(String.format("Code: %1$s Status: %2$s!", response.getStatusCode(), response.getStatusText()));
            }
        }
        return null;
    }

    private static JsonArray TryParseKeyframeJson(String response, BuildLogger buildLogger) {
        JsonParser parser = new JsonParser();
        try {
            JsonArray jsonKeyframes = parser.parse(response).getAsJsonArray();
            return jsonKeyframes;
        }
        catch (Exception e) {
            buildLogger.addBuildLogEntry(e.getMessage());
            return null;
        }
    }

    private void appendLine(StringBuilder stringBuilder, String line) {
        if (stringBuilder != null) {
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append(line);
        }
    }

    public String correctRepeatedTitles(HashMap<String, Integer> repeatedNameMapCounter, String title) {
        if (repeatedNameMapCounter.containsKey(title)) {
            Integer number = repeatedNameMapCounter.get(title);
            title = String.format("%1$s(%2$d)", title, number);
            number = number + 1;
            return title;
        }
        repeatedNameMapCounter.put(title, new Integer(0));
        return title;
    }

    public boolean isLeapworkWritePassedFlowKeyFrames(boolean leapworkWritePassedFlowKeyFrames) {
        return leapworkWritePassedFlowKeyFrames;
    }
}

