/*
 * Decompiled with CFR 0.152.
 */
package com.leapwork.leapwork_integration_for_bamboo.impl;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.util.TextProviderUtils;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class LeapworkBambooBridgeTaskConfigurator
extends AbstractTaskConfigurator {
    private TextProviderUtils textProvider;

    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @NotNull TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put("leapworkHostname", params.getString("leapworkHostname"));
        config.put("leapworkHttps", Boolean.toString(params.getBoolean("leapworkHttps")));
        config.put("leapworkPort", params.getString("leapworkPort"));
        config.put("leapworkAccessKey", params.getString("leapworkAccessKey"));
        config.put("leapworkDelay", params.getString("leapworkDelay"));
        config.put("leapworkDoneStatusAs", params.getString("leapworkDoneStatusAs"));
        config.put("leapworkReport", params.getString("leapworkReport"));
        config.put("leapworkAutoReport", Boolean.toString(params.getBoolean("leapworkAutoReport")));
        config.put("leapworkSchNames", params.getString("leapworkSchNames"));
        config.put("leapworkSchIds", params.getString("leapworkSchIds"));
        config.put("leapworkScheduleVariables", params.getString("leapworkScheduleVariables"));
        config.put("leapworkWritePassedFlowKeyFrames", params.getString("leapworkWritePassedFlowKeyFrames"));
        return config;
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("leapworkPort", "9001");
        context.put("leapworkDelay", "3");
        context.put("leapworkReport", "report.xml");
        context.put("leapworkAutoReport", Boolean.toString(false));
        ArrayList<String> statuses = new ArrayList<String>();
        statuses.add("Failed");
        statuses.add("Success");
        context.put("statuses", statuses);
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        Map config = taskDefinition.getConfiguration();
        context.put("leapworkHostname", config.get("leapworkHostname"));
        context.put("leapworkHttps", Boolean.valueOf((String)config.get("leapworkHttps")));
        context.put("leapworkPort", config.get("leapworkPort"));
        context.put("leapworkAccessKey", config.get("leapworkAccessKey"));
        context.put("leapworkDelay", config.get("leapworkDelay"));
        context.put("leapworkDoneStatusAs", config.get("leapworkDoneStatusAs"));
        context.put("leapworkReport", config.get("leapworkReport"));
        context.put("leapworkAutoReport", Boolean.valueOf((String)config.get("leapworkAutoReport")));
        context.put("leapworkSchNames", config.get("leapworkSchNames"));
        context.put("leapworkSchIds", config.get("leapworkSchIds"));
        context.put("leapworkScheduleVariables", config.get("leapworkScheduleVariables"));
        context.put("leapworkWritePassedFlowKeyFrames", config.get("leapworkWritePassedFlowKeyFrames"));
        ArrayList<String> statuses = new ArrayList<String>();
        statuses.add("Failed");
        statuses.add("Success");
        context.put("statuses", statuses);
    }
}

