/*
 * Decompiled with CFR 0.152.
 */
package com.leapwork.leapwork_integration_for_bamboo.impl;

import com.atlassian.annotations.PublicApi;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.build.test.TestReportCollector;
import com.atlassian.bamboo.build.test.junit.JunitTestReportCollector;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.task.TaskType;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.leapwork.leapwork_integration_for_bamboo.impl.PluginHandler;
import com.leapwork.leapwork_integration_for_bamboo.impl.Utils;
import com.leapwork.leapwork_integration_for_bamboo.model.InvalidSchedule;
import com.leapwork.leapwork_integration_for_bamboo.model.LeapworkRun;
import com.leapwork.leapwork_integration_for_bamboo.model.RunCollection;
import com.leapwork.leapwork_integration_for_bamboo.model.RunItem;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import org.aspectj.bridge.AbortException;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class LeapworkBambooBridgeTask
implements TaskType {
    TaskResult result;
    private static PluginHandler pluginHandler = PluginHandler.getInstance();
    @PublicApi
    private final TestCollationService testCollationService;

    @Autowired
    public LeapworkBambooBridgeTask(@ComponentImport TestCollationService testCollationService) {
        this.testCollationService = testCollationService;
    }

    public TaskResult execute(TaskContext taskContext) throws TaskException {
        TaskResultBuilder taskResultBuilder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        BuildLogger buildLogger = taskContext.getBuildLogger();
        String leapworkHostname = (String)taskContext.getConfigurationMap().get((Object)"leapworkHostname");
        String leapworkHttps = (String)taskContext.getConfigurationMap().get((Object)"leapworkHttps");
        String leapworkPort = (String)taskContext.getConfigurationMap().get((Object)"leapworkPort");
        String leapworkAccessKey = (String)taskContext.getConfigurationMap().get((Object)"leapworkAccessKey");
        String leapworkDelay = (String)taskContext.getConfigurationMap().get((Object)"leapworkDelay");
        String leapworkDoneStatusAs = (String)taskContext.getConfigurationMap().get((Object)"leapworkDoneStatusAs");
        String leapworkReport = pluginHandler.getCorrectName((String)taskContext.getConfigurationMap().get((Object)"leapworkReport"));
        String leapworkSchIds = (String)taskContext.getConfigurationMap().get((Object)"leapworkSchIds");
        String leapworkSchNames = (String)taskContext.getConfigurationMap().get((Object)"leapworkSchNames");
        String leapworkAutoReport = (String)taskContext.getConfigurationMap().get((Object)"leapworkAutoReport");
        String leapworkScheduleVariables = (String)taskContext.getConfigurationMap().get((Object)"leapworkScheduleVariables");
        boolean leapworkWritePassedFlowKeyFrames = Boolean.parseBoolean((String)taskContext.getConfigurationMap().get((Object)"leapworkWritePassedFlowKeyFrames"));
        buildLogger.addBuildLogEntry(String.format("Auto Report Enabled = %1$s", leapworkAutoReport));
        ArrayList<InvalidSchedule> invalidSchedules = new ArrayList<InvalidSchedule>();
        LinkedHashMap<String, Integer> repeatedNameMapCounter = new LinkedHashMap<String, Integer>();
        ArrayList<String> rawScheduleList = pluginHandler.getRawScheduleList(leapworkSchIds, leapworkSchNames);
        this.printPluginInputs(leapworkHostname, leapworkHttps, leapworkPort, leapworkDelay, leapworkDoneStatusAs, leapworkReport, leapworkSchNames, leapworkSchIds, leapworkScheduleVariables, String.valueOf(leapworkWritePassedFlowKeyFrames), buildLogger);
        boolean isHttpsEnabled = Utils.defaultBooleanIfNull(leapworkHttps, false);
        String controllerApiHttpAddress = pluginHandler.getControllerApiHttpAdderess(leapworkHostname, isHttpsEnabled, leapworkPort, buildLogger);
        int timeDelay = pluginHandler.getTimeDelay(leapworkDelay, buildLogger);
        boolean isAutoReportEnabled = Utils.defaultBooleanIfNull(leapworkAutoReport, false);
        boolean isDoneStatusAsSuccess = pluginHandler.isDoneStatusAsSuccess(leapworkDoneStatusAs);
        boolean writePassedKeyframes = pluginHandler.isLeapworkWritePassedFlowKeyFrames(leapworkWritePassedFlowKeyFrames);
        String scheduleVariablesRequestPart = pluginHandler.getScheduleVariablesRequestPart(leapworkScheduleVariables, buildLogger);
        AsyncHttpClient mainClient = Dsl.asyncHttpClient();
        try {
            try {
                LinkedHashMap<UUID, String> schedulesIdTitleHashMap = pluginHandler.getSchedulesIdTitleHashMap(mainClient, leapworkAccessKey, controllerApiHttpAddress, rawScheduleList, buildLogger, invalidSchedules);
                rawScheduleList.clear();
                if (schedulesIdTitleHashMap.isEmpty()) {
                    throw new Exception("No Schedules to run! All schedules you've selected could be deleted. Or you simply have forgotten to select schedules after changing controller address;");
                }
                ArrayList<UUID> schIdsList = new ArrayList<UUID>(schedulesIdTitleHashMap.keySet());
                LinkedHashMap<UUID, Object> resultsMap = new LinkedHashMap<UUID, Object>();
                ListIterator iter = schIdsList.listIterator();
                while (iter.hasNext()) {
                    Object run;
                    String schTitle;
                    UUID schId = (UUID)iter.next();
                    UUID runId = pluginHandler.runSchedule(mainClient, controllerApiHttpAddress, leapworkAccessKey, schId, schTitle = schedulesIdTitleHashMap.get(schId), buildLogger, (LeapworkRun)(run = new LeapworkRun(schId.toString(), schTitle)), scheduleVariablesRequestPart);
                    if (runId != null) {
                        resultsMap.put(runId, run);
                        LeapworkBambooBridgeTask.CollectScheduleRunResults(controllerApiHttpAddress, leapworkAccessKey, runId, schTitle, timeDelay, isDoneStatusAsSuccess, writePassedKeyframes, (LeapworkRun)run, buildLogger, repeatedNameMapCounter);
                    } else {
                        resultsMap.put(UUID.randomUUID(), run);
                    }
                    iter.remove();
                }
                schIdsList.clear();
                schedulesIdTitleHashMap.clear();
                RunCollection buildResult = new RunCollection();
                if (invalidSchedules.size() > 0) {
                    buildLogger.addBuildLogEntry("INVALID SCHEDULES");
                    for (InvalidSchedule invalidSchedule : invalidSchedules) {
                        buildLogger.addBuildLogEntry(String.format("%1$s: %2$s", invalidSchedule.getName(), invalidSchedule.getStackTrace()));
                        LeapworkRun notFoundSchedule = new LeapworkRun(invalidSchedule.getName());
                        RunItem invalidRunItem = new RunItem("Error", "Error", 0.0, invalidSchedule.getStackTrace(), invalidSchedule.getName());
                        notFoundSchedule.runItems.add(invalidRunItem);
                        notFoundSchedule.setError(invalidSchedule.getStackTrace());
                        buildResult.leapworkRuns.add(notFoundSchedule);
                    }
                }
                ArrayList resultRuns = new ArrayList(resultsMap.values());
                buildLogger.addBuildLogEntry("|---------------------------------------------------------------");
                for (Object run : resultRuns) {
                    buildResult.leapworkRuns.add((LeapworkRun)run);
                    buildResult.addFailedTests(((LeapworkRun)run).getFailed());
                    buildResult.addPassedTests(((LeapworkRun)run).getPassed());
                    buildResult.addErrors(((LeapworkRun)run).getErrors());
                    ((LeapworkRun)run).setTotal(((LeapworkRun)run).getPassed() + ((LeapworkRun)run).getFailed());
                    buildResult.addTotalTime(((LeapworkRun)run).getTime());
                    buildLogger.addBuildLogEntry(String.format("Schedule: %1$s[%2$s]", ((LeapworkRun)run).getScheduleTitle(), ((LeapworkRun)run).getScheduleId()));
                    buildLogger.addBuildLogEntry(String.format("Passed testcases: %1$d", ((LeapworkRun)run).getPassed()));
                    buildLogger.addBuildLogEntry(String.format("Failed testcases: %1$d", ((LeapworkRun)run).getFailed()));
                    buildLogger.addBuildLogEntry(String.format("Error testcases: %1$d", ((LeapworkRun)run).getErrors()));
                }
                buildResult.setTotalTests(buildResult.getFailedTests() + buildResult.getPassedTests());
                buildLogger.addBuildLogEntry("|---------------------------------------------------------------");
                buildLogger.addBuildLogEntry(String.format("| Total passed testcases: %1$d", buildResult.getPassedTests()));
                buildLogger.addBuildLogEntry(String.format("| Total failed testcases: %1$d", buildResult.getFailedTests()));
                buildLogger.addBuildLogEntry(String.format("| Total error testcases: %1$d", buildResult.getErrors()));
                File reportFile = pluginHandler.createJUnitReport(taskContext, leapworkReport, buildLogger, buildResult);
                if (isAutoReportEnabled) {
                    this.testCollationService.collateTestResults(taskContext, leapworkReport, (TestReportCollector)new JunitTestReportCollector(), true);
                    this.result = taskResultBuilder.checkTestFailures().build();
                } else if (buildResult.getErrors() > 0 || buildResult.getFailedTests() > 0 || invalidSchedules.size() > 0) {
                    if (buildResult.getErrors() > 0) {
                        buildLogger.addBuildLogEntry("[ERROR] There were detected case(s) with status 'Failed', 'Error', 'Inconclusive', 'Timeout' or 'Cancelled'. Please check the report or console output for details. Set the build status to FAILURE as the results of the cases are not deterministic..");
                    }
                    this.result = taskResultBuilder.failed().build();
                    buildLogger.addBuildLogEntry("FAILURE");
                } else {
                    this.result = taskResultBuilder.success().build();
                    buildLogger.addBuildLogEntry("SUCCESS");
                }
                buildLogger.addBuildLogEntry("Leapwork for Bamboo  plugin  successfully finished!");
            }
            catch (InterruptedException | AbortException e) {
                buildLogger.addErrorLogEntry("ABORTED");
                buildLogger.addErrorLogEntry("Leapwork for Bamboo plugin finished with errors!");
                this.result = taskResultBuilder.failedWithError().build();
            }
            catch (Exception e) {
                buildLogger.addErrorLogEntry("Leapwork for Bamboo plugin finished with errors!");
                buildLogger.addErrorLogEntry(e.getMessage());
                buildLogger.addErrorLogEntry("If nothing helps, please contact support https://leapwork.com/support and provide the next information:\n1.Plugin Logs\n2.Leapwork and plugin version\n3.Controller logs from the moment you've run the plugin.\n4.Assets without videos if possible.\nYou can find them {Path to Leapwork}/leapwork/Assets\nThank you");
                buildLogger.addErrorLogEntry("FAILURE");
                this.result = taskResultBuilder.failedWithError().build();
            }
        }
        catch (Throwable throwable) {}
        try {
            mainClient.close();
        }
        catch (IOException closeException) {
            buildLogger.addErrorLogEntry("Error closing HTTP client: " + closeException.getMessage());
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void CollectScheduleRunResults(String controllerApiHttpAddress, String accessKey, UUID runId, String scheduleName, int timeDelay, boolean isDoneStatusAsSuccess, boolean writePassedKeyframes, LeapworkRun resultRun, BuildLogger buildLogger, LinkedHashMap<String, Integer> repeatedNameMapCounter) throws InterruptedException {
        ArrayList<UUID> runItemsId = new ArrayList<UUID>();
        Object waiter = new Object();
        AsyncHttpClient client = Dsl.asyncHttpClient();
        try {
            try {
                boolean isStillRunning = true;
                do {
                    List<UUID> allExecutedRunItems;
                    Object object = waiter;
                    synchronized (object) {
                        waiter.wait(timeDelay * 1000);
                    }
                    List<UUID> executedRunItems = pluginHandler.getRunRunItems(client, controllerApiHttpAddress, accessKey, runId);
                    executedRunItems.removeAll(runItemsId);
                    ListIterator<UUID> iter = executedRunItems.listIterator();
                    while (iter.hasNext()) {
                        UUID runItemId = iter.next();
                        RunItem runItem = pluginHandler.getRunItem(client, controllerApiHttpAddress, accessKey, runItemId, scheduleName, isDoneStatusAsSuccess, writePassedKeyframes, buildLogger);
                        String status = runItem.getCaseStatus();
                        resultRun.addTime(runItem.getElapsedTime());
                        switch (status) {
                            case "IsProcessing": 
                            case "Running": 
                            case "Initializing": 
                            case "NoStatus": 
                            case "Connecting": 
                            case "Connected": {
                                iter.remove();
                                break;
                            }
                            case "Passed": {
                                runItem.setCaseName(pluginHandler.correctRepeatedTitles(repeatedNameMapCounter, runItem.getCaseName()));
                                resultRun.incPassed();
                                resultRun.runItems.add(runItem);
                                resultRun.incTotal();
                                break;
                            }
                            case "Failed": {
                                runItem.setCaseName(pluginHandler.correctRepeatedTitles(repeatedNameMapCounter, runItem.getCaseName()));
                                resultRun.incFailed();
                                resultRun.runItems.add(runItem);
                                resultRun.incTotal();
                                break;
                            }
                            case "Cancelled": 
                            case "Inconclusive": 
                            case "Error": 
                            case "Timeout": {
                                runItem.setCaseName(pluginHandler.correctRepeatedTitles(repeatedNameMapCounter, runItem.getCaseName()));
                                resultRun.incErrors();
                                resultRun.runItems.add(runItem);
                                resultRun.incTotal();
                                break;
                            }
                            case "Done": {
                                runItem.setCaseName(pluginHandler.correctRepeatedTitles(repeatedNameMapCounter, runItem.getCaseName()));
                                resultRun.runItems.add(runItem);
                                if (isDoneStatusAsSuccess) {
                                    resultRun.incPassed();
                                } else {
                                    resultRun.incFailed();
                                }
                                resultRun.incTotal();
                            }
                        }
                    }
                    runItemsId.addAll(executedRunItems);
                    String runStatus = pluginHandler.getRunStatus(client, controllerApiHttpAddress, accessKey, runId);
                    if (runStatus.contentEquals("Finished") && (allExecutedRunItems = pluginHandler.getRunRunItems(client, controllerApiHttpAddress, accessKey, runId)).size() > 0 && allExecutedRunItems.size() <= runItemsId.size()) {
                        isStillRunning = false;
                    }
                    if (!isStillRunning) continue;
                    buildLogger.addBuildLogEntry(String.format("The schedule status is already '%1$s' - wait a minute...", runStatus));
                } while (isStillRunning);
            }
            catch (InterruptedException e) {
                ReentrantLock lock = new ReentrantLock();
                lock.lock();
                try {
                    String interruptedExceptionMessage = String.format("Interrupted exception: %1$s!", e.getMessage());
                    buildLogger.addErrorLogEntry(interruptedExceptionMessage);
                    RunItem invalidItem = new RunItem("Aborted run", "Cancelled", 0.0, e.getMessage(), scheduleName);
                    pluginHandler.stopRun(controllerApiHttpAddress, runId, scheduleName, accessKey, buildLogger);
                    resultRun.incErrors();
                    resultRun.runItems.add(invalidItem);
                }
                catch (Throwable throwable) {}
                lock.unlock();
                throw e;
            }
            catch (Exception e) {
                buildLogger.addErrorLogEntry(e.getMessage());
                RunItem invalidItem = new RunItem("Invalid run", "Error", 0.0, e.getMessage(), scheduleName);
                resultRun.incErrors();
                resultRun.runItems.add(invalidItem);
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (IOException e2) {
                        buildLogger.addErrorLogEntry("Error while closing client: " + e2.getMessage());
                    }
                }
            }
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    buildLogger.addErrorLogEntry("Error while closing client: " + e.getMessage());
                }
            }
        }
    }

    private void printPluginInputs(String leapworkHostname, String leapworkHttps, String leapworkPort, String leapworkDelay, String leapworkDoneStatusAs, String leapworkReport, String leapworkSchNames, String leapworkSchIds, String leapworkScheduleVariables, String leapworkWritePassedFlowKeyFrames, BuildLogger buildLogger) {
        Object[] Names = leapworkSchNames.split("\r\n|\n|\\s+,\\s+|,\\s+|\\s+,|,");
        Object[] Ids = leapworkSchIds.split("\r\n|\n|\\s+,\\s+|,\\s+|\\s+,|,");
        buildLogger.addBuildLogEntry("LeapWork Plugin input parameters:");
        buildLogger.addBuildLogEntry("----------------------------------------------------------------------------------------");
        buildLogger.addBuildLogEntry(String.format("LEAPWORK controller hostname: %1$s", leapworkHostname));
        buildLogger.addBuildLogEntry(String.format("Leapwork Https port is enabled: %1$s", leapworkHttps));
        buildLogger.addBuildLogEntry(String.format("LEAPWORK controller port: %1$s", leapworkPort));
        buildLogger.addBuildLogEntry(String.format("JUnit report file name: %1$s", leapworkReport));
        buildLogger.addBuildLogEntry("Schedule names: ");
        buildLogger.addBuildLogEntry(Arrays.toString(Names));
        if (!leapworkSchIds.trim().isEmpty()) {
            buildLogger.addBuildLogEntry("Schedule ids: ");
            buildLogger.addBuildLogEntry(Arrays.toString(Ids));
        }
        buildLogger.addBuildLogEntry(String.format("Delay between status checks: %1$s", leapworkDelay));
        buildLogger.addBuildLogEntry(String.format("Done Status As: %1$s", leapworkDoneStatusAs));
        buildLogger.addBuildLogEntry(String.format("Write keyframes of passed flows: %1$b", leapworkWritePassedFlowKeyFrames));
        buildLogger.addBuildLogEntry(String.format("Passed schedule variables: %1$s", leapworkScheduleVariables));
    }
}

