/*
 * Decompiled with CFR 0.152.
 */
package com.jingxianginfo.apps.tmanOps4Bamboo;

import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.jingxianginfo.apps.tmanOps4Bamboo.tmanUtils;

public class sendSonarWebhookTask
implements CommonTaskType {
    @ComponentImport
    private final ProcessService processService;

    public sendSonarWebhookTask(ProcessService processService) {
        this.processService = processService;
    }

    public TaskResult execute(CommonTaskContext taskContext) {
        String srSonarServer = (String)taskContext.getConfigurationMap().get((Object)"tmanSrSonarServer");
        String srSonarToken = (String)taskContext.getConfigurationMap().get((Object)"tmanSrSonarToken");
        String srSonarProject = (String)taskContext.getConfigurationMap().get((Object)"tmanSrSonarProject");
        String srSonarBranch = (String)taskContext.getConfigurationMap().get((Object)"tmanSrSonarBranch");
        String srEndpoint = (String)taskContext.getConfigurationMap().get((Object)"tmanSrEndpoint");
        String scriptTitle = "taskSendSonarWebhook";
        String scriptBody = "#!/bin/sh\nset -e\necho \"===================== TMAN OPS SEND SONAR WEBHOOK TASK =====================\"\nexport sonar_server=\"" + srSonarServer + "\"\necho \"sonar server: ${sonar_server}\"\nexport sonar_token=\"" + srSonarToken + "\"\necho \"sonar token: ${sonar_token}\"\nexport sonar_project=\"" + srSonarProject + "\"\necho \"sonar project: ${sonar_project}\"\nexport sonar_branch=\"" + srSonarBranch + "\"\necho \"sonar branch: ${sonar_branch}\"\nexport endpoint=\"" + srEndpoint + "\"\necho \"endpoint: ${endpoint}\"\nwhich curl || {\n    echo \"===== Please install command 'curl' in Bamboo agent =====\"\n    exit 0\n}\nwhich jq || {\n    echo \"===== Please install command 'jq' in Bamboo agent =====\"\n    exit 0\n}\nurl=\"${sonar_server}/api/measures/component?component=${sonar_project}&branch=${sonar_branch}&metricKeys=bugs%2Cnew_bugs%2Cvulnerabilities%2Cnew_vulnerabilities%2Csecurity_hotspots%2Cnew_security_hotspots%2Ccode_smells%2Cnew_code_smells%2Ccoverage%2Cnew_coverage\"\necho \"Get SonarQube report from ${url}\"\noutput=$(curl -sk -u \"${sonar_token}\": \"${url}\")\necho \"${output}\"\nsonar_component=$(echo \"${output}\" | jq '.component.measures')\nif [ $? != 0 ]; then\n    echo \"===== Not found measures in the SonarQube =====\"\n    exit 0\nfi\ncount=0\nsonar_metrics=\"\"\nwhile true\ndo\n    echo \"${count} time(s) find metric and value ... \"\n    item=$(echo \"${sonar_component}\" | jq \".[$count]\")\n    if [ \"${item}\" = \"null\" ]; then\n        echo \"Complete to find all metrics and values.\"\n        break\n    fi\n    metric=$(echo ${item} | jq \".metric\")\n    echo ${metric} | grep -q '\"' && metric=$(echo ${metric} | awk -F '\"' '{print $2}')\n    value=$(echo ${item} | jq \".value\")\n    if [ \"${value}\" = \"null\" ]; then\n        value=$(echo ${item} | jq \".period.value\")\n    fi\n    echo ${value} | grep -q '\"' && value=$(echo ${value} | awk -F '\"' '{print $2}')\n    echo \"${metric}:${value}\"\n    sonar_metrics=\"${sonar_metrics}\\n|*${metric}*|${value}|\"\n    count=$(( $count + 1 ))\ndone\npanel_style=\"titleColor=#FFFFFF|titleBGColor=#250838|bgColor=#E4EDF5\"\njira_comment_body=\"{panel:title=_SONARQUBE_ _REPORT_: ${sonar_project}|${panel_style}}[${sonar_project} - ${sonar_branch}|${sonar_server}/dashboard?id=${sonar_project}&branch=${sonar_branch}]\\n${sonar_metrics}\\n{panel}\"\necho \"Send SonarQube report to the endpoint\"\nset -x\ncurl -sk -X POST \"${endpoint}\"     -H \"Content-Type: application/json\"     --data-raw \"{\\\"build\\\":{\\\"buildResultKey\\\":\\\"${bamboo_planKey}-${bamboo_buildNumber}\\\"},\\\"body\\\":\\\"${jira_comment_body}\\\"}\"";
        return tmanUtils.executeScript(this.processService, taskContext, scriptTitle, scriptBody);
    }
}

