/*
 * Decompiled with CFR 0.152.
 */
package com.jingxianginfo.apps.tmanOps4Bamboo;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import java.util.Map;

public class webhookTaskConfigurator
extends AbstractTaskConfigurator {
    public Map<String, String> generateTaskConfigMap(ActionParametersMap params, TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put("tmanWhPayloadUrl", params.getString("tmanWhPayloadUrl"));
        config.put("tmanWhContentType", params.getString("tmanWhContentType"));
        config.put("tmanWhPayloadData", params.getString("tmanWhPayloadData"));
        return config;
    }

    public void populateContextForCreate(Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("tmanWhPayloadUrl", "");
        context.put("tmanWhContentType", "application/json");
        context.put("tmanWhPayloadData", "{}");
    }

    public void populateContextForEdit(Map<String, Object> context, TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        String tmanWhPayloadUrl = (String)taskDefinition.getConfiguration().get("tmanWhPayloadUrl");
        context.put("tmanWhPayloadUrl", tmanWhPayloadUrl);
        String tmanWhContentType = (String)taskDefinition.getConfiguration().get("tmanWhContentType");
        context.put("tmanWhContentType", tmanWhContentType);
        String tmanWhPayloadData = (String)taskDefinition.getConfiguration().get("tmanWhPayloadData");
        context.put("tmanWhPayloadData", tmanWhPayloadData);
    }

    public void validate(ActionParametersMap params, ErrorCollection errorCollection) {
        String tmanWhPayloadData;
        String tmanWhContentType;
        super.validate(params, errorCollection);
        String tmanWhPayloadUrl = params.getString("tmanWhPayloadUrl");
        if (tmanWhPayloadUrl == null || tmanWhPayloadUrl.trim().isEmpty()) {
            errorCollection.addError("tmanWhPayloadUrl", "Webhook Payload URL is required");
        }
        if ((tmanWhContentType = params.getString("tmanWhContentType")) == null || tmanWhContentType.trim().isEmpty()) {
            errorCollection.addError("tmanWhContentType", "Content type is required");
        }
        if ((tmanWhPayloadData = params.getString("tmanWhPayloadData")) == null || tmanWhPayloadData.trim().isEmpty()) {
            errorCollection.addError("tmanWhPayloadData", "Payload data is required");
        }
    }
}

