/*
 * Decompiled with CFR 0.152.
 */
package com.jingxianginfo.apps.tmanOps4Bamboo;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.process.ExternalProcessBuilder;
import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.utils.process.ExternalProcess;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class tmanUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskResult executeScript(ProcessService processService, CommonTaskContext taskContext, String scriptTitle, String scriptBody) {
        BuildLogger buildLogger = taskContext.getBuildLogger();
        String buildKey = taskContext.getCommonContext().getBuildKey().getKey();
        TaskResultBuilder builder = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext);
        File workingDir = taskContext.getWorkingDirectory();
        Path tempDir = Paths.get(System.getProperty("bamboo.home") + "/temp", new String[0]);
        File tempScriptFile = null;
        try {
            tempScriptFile = Files.createTempFile(tempDir, buildKey + "-" + scriptTitle + "-", ".sh", new FileAttribute[0]).toFile();
            try (PrintWriter writer = new PrintWriter(tempScriptFile);){
                writer.write(scriptBody);
            }
            tempScriptFile.setExecutable(true);
            String cmdStr = tempScriptFile.getAbsolutePath();
            ExternalProcess process = processService.createExternalProcess(taskContext, new ExternalProcessBuilder().commandFromString(cmdStr).workingDirectory(workingDir));
            process.execute();
            TaskResult taskResult = builder.checkReturnCode(process, 0).build();
            return taskResult;
        }
        catch (Exception e) {
            buildLogger.addErrorLogEntry("Error executing shell script: " + e.getMessage(), (Throwable)e);
            TaskResult taskResult = TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).failed().build();
            return taskResult;
        }
        finally {
            if (tempScriptFile == null) {
                tempScriptFile.delete();
            }
        }
    }
}

