/*
 * Decompiled with CFR 0.152.
 */
package com.jingxianginfo.apps.tmanOps4Bamboo;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import java.util.Map;

public class mendScannerTaskConfigurator
extends AbstractTaskConfigurator {
    public Map<String, String> generateTaskConfigMap(ActionParametersMap params, TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put("tmanWsWssUrl", params.getString("tmanWsWssUrl"));
        config.put("tmanWsApiKey", params.getString("tmanWsApiKey"));
        config.put("tmanWsUserKey", params.getString("tmanWsUserKey"));
        config.put("tmanWsProductName", params.getString("tmanWsProductName"));
        config.put("tmanWsProductToken", params.getString("tmanWsProductToken"));
        config.put("tmanWsProjectName", params.getString("tmanWsProjectName"));
        config.put("tmanWsProjectToken", params.getString("tmanWsProjectToken"));
        config.put("tmanWsConfiguration", params.getString("tmanWsConfiguration"));
        return config;
    }

    public void populateContextForCreate(Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("tmanWsWssUrl", "${bamboo.ws.wss.url}");
        context.put("tmanWsApiKey", "${bamboo.ws.apikey.secret}");
        context.put("tmanWsUserKey", "${bamboo.ws.userkey.secret}");
        context.put("tmanWsProductName", "${bamboo.planKey}");
        context.put("tmanWsProductToken", "${bamboo.ws.product.token.secret}");
        context.put("tmanWsProjectName", "${bamboo.planKey}");
        context.put("tmanWsProjectToken", "${bamboo.ws.project.token.secret}");
        context.put("tmanWsConfiguration", "maven");
    }

    public void populateContextForEdit(Map<String, Object> context, TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        String tmanWsWssUrl = (String)taskDefinition.getConfiguration().get("tmanWsWssUrl");
        context.put("tmanWsWssUrl", tmanWsWssUrl);
        String tmanWsApiKey = (String)taskDefinition.getConfiguration().get("tmanWsApiKey");
        context.put("tmanWsApiKey", tmanWsApiKey);
        String tmanWsUserKey = (String)taskDefinition.getConfiguration().get("tmanWsUserKey");
        context.put("tmanWsUserKey", tmanWsUserKey);
        String tmanWsProductName = (String)taskDefinition.getConfiguration().get("tmanWsProductName");
        context.put("tmanWsProductName", tmanWsProductName);
        String tmanWsProductToken = (String)taskDefinition.getConfiguration().get("tmanWsProductToken");
        context.put("tmanWsProductToken", tmanWsProductToken);
        String tmanWsProjectName = (String)taskDefinition.getConfiguration().get("tmanWsProjectName");
        context.put("tmanWsProjectName", tmanWsProjectName);
        String tmanWsProjectToken = (String)taskDefinition.getConfiguration().get("tmanWsProjectToken");
        context.put("tmanWsProjectToken", tmanWsProjectToken);
        String tmanWsConfiguration = (String)taskDefinition.getConfiguration().get("tmanWsConfiguration");
        context.put("tmanWsConfiguration", tmanWsConfiguration);
    }

    public void validate(ActionParametersMap params, ErrorCollection errorCollection) {
        String tmanWsConfiguration;
        String tmanWsUserKey;
        String tmanWsApiKey;
        super.validate(params, errorCollection);
        String tmanWsWssUrl = params.getString("tmanWsWssUrl");
        if (tmanWsWssUrl == null || tmanWsWssUrl.trim().isEmpty()) {
            errorCollection.addError("tmanWsWssUrl", "WhiteSource Server URL is required");
        }
        if ((tmanWsApiKey = params.getString("tmanWsApiKey")) == null || tmanWsApiKey.trim().isEmpty()) {
            errorCollection.addError("tmanWsApiKey", "API Key is required");
        }
        if ((tmanWsUserKey = params.getString("tmanWsUserKey")) == null || tmanWsUserKey.trim().isEmpty()) {
            errorCollection.addError("tmanWsUserKey", "User Key is required");
        }
        if (!(tmanWsConfiguration = params.getString("tmanWsConfiguration")).equals("maven") && !tmanWsConfiguration.equals("npm")) {
            errorCollection.addError("tmanWsConfiguration", "Please input \"maven\" or \"npm\"");
        }
        String tmanWsProductName = params.getString("tmanWsProductName");
        String tmanWsProductToken = params.getString("tmanWsProductToken");
        if ((tmanWsProductName == null || tmanWsProductName.trim().isEmpty()) && (tmanWsProductToken == null || tmanWsProductToken.trim().isEmpty())) {
            errorCollection.addError("tmanWsProductName", "At least one of Product Name and Product Token is required");
            errorCollection.addError("tmanWsProductToken", "At least one of Product Name and Product Token is required");
        }
        String tmanWsProjectName = params.getString("tmanWsProjectName");
        String tmanWsProjectToken = params.getString("tmanWsProjectToken");
        if ((tmanWsProjectName == null || tmanWsProjectName.trim().isEmpty()) && (tmanWsProjectToken == null || tmanWsProjectToken.trim().isEmpty())) {
            errorCollection.addError("tmanWsProjectName", "At least one of Project Name and Project Token is required");
            errorCollection.addError("tmanWsProjectToken", "At least one of Project Name and Project Token is required");
        }
    }
}

