/*
 * Decompiled with CFR 0.152.
 */
package com.jingxianginfo.apps.tmanOps4Bamboo;

import com.atlassian.bamboo.process.ProcessService;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.CommonTaskType;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.jingxianginfo.apps.tmanOps4Bamboo.tmanUtils;

public class mendScannerTask
implements CommonTaskType {
    @ComponentImport
    private final ProcessService processService;

    public mendScannerTask(ProcessService processService) {
        this.processService = processService;
    }

    public TaskResult execute(CommonTaskContext taskContext) {
        String wsWssUrl = (String)taskContext.getConfigurationMap().get((Object)"tmanWsWssUrl");
        String wsApiKey = (String)taskContext.getConfigurationMap().get((Object)"tmanWsApiKey");
        String wsUserKey = (String)taskContext.getConfigurationMap().get((Object)"tmanWsUserKey");
        String wsProductName = (String)taskContext.getConfigurationMap().get((Object)"tmanWsProductName");
        String wsProductToken = (String)taskContext.getConfigurationMap().get((Object)"tmanWsProductToken");
        String wsProjectName = (String)taskContext.getConfigurationMap().get((Object)"tmanWsProjectName");
        String wsProjectToken = (String)taskContext.getConfigurationMap().get((Object)"tmanWsProjectToken");
        String wsConfiguration = (String)taskContext.getConfigurationMap().get((Object)"tmanWsConfiguration");
        String scriptTitle = "taskMendScanner";
        String scriptBody = "#!/bin/bash\nset -e\necho \"===== TMAN OPS MEND SCANNER TASK =====\"\necho \"Export required parameters\"\nset -x \n\nexport WS_WSS_URL=" + wsWssUrl + "\nexport WS_APIKEY=" + wsApiKey + "\nexport WS_USERKEY=" + wsUserKey + "\nif [[ \"${bamboo_planKey}\" == \"" + wsProductName + "\" ]]; then\n    export WS_PRODUCTNAME=$(echo ${bamboo_planKey} | awk -F '-' '{print $1}')\nelse\n    export WS_PRODUCTNAME=" + wsProductName + "\nfi\nexport WS_PRODUCTTOKEN=" + wsProductToken + "\nexport WS_PROJECTNAME=" + wsProjectName + "\nexport WS_PROJECTTOKEN=" + wsProjectToken + "\nexport WS_CONFIGURATION=" + wsConfiguration + "\nexport WS_AGENT_JAR=/opt/wss/wss-unified-agent.jar\nexport WS_CONFIG_FILE=wss-generated-file.config\nfunction config_maven() {\n    cat <<MVN_EOF > wss-generated-file.config\ncommandTimeout=30\nresolveAllDependencies=false\narchiveExtractionDepth=7\nfollowSymbolicLinks=true\nhtml.resolveDependencies=false\nincludes=**/*.java **/*.jar\nexcludes=**/src/test/**\nmaven.runPreStep=False\nmaven.resolveDependencies=True\nmaven.aggregateModules=True\nmaven.ignoredScopes=test,provided,system\nmaven.downloadMissingDependencies=False\nmaven.ignoreMvnTreeErrors=False\nmaven.additionalArguments=-Dverbose=false -X\nMVN_EOF\n    return 0\n}\nfunction config_npm() {\n    cat <<NPM_EOF > wss-generated-file.config\nresolveAllDependencies=false\narchiveExtractionDepth=7\nfollowSymbolicLinks=true\nhtml.resolveDependencies=true\nnpm.resolveDependencies=true\nnpm.runPreStep=true\nnpm.yarnProject=true\nincludes=**/*.zip **/*.js\nresolveAllDependencies=True\nnpm.runPreStep=False\nnpm.resolveLockFile=True\nnpm.resolveDependencies=True\nnpm.removeDuplicateDependencies=True\nnpm.resolveAdditionalDependencies=false\nnpm.failOnNpmLsErrors=False\nnpm.ignoreNpmLsErrors=True\ncheckPolicies=True\nfileSystemScan=False\nforceUpdate=True\nnpm.resolveMainPackageJsonOnly=True\nnpm.yarnProject=False\nbower.resolveDependencies=False\nhtml.resolveDependencies=False\nNPM_EOF\n    return 0\n}\nset +x\necho \"Generate WS Configuration File\"\nset -x\nif [[ \"$WS_CONFIGURATION\" == \"maven\" ]]; then\n    config_maven\nelif [[ \"$WS_CONFIGURATION\" == \"npm\" ]]; then\n    config_npm\nelse\n    echo \"No WS_CONFIGURATION: ${WS_CONFIGURATION}\"\n    exit 1\nfi\ncat wss-generated-file.config\nset +x\necho \"Scan with Mend Unified Agent\"\nset -x\njava -Djava.io.tmpdir=/tmp/wstemp -Xms1024m -Xmx2048m -jar ${WS_AGENT_JAR} -generateScanReport true -c ${WS_CONFIG_FILE}";
        return tmanUtils.executeScript(this.processService, taskContext, scriptTitle, scriptBody);
    }
}

