/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.plugins.bamboo.rest;

import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.component.ComponentLocator;
import com.hp.octane.integrations.OctaneConfiguration;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.entities.Entity;
import com.hp.octane.integrations.exceptions.OctaneConnectivityException;
import com.hp.octane.integrations.utils.OctaneUrlParser;
import com.hp.octane.plugins.bamboo.octane.BambooPluginServices;
import com.hp.octane.plugins.bamboo.octane.SDKBasedLoggerProvider;
import com.hp.octane.plugins.bamboo.rest.OctaneConnection;
import com.hp.octane.plugins.bamboo.rest.OctaneConnectionManager;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.acegisecurity.acls.Permission;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Logger;

@Path(value="/test")
@Scanned
public class TestConnectionResource {
    private static final Logger log = SDKBasedLoggerProvider.getLogger(TestConnectionResource.class);

    @POST
    @Path(value="/testconnection")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response testConfiguration(@Context HttpServletRequest request, OctaneConnection model) {
        try {
            OctaneConnectionManager.getInstance().replacePlainPasswordIfRequired(model);
            List<Entity> workspaces = this.tryToConnectAndGetAvailableWorkspaces(model);
            String tooltip = "";
            if (workspaces != null && !workspaces.isEmpty()) {
                int workspaceNumberLimit = 30;
                String titleNewLine = "\n";
                String suffix = workspaces.size() > workspaceNumberLimit ? titleNewLine + "and more " + (workspaces.size() - workspaceNumberLimit) + " workspaces" : "";
                tooltip = workspaces.stream().sorted(Comparator.comparingInt(e -> Integer.parseInt(e.getId()))).limit(workspaceNumberLimit).map(w -> w.getId() + " - " + w.getName()).collect(Collectors.joining(titleNewLine, "Available workspaces are : " + titleNewLine, suffix));
            }
            return Response.status((Response.Status)Response.Status.OK).entity((Object)tooltip).build();
        }
        catch (IllegalArgumentException e2) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)e2.getMessage()).build();
        }
    }

    private List<Entity> tryToConnectAndGetAvailableWorkspaces(OctaneConnection dto) throws OctaneConnectivityException {
        String location = dto.getLocation();
        String clientId = dto.getClientId();
        String clientSecret = dto.getClientSecret();
        String bambooUser = dto.getBambooUser();
        if (StringUtils.isEmpty((String)location)) {
            throw new IllegalArgumentException("Location URL is missing");
        }
        if (StringUtils.isEmpty((String)clientId)) {
            throw new IllegalArgumentException("Client ID is missing");
        }
        if (StringUtils.isEmpty((String)clientSecret)) {
            throw new IllegalArgumentException("Client Secret is missing");
        }
        if (StringUtils.isEmpty((String)bambooUser)) {
            throw new IllegalArgumentException("Bamboo user is missing");
        }
        if (!this.isUserExist(bambooUser)) {
            throw new IllegalArgumentException("Bamboo user does not exist");
        }
        if (!this.hasBuildPermission(bambooUser)) {
            throw new IllegalArgumentException("Bamboo user doesn't have enough permissions");
        }
        OctaneUrlParser octaneUrlParser = OctaneUrlParser.parse(location);
        OctaneConfiguration testedOctaneConfiguration = OctaneConfiguration.createWithUiLocation(UUID.randomUUID().toString(), location);
        testedOctaneConfiguration.setClient(clientId);
        testedOctaneConfiguration.setSecret(clientSecret);
        try {
            return OctaneSDK.testOctaneConfigurationAndFetchAvailableWorkspaces(testedOctaneConfiguration.getUrl(), testedOctaneConfiguration.getSharedSpace(), testedOctaneConfiguration.getClient(), testedOctaneConfiguration.getSecret(), BambooPluginServices.class);
        }
        catch (OctaneConnectivityException e) {
            throw new IllegalArgumentException(e.getErrorMessageVal());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unexpected exception :" + e.getMessage());
        }
    }

    private boolean hasBuildPermission(String userName) {
        PlanManager planManager = (PlanManager)ComponentLocator.getComponent(PlanManager.class);
        List plans = planManager.getAllPlans(Chain.class);
        if (plans.isEmpty()) {
            log.info("Server does not have any plan to run");
            return true;
        }
        for (Chain chain : plans) {
            boolean hasPermission = this.isUserHasPermission((Permission)BambooPermission.BUILD, userName, chain);
            if (!hasPermission) continue;
            return true;
        }
        return false;
    }

    private boolean isUserHasPermission(Permission permissionType, String user, Chain chain) {
        BambooPermissionManager permissionManager = (BambooPermissionManager)ComponentLocator.getComponent(BambooPermissionManager.class);
        return permissionManager.hasPermission(user, permissionType, (Object)chain);
    }

    private boolean isUserExist(String userName) {
        BambooUserManager bambooUserManager = (BambooUserManager)ComponentLocator.getComponent(BambooUserManager.class);
        BambooUser bambooUser = bambooUserManager.loadUserByUsername(userName);
        return bambooUser != null;
    }
}

