/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.plugins.bamboo.octane.mqmtestresults;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.hp.octane.plugins.bamboo.octane.ArtifactsHelper;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MqmTestResultsReporterConfigurator
extends AbstractTaskConfigurator {
    public static final String RESULT_FILE_PATTERN_FIELD = "testResultFilePattern";
    public static final String PUBLISH_TO_BAMBOO = "publishToBamboo";

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        this.registerArtifacts((Job)context.get("plan"));
    }

    private boolean registerArtifacts(@NotNull Job job) {
        String pattern = "**/ALM_Octane_Test_Results/Build_${bamboo.buildNumber}/*.xml";
        return ArtifactsHelper.registerArtifactDefinition(job, "ALM Octane test results", pattern);
    }

    public void populateContextForEdit(Map<String, Object> context, TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        this.registerArtifacts((Job)context.get("plan"));
        context.put(RESULT_FILE_PATTERN_FIELD, taskDefinition.getConfiguration().get(RESULT_FILE_PATTERN_FIELD));
        context.put(PUBLISH_TO_BAMBOO, Boolean.parseBoolean((String)taskDefinition.getConfiguration().get(PUBLISH_TO_BAMBOO)));
    }

    public Map<String, String> generateTaskConfigMap(ActionParametersMap params, TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put(RESULT_FILE_PATTERN_FIELD, params.getString(RESULT_FILE_PATTERN_FIELD));
        config.put(PUBLISH_TO_BAMBOO, params.getString(PUBLISH_TO_BAMBOO));
        return config;
    }

    public void validate(ActionParametersMap params, ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        this.validateXmlFileValue(RESULT_FILE_PATTERN_FIELD, params.getString(RESULT_FILE_PATTERN_FIELD), errorCollection);
    }

    private void validateXmlFileValue(String field, String value, ErrorCollection errorCollection) {
        if (value.contains("../")) {
            errorCollection.addError(field, "Field should not contain '../'");
        }
    }
}

