/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.plugins.bamboo.octane;

import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.commit.CommitFile;
import com.atlassian.bamboo.plan.AbstractChain;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultError;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.trigger.CodeChangedTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.ManualBuildTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.ScheduledTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.plugin.util.ContextClassLoaderSwitchingUtil;
import com.ctc.wstx.stax.WstxEventFactory;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.causes.CIEventCause;
import com.hp.octane.integrations.dto.causes.CIEventCauseType;
import com.hp.octane.integrations.dto.configuration.CIProxyConfiguration;
import com.hp.octane.integrations.dto.events.CIEvent;
import com.hp.octane.integrations.dto.events.CIEventType;
import com.hp.octane.integrations.dto.events.MultiBranchType;
import com.hp.octane.integrations.dto.events.PhaseType;
import com.hp.octane.integrations.dto.general.CIJobsList;
import com.hp.octane.integrations.dto.general.CIServerInfo;
import com.hp.octane.integrations.dto.general.CIServerTypes;
import com.hp.octane.integrations.dto.parameters.CIParameter;
import com.hp.octane.integrations.dto.pipelines.PipelineNode;
import com.hp.octane.integrations.dto.pipelines.PipelinePhase;
import com.hp.octane.integrations.dto.scm.SCMChange;
import com.hp.octane.integrations.dto.scm.SCMCommit;
import com.hp.octane.integrations.dto.scm.SCMData;
import com.hp.octane.integrations.dto.scm.SCMRepository;
import com.hp.octane.integrations.dto.scm.SCMType;
import com.hp.octane.integrations.dto.snapshots.CIBuildResult;
import com.hp.octane.integrations.dto.snapshots.CIBuildStatus;
import com.hp.octane.integrations.dto.tests.TestRun;
import com.hp.octane.integrations.dto.tests.TestRunError;
import com.hp.octane.integrations.dto.tests.TestRunResult;
import com.hp.octane.plugins.bamboo.listener.ParametersHelper;
import com.hp.octane.plugins.bamboo.octane.BambooPluginServices;
import com.hp.octane.plugins.bamboo.octane.HPRunnerType;
import com.hp.octane.plugins.bamboo.octane.HPRunnerTypeUtils;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class DefaultOctaneConverter {
    private static DTOFactory dtoFactoryInstance;
    private static final int DEFAULT_STRING_SIZE = 255;
    private static final DefaultOctaneConverter converter;

    private DefaultOctaneConverter() {
        dtoFactoryInstance = DTOFactory.getInstance();
        ContextClassLoaderSwitchingUtil.runInContext((ClassLoader)WstxEventFactory.class.getClassLoader(), () -> dtoFactoryInstance.getXMLMapper());
    }

    public static DefaultOctaneConverter getInstance() {
        return converter;
    }

    public static DTOFactory getDTOFactory() {
        return dtoFactoryInstance;
    }

    public PipelineNode getPipelineNodeFromJob(ImmutableJob job) {
        return dtoFactoryInstance.newDTO(PipelineNode.class).setJobCiId(this.getJobCiId(job)).setName(job.getBuildName());
    }

    public String getRootJobCiId(PlanIdentifier identifier) {
        return this.getCiId(identifier);
    }

    public String getJobCiId(ImmutableJob job) {
        return this.getCiId((PlanIdentifier)job);
    }

    public PipelinePhase getPipelinePhaseFromStage(ImmutableChainStage stage) {
        PipelinePhase phase = dtoFactoryInstance.newDTO(PipelinePhase.class).setName(stage.getName()).setBlocking(true);
        ArrayList<PipelineNode> nodes = new ArrayList<PipelineNode>(stage.getJobs().size());
        for (ImmutableJob job : stage.getJobs()) {
            nodes.add(this.getPipelineNodeFromJob(job));
        }
        phase.setJobs(nodes);
        return phase;
    }

    public CIProxyConfiguration getProxyCconfiguration(String server, int port, String user, String password) {
        return dtoFactoryInstance.newDTO(CIProxyConfiguration.class).setHost(server).setPort(port).setUsername(user).setPassword(password);
    }

    public PipelineNode getRootPipelineNodeFromTopLevelPlan(AbstractChain plan) {
        PipelineNode node = dtoFactoryInstance.newDTO(PipelineNode.class).setJobCiId(this.getRootJobCiId((PlanIdentifier)plan)).setName(plan.getName()).setMultiBranchType(MultiBranchType.MULTI_BRANCH_PARENT);
        ArrayList<PipelinePhase> phases = new ArrayList<PipelinePhase>(plan.getAllStages().size());
        List variables = plan.getVariables();
        if (!variables.isEmpty()) {
            ArrayList<CIParameter> params = new ArrayList<CIParameter>();
            for (VariableDefinition def : variables) {
                if (ParametersHelper.isEncrypted((VariableDefinitionContext)def)) continue;
                params.add(dtoFactoryInstance.newDTO(CIParameter.class).setName(def.getKey()).setDefaultValue(def.getValue()));
            }
            node.setParameters(params);
        }
        for (ImmutableChainStage stage : plan.getAllStages()) {
            phases.add(this.getPipelinePhaseFromStage(stage));
        }
        node.setPhasesInternal(phases);
        return node;
    }

    public CIServerInfo getServerInfo(String baseUrl, String bambooVersion) {
        return dtoFactoryInstance.newDTO(CIServerInfo.class).setSendingTime(System.currentTimeMillis()).setType(CIServerTypes.BAMBOO.value()).setVersion(bambooVersion).setUrl(baseUrl);
    }

    public CIBuildResult getJobResult(BuildState buildState) {
        switch (buildState) {
            case FAILED: {
                return CIBuildResult.FAILURE;
            }
            case SUCCESS: {
                return CIBuildResult.SUCCESS;
            }
        }
        return CIBuildResult.UNAVAILABLE;
    }

    public CIBuildStatus getCIBuildStatus(LifeCycleState state) {
        switch (state) {
            case PENDING: 
            case QUEUED: {
                return CIBuildStatus.QUEUED;
            }
            case IN_PROGRESS: {
                return CIBuildStatus.RUNNING;
            }
            case NOT_BUILT: 
            case FINISHED: {
                return CIBuildStatus.FINISHED;
            }
        }
        return CIBuildStatus.UNAVAILABLE;
    }

    public CIJobsList getRootJobsList(List<TopLevelPlan> plans, boolean includeParameters) {
        CIJobsList jobsList = dtoFactoryInstance.newDTO(CIJobsList.class).setJobs(new PipelineNode[0]);
        ArrayList<PipelineNode> nodes = new ArrayList<PipelineNode>(plans.size());
        for (TopLevelPlan plan : plans) {
            List varDefinitions;
            PipelineNode node = dtoFactoryInstance.newDTO(PipelineNode.class).setJobCiId(this.getRootJobCiId((PlanIdentifier)plan)).setName(plan.getName()).setMultiBranchType(MultiBranchType.MULTI_BRANCH_PARENT);
            if (includeParameters && !(varDefinitions = plan.getEffectiveVariables()).isEmpty()) {
                ArrayList<CIParameter> params = new ArrayList<CIParameter>();
                node.setParameters(params);
                for (VariableDefinition def : varDefinitions) {
                    if (ParametersHelper.isEncrypted((VariableDefinitionContext)def)) continue;
                    params.add(dtoFactoryInstance.newDTO(CIParameter.class).setName(def.getKey()).setDefaultValue(def.getValue()));
                }
                if (node.getParameters() != null) {
                    Optional<CIParameter> opt = node.getParameters().stream().filter(p -> "testsToRun".equals(p.getName())).findFirst();
                    node.setIsTestRunner(opt.isPresent());
                } else {
                    node.setIsTestRunner(false);
                }
            }
            nodes.add(node);
        }
        jobsList.setJobs(nodes.toArray(new PipelineNode[0]));
        return jobsList;
    }

    public String getCiId(PlanIdentifier identifier) {
        return identifier.getPlanKey().getKey();
    }

    public TestRun getTestRunFromTestResult(BuildContext buildContext, HPRunnerType runnerType, TestResults testResult, TestRunResult result, long startTime) {
        String className = testResult.getClassName();
        String simpleName = testResult.getShortClassName();
        String packageName = className.substring(0, className.length() - simpleName.length() - (className.length() > simpleName.length() ? 1 : 0));
        String testName = testResult.getActualMethodName();
        if (buildContext.getCheckoutLocation().size() == 1) {
            String checkoutDir = (String)buildContext.getCheckoutLocation().values().iterator().next();
            if (testName.startsWith(checkoutDir)) {
                testName = testName.substring(checkoutDir.length());
                testName = StringUtils.stripStart((String)testName, (String)"\\/");
            }
            if (HPRunnerType.UFT.equals((Object)runnerType)) {
                packageName = "";
                simpleName = "";
                int packageSplitter = testName.lastIndexOf("\\");
                if (packageSplitter > 0) {
                    packageName = testName.substring(0, packageSplitter);
                    testName = testName.substring(packageSplitter + 1);
                }
            }
        }
        TestRun testRun = dtoFactoryInstance.newDTO(TestRun.class).setClassName(simpleName).setDuration(Math.round((double)testResult.getDurationMs())).setPackageName(packageName).setResult(result).setStarted(startTime).setTestName(testName);
        if (result == TestRunResult.FAILED) {
            TestRunError error = dtoFactoryInstance.newDTO(TestRunError.class).setErrorMessage(testResult.getSystemOut());
            if (!testResult.getErrors().isEmpty()) {
                error.setStackTrace(((TestCaseResultError)testResult.getErrors().get(0)).getContent());
            }
            testRun.setError(error);
        }
        String externalReport = null;
        if (HPRunnerType.UFT.equals((Object)runnerType)) {
            externalReport = this.getExternalReportForUft(buildContext, testName);
            if (testResult.getSystemOut() != null && testResult.getSystemOut().contains("warning")) {
                TestRunError error = dtoFactoryInstance.newDTO(TestRunError.class).setErrorMessage("Test ended with 'Warning' status.");
                testRun.setError(error);
            }
        }
        if (StringUtils.isNotEmpty(externalReport)) {
            testRun.setExternalReportUrl(externalReport);
        }
        testRun.setClassName(this.restrictSize(testRun.getClassName(), 255)).setPackageName(this.restrictSize(testRun.getPackageName(), 255)).setTestName(this.restrictSize(testRun.getTestName(), 255));
        return testRun;
    }

    private String restrictSize(String value, int size) {
        String result = value;
        if (value != null && value.length() > size) {
            result = value.substring(0, size);
        }
        return result;
    }

    private String getExternalReportForUft(BuildContext buildContext, String testName) {
        try {
            String baseUrl = BambooPluginServices.getBambooServerBaseUrl();
            String planName = buildContext.getParentBuildContext().getTypedPlanKey().getKey();
            String jobName = buildContext.getResultKey().getEntityKey().getKey().substring(planName.length() + 1);
            long buildId = buildContext.getResultKey().getResultNumberLong();
            long taskId = 0L;
            for (TaskDefinition td : buildContext.getBuildDefinition().getTaskDefinitions()) {
                if (!td.getPluginKey().equals(HPRunnerTypeUtils.UFT_FS_PLUGIN_KEY)) continue;
                taskId = td.getId();
            }
            String externalReportUrl = String.format("%s/artifact/%s/%s/build-%s/Micro-Focus-Tasks-Artifact-Definition/UFT_Build_%s/%03d_File_System_Execution/%s/Report.html", baseUrl, planName, jobName, buildId, buildId, taskId, testName);
            URL url = new URL(externalReportUrl);
            URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            String result = uri.toURL().toString();
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public CIEvent getEventWithDetails(String project, String buildCiId, String displayName, CIEventType eventType, long startTime, long estimatedDuration, List<CIEventCause> causes, String number, BuildState buildState, Long currnetTime, PhaseType phaseType) {
        CIEvent event = this.getEventWithDetails(project, buildCiId, displayName, eventType, startTime, estimatedDuration, causes, number, phaseType);
        event.setDuration(currnetTime);
        event.setResult(this.getJobResult(buildState));
        event.setMultiBranchType(MultiBranchType.MULTI_BRANCH_PARENT);
        return event;
    }

    public CIEvent getEventWithDetails(String project, CIEventType eventType) {
        CIEvent event = dtoFactoryInstance.newDTO(CIEvent.class).setEventType(eventType).setProject(project);
        return event;
    }

    public CIEvent getEventWithDetails(String project, String buildCiId, String displayName, CIEventType eventType, long startTime, long estimatedDuration, List<CIEventCause> causes, String number, PhaseType phaseType) {
        CIEvent event = dtoFactoryInstance.newDTO(CIEvent.class).setEventType(eventType).setCauses(causes).setProject(project).setProjectDisplayName(displayName).setBuildCiId(buildCiId).setEstimatedDuration(estimatedDuration).setStartTime(startTime).setPhaseType(phaseType).setMultiBranchType(MultiBranchType.MULTI_BRANCH_PARENT);
        if (number != null) {
            event.setNumber(number);
        }
        return event;
    }

    public CIEventCause getCause(TriggerReason reason) {
        if (reason instanceof ManualBuildTriggerReason) {
            ManualBuildTriggerReason manual = (ManualBuildTriggerReason)reason;
            return dtoFactoryInstance.newDTO(CIEventCause.class).setType(CIEventCauseType.USER).setUser(manual.getUserName());
        }
        if (reason instanceof CodeChangedTriggerReason) {
            return dtoFactoryInstance.newDTO(CIEventCause.class).setType(CIEventCauseType.SCM);
        }
        if (reason instanceof ScheduledTriggerReason) {
            return dtoFactoryInstance.newDTO(CIEventCause.class).setType(CIEventCauseType.TIMER);
        }
        return dtoFactoryInstance.newDTO(CIEventCause.class).setType(CIEventCauseType.UNDEFINED);
    }

    public CIEventCause getUpstreamCause(String buildCiId, String project, CIEventCause parentReason) {
        return dtoFactoryInstance.newDTO(CIEventCause.class).setBuildCiId(buildCiId).setCauses(Collections.singletonList(parentReason)).setProject(project).setType(CIEventCauseType.UPSTREAM);
    }

    public com.hp.octane.integrations.dto.tests.BuildContext getBuildContext(String instanceId, String jobId, String buildId) {
        return dtoFactoryInstance.newDTO(com.hp.octane.integrations.dto.tests.BuildContext.class).setBuildId(buildId).setBuildName(buildId).setJobId(jobId).setJobName(jobId).setServerId(instanceId);
    }

    private List<SCMChange> getChangeList(List<CommitFile> fileList) {
        ArrayList<SCMChange> scmChangesList = new ArrayList<SCMChange>();
        for (CommitFile commitFile : fileList) {
            SCMChange scmChange = dtoFactoryInstance.newDTO(SCMChange.class).setFile(commitFile.getName()).setType("edit");
            scmChangesList.add(scmChange);
        }
        return scmChangesList;
    }

    private SCMRepository createRepository(PlanRepositoryDefinition repo) {
        SCMRepository scmRepository = dtoFactoryInstance.newDTO(SCMRepository.class);
        if (repo.getPluginKey().contains(":svn")) {
            scmRepository.setUrl((String)repo.getVcsLocation().getConfiguration().get("repository.svn.repositoryRoot"));
            scmRepository.setType(SCMType.SVN);
            scmRepository.setBranch(repo.getBranch().getVcsBranch().getName());
        } else if (repo.getPluginKey().contains(":git")) {
            scmRepository.setUrl((String)repo.getVcsLocation().getConfiguration().get("repository.git.repositoryUrl"));
            scmRepository.setType(SCMType.GIT);
            scmRepository.setBranch(repo.getBranch().getVcsBranch().getName());
        } else {
            scmRepository.setType(SCMType.UNKNOWN);
        }
        return scmRepository;
    }

    private SCMCommit getScmCommit(CommitContext commitContext) {
        SCMCommit scmCommit = dtoFactoryInstance.newDTO(SCMCommit.class);
        scmCommit.setRevId(commitContext.getChangeSetId());
        scmCommit.setComment(commitContext.getComment());
        scmCommit.setUser(commitContext.getAuthorContext().getName());
        scmCommit.setUserEmail(commitContext.getAuthorContext().getEmail());
        scmCommit.setTime(commitContext.getDate().getTime());
        scmCommit.setChanges(this.getChangeList(commitContext.getFiles()));
        return scmCommit;
    }

    public SCMData getScmData(BuildContext buildContext) {
        SCMData scmData = null;
        SCMRepository scmRepository = null;
        if (buildContext.getVcsRepositories() != null && !buildContext.getVcsRepositories().isEmpty()) {
            PlanRepositoryDefinition repo = (PlanRepositoryDefinition)buildContext.getVcsRepositories().get(0);
            scmRepository = this.createRepository(repo);
        }
        ArrayList<SCMCommit> scmCommitList = new ArrayList<SCMCommit>();
        BuildChanges buildChanges = buildContext.getBuildChanges();
        for (BuildRepositoryChanges change : buildChanges.getRepositoryChanges()) {
            for (CommitContext commitContext : change.getChanges()) {
                scmCommitList.add(this.getScmCommit(commitContext));
            }
        }
        if (scmCommitList.size() > 0) {
            scmData = dtoFactoryInstance.newDTO(SCMData.class);
            scmData.setCommits(scmCommitList);
            scmData.setRepository(scmRepository);
            scmData.setBuiltRevId(buildContext.getPlanResultKey().getKey());
        }
        return scmData;
    }

    static {
        converter = new DefaultOctaneConverter();
    }
}

