/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.plugins.bamboo.octane;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.applinks.ImpersonationService;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.BuildLogFileAccessor;
import com.atlassian.bamboo.build.logger.BuildLogFileAccessorFactory;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.ConcurrentBuildConfig;
import com.atlassian.bamboo.plan.AbstractChain;
import com.atlassian.bamboo.plan.ExecutionRequestResult;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanExecutionManager;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.TopLevelPlan;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugin.BambooApplication;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.variables.ResultsSummaryVariableAccessor;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.v2.build.queue.BuildQueueManager;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import com.hp.octane.integrations.CIPluginServices;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.configuration.CIProxyConfiguration;
import com.hp.octane.integrations.dto.connectivity.OctaneResponse;
import com.hp.octane.integrations.dto.executor.CredentialsInfo;
import com.hp.octane.integrations.dto.executor.DiscoveryInfo;
import com.hp.octane.integrations.dto.executor.TestConnectivityInfo;
import com.hp.octane.integrations.dto.general.CIBranchesList;
import com.hp.octane.integrations.dto.general.CIBuildStatusInfo;
import com.hp.octane.integrations.dto.general.CIJobsList;
import com.hp.octane.integrations.dto.general.CIPluginInfo;
import com.hp.octane.integrations.dto.general.CIServerInfo;
import com.hp.octane.integrations.dto.parameters.CIParameter;
import com.hp.octane.integrations.dto.parameters.CIParameters;
import com.hp.octane.integrations.dto.pipelines.PipelineNode;
import com.hp.octane.integrations.dto.scm.Branch;
import com.hp.octane.integrations.dto.snapshots.CIBuildResult;
import com.hp.octane.integrations.dto.snapshots.CIBuildStatus;
import com.hp.octane.integrations.exceptions.ConfigurationException;
import com.hp.octane.integrations.exceptions.PermissionException;
import com.hp.octane.integrations.utils.CIPluginSDKUtils;
import com.hp.octane.integrations.utils.SdkStringUtils;
import com.hp.octane.plugins.bamboo.octane.DefaultOctaneConverter;
import com.hp.octane.plugins.bamboo.octane.MqmResultsHelper;
import com.hp.octane.plugins.bamboo.octane.SDKBasedLoggerProvider;
import com.hp.octane.plugins.bamboo.octane.uft.UftManager;
import com.hp.octane.plugins.bamboo.rest.OctaneConnection;
import com.hp.octane.plugins.bamboo.rest.OctaneConnectionManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.acegisecurity.acls.Permission;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BambooPluginServices
extends CIPluginServices {
    private static final Logger log = SDKBasedLoggerProvider.getLogger(BambooPluginServices.class);
    private final String pluginVersion;
    private final String bambooVersion;
    public static final String PLUGIN_KEY = "com.hpe.adm.octane.ciplugins.bamboo-ci-plugin";
    private PlanManager planMan;
    private CachedPlanManager cachedPlanMan;
    private ImpersonationService impService;
    private PlanExecutionManager planExecMan;
    private BuildQueueManager buildQueueManager;
    private BambooUserManager bambooUserManager;
    private ResultsSummaryVariableAccessor accessor;
    private BuildResultsSummaryManager resultsSummaryManager;
    private ChainBranchManager chainBranchManager;
    private BuildLogFileAccessorFactory buildLogFileAccessorFactory;
    Pattern parentExtractorRegex = Pattern.compile("^(.*?)[0-9]+$");
    private static DefaultOctaneConverter CONVERTER = DefaultOctaneConverter.getInstance();

    public BambooPluginServices() {
        this.planExecMan = (PlanExecutionManager)ComponentLocator.getComponent(PlanExecutionManager.class);
        this.planMan = (PlanManager)ComponentLocator.getComponent(PlanManager.class);
        this.cachedPlanMan = (CachedPlanManager)ComponentLocator.getComponent(CachedPlanManager.class);
        this.impService = (ImpersonationService)ComponentLocator.getComponent(ImpersonationService.class);
        this.buildQueueManager = (BuildQueueManager)ComponentLocator.getComponent(BuildQueueManager.class);
        this.bambooUserManager = (BambooUserManager)ComponentLocator.getComponent(BambooUserManager.class);
        this.pluginVersion = ((PluginAccessor)ComponentLocator.getComponent(PluginAccessor.class)).getPlugin(PLUGIN_KEY).getPluginInformation().getVersion();
        this.bambooVersion = ((BambooApplication)ComponentLocator.getComponent(BambooApplication.class)).getVersion();
        this.accessor = (ResultsSummaryVariableAccessor)ComponentLocator.getComponent(ResultsSummaryVariableAccessor.class);
        this.resultsSummaryManager = (BuildResultsSummaryManager)ComponentLocator.getComponent(BuildResultsSummaryManager.class);
        this.chainBranchManager = (ChainBranchManager)ComponentLocator.getComponent(ChainBranchManager.class);
        this.buildLogFileAccessorFactory = (BuildLogFileAccessorFactory)ComponentLocator.getComponent(BuildLogFileAccessorFactory.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBuildLog(String jobId, String buildId) {
        ByteArrayInputStream result = null;
        BuildLogFileAccessor fileAccessor = null;
        try {
            List resultEntries;
            PlanKey planKey = PlanKeys.getPlanKey((String)jobId);
            int buildNumber = PlanKeys.getPlanResultKey((String)buildId).getBuildNumber();
            fileAccessor = this.buildLogFileAccessorFactory.createBuildLogFileAccessor((Key)planKey, buildNumber);
            if (fileAccessor.openFileForIteration() && (resultEntries = fileAccessor.getLastNLogs(fileAccessor.getNumberOfLinesInFile())) != null && !resultEntries.isEmpty()) {
                result = new ByteArrayInputStream(resultEntries.stream().map(LogEntry::getLog).collect(Collectors.joining("\n")).getBytes());
            }
        }
        catch (IOException ioe) {
            log.error("cannot get build logger Job Id = {} Build Id = {}", (Object)jobId, (Object)buildId);
        }
        catch (IllegalArgumentException iae) {
            log.error(iae.getMessage());
        }
        finally {
            if (fileAccessor != null) {
                fileAccessor.closeFileForIteration();
            }
        }
        return result;
    }

    @Override
    public File getAllowedOctaneStorage() {
        return SDKBasedLoggerProvider.getAllowedStorageFile();
    }

    @Override
    public CIJobsList getJobsList(boolean includeParameters, Long workspaceId) {
        log.info("Get jobs list");
        Callable<List> plansGetter = () -> this.planMan.getAllPlans(TopLevelPlan.class);
        List plans = this.executeImpersonatedCall(plansGetter, "getJobsList");
        return CONVERTER.getRootJobsList(plans, includeParameters);
    }

    @Override
    public PipelineNode getPipeline(String pipelineId) {
        String pipelineIdUpper = pipelineId.toUpperCase();
        log.info("get pipeline " + pipelineIdUpper);
        Callable<Plan> planGetter = () -> {
            PlanKey planKey = PlanKeys.getPlanKey((String)pipelineIdUpper);
            return this.planMan.getPlanByKey(planKey);
        };
        AbstractChain plan = (AbstractChain)this.executeImpersonatedCall(planGetter, "getPipeline");
        PipelineNode pipelineNode = CONVERTER.getRootPipelineNodeFromTopLevelPlan(plan);
        pipelineNode.setDefaultBranchName(this.getDefaultDisplayName((ImmutableChain)plan));
        return pipelineNode;
    }

    @Override
    public CIPluginInfo getPluginInfo() {
        log.debug("get plugin info");
        return DefaultOctaneConverter.getDTOFactory().newDTO(CIPluginInfo.class).setVersion(this.pluginVersion);
    }

    @Override
    public CIProxyConfiguration getProxyConfiguration(URL targetUrl) {
        log.debug("get proxy configuration");
        CIProxyConfiguration result = null;
        if (this.isProxyNeeded(targetUrl)) {
            log.debug("proxy is required for host " + targetUrl.getHost());
            String protocol = targetUrl.getProtocol();
            result = CONVERTER.getProxyCconfiguration(this.getProxyProperty(protocol + ".proxyHost", null), Integer.parseInt(this.getProxyProperty(protocol + ".proxyPort", null)), System.getProperty(protocol + ".proxyUser", ""), System.getProperty(protocol + ".proxyPassword", ""));
        }
        return result;
    }

    private String getProxyProperty(String propKey, String def) {
        if (def == null) {
            def = "";
        }
        return System.getProperty(propKey) != null ? System.getProperty(propKey).trim() : def;
    }

    private boolean isProxyNeeded(URL targetHostUrl) {
        boolean result = false;
        String proxyHost = this.getProxyProperty(targetHostUrl.getProtocol() + ".proxyHost", "");
        String nonProxyHostsStr = this.getProxyProperty(targetHostUrl.getProtocol() + ".nonProxyHosts", "");
        if (SdkStringUtils.isNotEmpty(proxyHost) && !CIPluginSDKUtils.isNonProxyHost(targetHostUrl.getHost(), nonProxyHostsStr)) {
            result = true;
        }
        return result;
    }

    @Override
    public CIServerInfo getServerInfo() {
        log.debug("get ci server info");
        String baseUrl = BambooPluginServices.getBambooServerBaseUrl();
        return CONVERTER.getServerInfo(baseUrl, this.bambooVersion);
    }

    @Override
    public void stopPipelineRun(String pipeline, CIParameters ciParameters) {
        log.info("starting pipeline stop");
        Callable<String> action = () -> {
            BambooUserManager um = (BambooUserManager)ComponentLocator.getComponent(BambooUserManager.class);
            BambooUser user = um.getBambooUser(this.getRunAsUser());
            PlanKey planKey = PlanKeys.getPlanKey((String)pipeline.toUpperCase());
            ImmutableChain chain = (ImmutableChain)this.cachedPlanMan.getPlanByKey(planKey, ImmutableChain.class);
            if (chain != null) {
                if (!this.isUserHasPermission((Permission)BambooPermission.BUILD, user, chain)) {
                    throw new PermissionException(403);
                }
                log.info(String.format("plan key=%s ,build key=%s ,chain key=%s", chain.getPlanKey().getKey(), chain.getBuildKey(), chain.getKey()));
                CIParameter octaneExecutionId = ciParameters.getParameters().stream().filter(parameter -> parameter.getName().equals("octane_auto_action_execution_id")).findFirst().orElse(null);
                if (octaneExecutionId == null) {
                    this.planExecMan.stopPlan(chain.getPlanKey(), true, user.getName());
                } else {
                    ArrayList allQueuedSummaries = (ArrayList)this.resultsSummaryManager.getAllQueuedResultSummaries(BuildResultsSummary.class);
                    ArrayList allInProgressSummaries = (ArrayList)this.resultsSummaryManager.getAllInProgressResultSummaries(BuildResultsSummary.class);
                    Boolean stoppedInQueued = this.stopBuildWithOctaneId(user, planKey, octaneExecutionId, allQueuedSummaries);
                    if (!stoppedInQueued.booleanValue()) {
                        this.stopBuildWithOctaneId(user, planKey, octaneExecutionId, allInProgressSummaries);
                    }
                }
            } else {
                throw new ConfigurationException(404);
            }
            return null;
        };
        this.executeImpersonatedCall(action, "Stop Pipeline");
    }

    private Boolean stopBuildWithOctaneId(BambooUser user, PlanKey planKey, CIParameter octaneExecutionId, List<BuildResultsSummary> resultSummaries) {
        return resultSummaries.parallelStream().filter(resultSummary -> resultSummary.getPlanKey().getKey().contains(planKey.getKey())).map(resultsSummary -> {
            int buildId = resultsSummary.getBuildNumber();
            PlanResultKey planResultKey = PlanKeys.getPlanResultKey((PlanKey)planKey, (int)buildId);
            Map contextMap = this.accessor.calculateCurrentVariablesState(planResultKey);
            VariableDefinitionContext variable = contextMap.getOrDefault("octane_auto_action_execution_id", null);
            if (variable != null && octaneExecutionId.getValue().equals(variable.getValue())) {
                this.planExecMan.stopPlan(planResultKey, true, user.getName());
                return true;
            }
            return false;
        }).filter(flag -> flag).findAny().orElse(false);
    }

    @Override
    public CIBuildStatusInfo getJobBuildStatus(String pipeline, String parameterName, String parameterValue) {
        log.info("getting pipeline build status");
        Callable<CIBuildStatusInfo> action = () -> {
            BambooUserManager um = (BambooUserManager)ComponentLocator.getComponent(BambooUserManager.class);
            BambooUser user = um.getBambooUser(this.getRunAsUser());
            PlanKey planKey = PlanKeys.getPlanKey((String)pipeline.toUpperCase());
            ImmutableChain chain = (ImmutableChain)this.cachedPlanMan.getPlanByKey(planKey, ImmutableChain.class);
            if (chain != null) {
                if (!this.isUserHasPermission((Permission)BambooPermission.READ, user, chain)) {
                    throw new PermissionException(403);
                }
                CIParameter ciParameter = DTOFactory.getInstance().newDTO(CIParameter.class).setName(parameterName).setValue(parameterValue);
                List allSummaries = this.resultsSummaryManager.getResultSummariesForPlan((ImmutablePlan)chain, 0, 0);
                ResultsSummary buildToCheck = allSummaries.parallelStream().map(resultsSummary -> {
                    int buildId = resultsSummary.getBuildNumber();
                    PlanResultKey planResultKey = PlanKeys.getPlanResultKey((PlanKey)planKey, (int)buildId);
                    Map contextMap = this.accessor.calculateCurrentVariablesState(planResultKey);
                    VariableDefinitionContext variable = contextMap.getOrDefault("octane_auto_action_execution_id", null);
                    if (variable != null && ciParameter.getValue().equals(variable.getValue())) {
                        return resultsSummary;
                    }
                    return null;
                }).filter(Objects::nonNull).findAny().orElse(null);
                CIBuildStatus buildStatus = CIBuildStatus.UNAVAILABLE;
                CIBuildResult buildResult = CIBuildResult.UNAVAILABLE;
                String buildCiId = null;
                if (buildToCheck != null) {
                    buildStatus = CONVERTER.getCIBuildStatus(buildToCheck.getLifeCycleState());
                    buildCiId = PlanKeys.getPlanResultKey((PlanKey)planKey, (int)buildToCheck.getBuildNumber()).getKey();
                    buildResult = CONVERTER.getJobResult(buildToCheck.getBuildState());
                }
                return DTOFactory.getInstance().newDTO(CIBuildStatusInfo.class).setJobCiId(planKey.getKey()).setBuildStatus(buildStatus).setBuildCiId(buildCiId).setParamName(parameterName).setParamValue(parameterValue).setResult(buildResult);
            }
            throw new ConfigurationException(404);
        };
        return this.executeImpersonatedCall(action, "Get Job Build Status");
    }

    @Override
    public CIBranchesList getBranchesList(String jobCiId, String filterBranchName) {
        log.info("getting pipeline build status");
        Callable<CIBranchesList> action = () -> {
            ImmutableChain chain = (ImmutableChain)this.cachedPlanMan.getPlanByKey(PlanKeys.getPlanKey((String)jobCiId.toUpperCase()), ImmutableChain.class);
            if (chain != null) {
                String defaultDisplayName;
                ArrayList<Branch> branches = new ArrayList<Branch>();
                Branch branch = this.chainBranchManager.getBranchesForChain(chain).parallelStream().filter(chainBranch -> chainBranch.getBuildName().equals(filterBranchName)).map(chainBranch -> DTOFactory.getInstance().newDTO(Branch.class).setName(chainBranch.getBuildName()).setInternalId(chainBranch.getPlanKey().getKey())).findAny().orElse(null);
                if (branch == null && Objects.equals(defaultDisplayName = this.getDefaultDisplayName(chain), filterBranchName)) {
                    branch = DTOFactory.getInstance().newDTO(Branch.class).setName(defaultDisplayName).setInternalId(chain.getPlanKey().getKey());
                }
                if (branch != null) {
                    branches.add(branch);
                }
                return DTOFactory.getInstance().newDTO(CIBranchesList.class).setBranches(branches);
            }
            throw new ConfigurationException(404);
        };
        return this.executeImpersonatedCall(action, "Get Branches List");
    }

    @NotNull
    private String getDefaultDisplayName(ImmutableChain chain) {
        PlanRepositoryDefinition repositoryDefinition = PlanHelper.getDefaultPlanRepositoryDefinition((ImmutablePlan)chain);
        return repositoryDefinition != null ? repositoryDefinition.getBranch().getVcsBranch().getDisplayName() : "";
    }

    @Override
    public void runPipeline(String pipeline, CIParameters ciParameters) {
        log.info("starting pipeline run");
        Callable<String> impersonated = () -> {
            BambooUserManager um = (BambooUserManager)ComponentLocator.getComponent(BambooUserManager.class);
            BambooUser user = um.getBambooUser(this.getRunAsUser());
            Chain chain = (Chain)this.planMan.getPlanByKey(PlanKeys.getPlanKey((String)pipeline.toUpperCase()), Chain.class);
            if (chain == null || chain.isSuspendedFromBuilding()) {
                throw new ConfigurationException(404);
            }
            log.info(String.format("plan key=%s ,build key=%s ,chain key=%s", chain.getPlanKey().getKey(), chain.getBuildKey(), chain.getKey()));
            if (!this.isUserHasPermission((Permission)BambooPermission.BUILD, user, (ImmutableChain)chain)) {
                throw new PermissionException(403);
            }
            HashMap<String, String> variables = new HashMap<String, String>();
            HashMap params = new HashMap();
            if (ciParameters != null) {
                for (CIParameter param : ciParameters.getParameters()) {
                    if (param.getName().equals("testsToRun") && param.getValue().toString().length() > 3900) {
                        String[] split = param.getValue().toString().split("(?<=\\G.{3900})");
                        log.info("testsToRun parameter is too long, split it to " + split.length);
                        for (int i = 0; i < split.length; ++i) {
                            variables.put(param.getName() + i, split[i]);
                        }
                        variables.put("test-to-run-split-count", split.length + "");
                        param.setValue("value is too long and splitted to " + split.length + " parts");
                        continue;
                    }
                    variables.put(param.getName(), param.getValue().toString());
                }
            }
            try {
                ConcurrentBuildConfig concurrentBuildConfig = ((AdministrationConfigurationAccessor)ComponentLocator.getComponent(AdministrationConfigurationAccessor.class)).getAdministrationConfiguration().getConcurrentBuildConfig();
                log.info(String.format("concurrentBuildConfig: isEnabled=%s, NumberConcurrentBuilds=%d", concurrentBuildConfig.isEnabled(), concurrentBuildConfig.getNumberConcurrentBuilds()));
                long queueCount = StreamSupport.stream(this.buildQueueManager.getQueuedExecutables().spliterator(), false).count();
                long inProcessCount = (long)(this.planExecMan.isBusy() ? 1 : 0) + queueCount;
                long capacityCount = concurrentBuildConfig.isEnabled() ? (long)concurrentBuildConfig.getNumberConcurrentBuilds() : 1L;
                log.info(String.format("in process count=%d, capacity count=%d, execution plan is busy=%s", inProcessCount, capacityCount, this.planExecMan.isBusy()));
                if (inProcessCount >= capacityCount) {
                    log.warn("POSSIBLY RUN WILL FAIL because of queue limit. Check Concurrent builds configuration");
                }
            }
            catch (Exception e) {
                log.warn("Fail in logging queue information : " + e.getMessage());
            }
            ExecutionRequestResult result = this.planExecMan.startManualExecution((ImmutableChain)chain, (User)user, params, variables);
            if (result.getErrors().getTotalErrors() > 0) {
                throw new ConfigurationException(result.getErrors().getErrorMessages().toString(), 504);
            }
            return null;
        };
        this.executeImpersonatedCall(impersonated, "runPipeline");
    }

    private boolean isUserHasPermission(Permission permissionType, BambooUser user, ImmutableChain chain) {
        Collection permissionForPlan = ((BambooPermissionManager)ComponentLocator.getComponent(BambooPermissionManager.class)).getPermissionsForPlan(chain.getPlanKey());
        for (Permission permission : permissionForPlan) {
            if (!permission.equals(permissionType)) continue;
            return true;
        }
        return false;
    }

    private String getRunAsUser() {
        return this.getConnection().getBambooUser();
    }

    private OctaneConnection getConnection() {
        return OctaneConnectionManager.getInstance().getConnectionById(this.getInstanceId());
    }

    @Override
    public InputStream getTestsResult(String jobId, String buildId) {
        FileInputStream output = null;
        PlanResultKey planResultKey = PlanKeys.getPlanResultKey((String)buildId);
        File mqmResultFile = MqmResultsHelper.getMqmResultFilePath(planResultKey).toFile();
        log.info(String.format("getTestsResult of %s from  %s, file exist=%s", planResultKey.toString(), mqmResultFile.getAbsolutePath(), mqmResultFile.exists()));
        try {
            output = mqmResultFile.exists() && mqmResultFile.length() > 0L ? new FileInputStream(mqmResultFile.getAbsolutePath()) : null;
        }
        catch (IOException e) {
            log.error("failed to get test results for  " + jobId + " #" + buildId + " from " + mqmResultFile.getAbsolutePath());
        }
        return output;
    }

    @Override
    public InputStream getSCMData(String jobId, String buildId) {
        FileInputStream output = null;
        PlanResultKey planResultKey = PlanKeys.getPlanResultKey((String)buildId);
        File scmDataFile = MqmResultsHelper.getScmDataFilePath(planResultKey).toFile();
        try {
            output = scmDataFile.exists() && scmDataFile.length() > 0L ? new FileInputStream(scmDataFile.getAbsolutePath()) : null;
        }
        catch (IOException e) {
            log.error("failed to get scm data for  " + jobId + " #" + buildId + " from " + scmDataFile.getAbsolutePath());
        }
        return output;
    }

    @Override
    public OctaneResponse checkRepositoryConnectivity(TestConnectivityInfo testConnectivityInfo) {
        Callable<OctaneResponse> action = () -> this.getUftManager().checkRepositoryConnectivity(testConnectivityInfo);
        return this.executeImpersonatedCall(action, "checkRepositoryConnectivity");
    }

    @Override
    public OctaneResponse upsertCredentials(CredentialsInfo credentialsInfo) {
        Callable<OctaneResponse> action = () -> this.getUftManager().upsertCredentials(credentialsInfo);
        return this.executeImpersonatedCall(action, "upsertCredentials");
    }

    @Override
    public List<CredentialsInfo> getCredentials() {
        Callable<List> action = () -> this.getUftManager().getCredentials();
        return this.executeImpersonatedCall(action, "getCredentials");
    }

    @Override
    public void runTestDiscovery(DiscoveryInfo discoveryInfo) {
        Callable<Void> action = () -> {
            this.getUftManager().runTestDiscovery(discoveryInfo, this.getRunAsUser());
            return null;
        };
        this.executeImpersonatedCall(action, "runTestDiscovery");
    }

    @Override
    public PipelineNode createExecutor(DiscoveryInfo discoveryInfo) {
        Callable<PipelineNode> action = () -> {
            PipelineNode node = this.getUftManager().createExecutor(discoveryInfo, this.getRunAsUser());
            return node;
        };
        return this.executeImpersonatedCall(action, "createExecutor");
    }

    @Override
    public void deleteExecutor(String id) {
        Callable<Void> action = () -> {
            this.getUftManager().deleteExecutor(id);
            return null;
        };
        this.executeImpersonatedCall(action, "deleteExecutor");
    }

    private UftManager getUftManager() {
        return UftManager.getInstance();
    }

    private <V> V executeImpersonatedCall(Callable<V> callable, String actionName) {
        log.info("Impersonated call : " + actionName);
        BambooUser ud = this.bambooUserManager.loadUserByUsername(this.getRunAsUser());
        if (ud == null) {
            throw new PermissionException(401);
        }
        Callable impersonated = this.impService.runAsUser(this.getRunAsUser(), callable);
        try {
            return impersonated.call();
        }
        catch (PermissionException e) {
            log.warn("PermissionException to executeImpersonatedCall " + actionName + " : " + e.getMessage());
            throw e;
        }
        catch (Throwable e) {
            log.warn("Failed to executeImpersonatedCall " + actionName + " : " + e.getMessage(), e);
            RuntimeException runtimeException = e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
            throw runtimeException;
        }
    }

    public static String getBambooServerBaseUrl() {
        String baseUrl = ((AdministrationConfigurationAccessor)ComponentLocator.getComponent(AdministrationConfigurationAccessor.class)).getAdministrationConfiguration().getBaseUrl();
        return baseUrl;
    }

    @Override
    public String getParentJobName(String jobId) {
        try {
            PlanKey planKey = PlanKeys.getPlanKey((String)jobId);
            Plan plan = this.planMan.getPlanByKey(planKey);
            if (plan != null && plan.getMaster() != null) {
                return plan.getMaster().getKey();
            }
        }
        catch (IllegalArgumentException e) {
            log.warn("Cannot get plan from job ci ID will take using regex");
        }
        Matcher m = this.parentExtractorRegex.matcher(jobId);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }
}

