/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.plugins.bamboo.listener;

import com.atlassian.bamboo.chains.StageExecution;
import com.atlassian.bamboo.chains.plugins.PreJobAction;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.causes.CIEventCause;
import com.hp.octane.integrations.dto.events.CIEvent;
import com.hp.octane.integrations.dto.events.CIEventType;
import com.hp.octane.integrations.dto.events.PhaseType;
import com.hp.octane.integrations.dto.scm.SCMData;
import com.hp.octane.plugins.bamboo.listener.BaseListener;
import com.hp.octane.plugins.bamboo.listener.MultibranchHelper;
import com.hp.octane.plugins.bamboo.listener.ParametersHelper;
import com.hp.octane.plugins.bamboo.octane.DefaultOctaneConverter;
import com.hp.octane.plugins.bamboo.octane.MqmResultsHelper;
import com.hp.octane.plugins.bamboo.octane.SDKBasedLoggerProvider;
import com.hp.octane.plugins.bamboo.rest.OctaneConnectionManager;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class OctanePreJobAction
extends BaseListener
implements PreJobAction {
    private static final Logger LOG = SDKBasedLoggerProvider.getLogger(OctanePreJobAction.class);

    public void execute(StageExecution paramStageExecution, BuildContext buildContext) {
        if (!OctaneConnectionManager.hasActiveClients()) {
            return;
        }
        PlanResultKey resultKey = buildContext.getPlanResultKey();
        CIEventCause parentReason = CONVERTER.getCause(buildContext.getTriggerReason());
        String parentJobId = buildContext.getParentBuildContext().getPlanResultKey().getPlanKey().getKey();
        CIEventCause cause = CONVERTER.getUpstreamCause(buildContext.getParentBuildIdentifier().getPlanResultKey().getKey(), parentJobId, parentReason);
        CIEvent event = CONVERTER.getEventWithDetails(resultKey.getPlanKey().getKey(), resultKey.getKey(), buildContext.getShortName(), CIEventType.STARTED, System.currentTimeMillis(), paramStageExecution.getChainExecution().getAverageDuration(), Collections.singletonList(cause), String.valueOf(resultKey.getBuildNumber()), PhaseType.INTERNAL);
        MultibranchHelper.enrichMultiBranchEventForJob(buildContext, event);
        ParametersHelper.addParametersToEvent(event, buildContext);
        OctaneSDK.getClients().forEach(client -> client.getEventsService().publishEvent(event));
        SCMData scmData = CONVERTER.getScmData(buildContext);
        if (scmData != null) {
            List<SCMData> scmDataList = Collections.singletonList(scmData);
            InputStream is = DefaultOctaneConverter.getDTOFactory().dtoCollectionToJsonStream(scmDataList);
            Path targetFilePath = MqmResultsHelper.getScmDataFilePath(resultKey);
            LOG.info("Generating scm data file for " + resultKey.getKey() + " (" + scmData.getCommits().size() + " commits): " + targetFilePath);
            MqmResultsHelper.saveStreamToFile(is, resultKey, targetFilePath);
            OctaneSDK.getClients().forEach(client -> client.getSCMDataService().enqueueSCMData(resultKey.getPlanKey().getKey(), resultKey.getKey(), scmData, parentJobId));
        }
    }
}

