/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.utils;

import com.hp.octane.integrations.utils.SdkStringUtils;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.apache.commons.codec.Charsets;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class OctaneUrlParser {
    private final String location;
    private final String sharedSpace;
    private static final String PARAM_SHARED_SPACE = "p";
    private static final String UI_SPACE = "/ui";
    private static final String UNEXPECTED_SHARED_SPACE_EXCEPTION = "Unexpected shared space parameter value";
    private static final String APPLICATION_CONTEXT_NOT_FOUND_EXCEPTION = "Application context (/ui) not found in URL";
    public static final String MISSING_SHARED_SPACE_EXCEPTION = "Missing shared space parameter";
    public static final String URL_INVALID_EXCEPTION = "Invalid URL";

    public OctaneUrlParser(String location, String sharedSpace) {
        this.location = location;
        this.sharedSpace = sharedSpace;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSharedSpace() {
        return this.sharedSpace;
    }

    public static OctaneUrlParser parse(String uiLocation) throws IllegalArgumentException {
        try {
            String myUiLocation = uiLocation;
            int anchorPart = uiLocation.indexOf("#");
            if (anchorPart > 0) {
                myUiLocation = uiLocation.substring(0, anchorPart);
            }
            URL url = new URL(myUiLocation);
            int contextPos = myUiLocation.indexOf(UI_SPACE);
            if (contextPos < 0) {
                throw new IllegalArgumentException(APPLICATION_CONTEXT_NOT_FOUND_EXCEPTION);
            }
            String location = myUiLocation.substring(0, contextPos);
            List<NameValuePair> params = URLEncodedUtils.parse(url.toURI(), Charsets.UTF_8);
            for (NameValuePair param : params) {
                if (!param.getName().equals(PARAM_SHARED_SPACE)) continue;
                String[] sharedSpaceAndWorkspace = param.getValue().split("/");
                if (sharedSpaceAndWorkspace.length < 1 || SdkStringUtils.isEmpty(sharedSpaceAndWorkspace[0])) {
                    throw new IllegalArgumentException(UNEXPECTED_SHARED_SPACE_EXCEPTION);
                }
                return new OctaneUrlParser(location, sharedSpaceAndWorkspace[0]);
            }
            throw new IllegalArgumentException(MISSING_SHARED_SPACE_EXCEPTION);
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException(URL_INVALID_EXCEPTION);
        }
    }
}

