/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.uft.ufttestresults;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.hp.octane.integrations.uft.ufttestresults.schema.ReportNode;
import com.hp.octane.integrations.uft.ufttestresults.schema.ReportResults;
import com.hp.octane.integrations.uft.ufttestresults.schema.UftResultIterationData;
import com.hp.octane.integrations.uft.ufttestresults.schema.UftResultStepData;
import com.hp.octane.integrations.uft.ufttestresults.schema.UftResultStepParameter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class UftTestResultsUtils {
    private static Set<String> notFinalNodeType = new HashSet<String>(Arrays.asList("Iteration", "Action", "Context"));

    public static List<UftResultStepData> getErrorData(File file) {
        ReportResults result = UftTestResultsUtils.fromXml(file, ReportResults.class);
        ArrayList<UftResultStepData> errors = new ArrayList<UftResultStepData>();
        ArrayList<String> parents = new ArrayList<String>();
        UftTestResultsUtils.getErrorDataInternal(result.getReportNode(), parents, errors);
        return errors;
    }

    public static String getAggregatedErrorMessage(List<UftResultStepData> errors) {
        String err = errors.stream().map(e -> e.getMessage().trim() + (e.getResult().equalsIgnoreCase("Warning") ? " (Warning)" : "")).map(msg -> msg + (msg.endsWith(".") ? "" : ". ")).distinct().collect(Collectors.joining("\n"));
        return err;
    }

    public static List<UftResultIterationData> getMBTData(File file) {
        ReportResults result = UftTestResultsUtils.fromXml(file, ReportResults.class);
        ArrayList<ReportNode> iterationReportNodes = new ArrayList<ReportNode>();
        UftTestResultsUtils.getMBTIterationsInternal(result.getReportNode(), new ArrayList<String>(), iterationReportNodes, "Iteration", 2);
        ArrayList<UftResultIterationData> iterations = new ArrayList<UftResultIterationData>();
        iterationReportNodes.forEach(reportNode -> {
            ArrayList<UftResultStepData> steps = new ArrayList<UftResultStepData>();
            UftTestResultsUtils.getMBTDataInternal(reportNode, new ArrayList<String>(), steps, "Action", 3);
            iterations.add(new UftResultIterationData(steps, reportNode.getData().getDuration()));
        });
        return iterations;
    }

    private static void getErrorDataInternal(ReportNode node, List<String> parents, List<UftResultStepData> errors) {
        boolean failed;
        parents.add(node.getData().getName());
        boolean hasDescription = UftTestResultsUtils.isNotEmpty(node.getData().getDescription());
        boolean bl = failed = "Failed".equalsIgnoreCase(node.getData().getResult()) || "Warning".equalsIgnoreCase(node.getData().getResult());
        if (failed) {
            if (!notFinalNodeType.contains(node.getType()) && hasDescription) {
                String error = UftTestResultsUtils.isNotEmpty(node.getData().getErrorText()) ? node.getData().getErrorText() : node.getData().getDescription();
                error = error.replace("Verify that this object's properties match an object currently displayed in your application.", "").replace("\n", "").replace("&nbsp;", " ").trim();
                if (!parents.isEmpty() && error.startsWith(parents.get(parents.size() - 1))) {
                    parents.remove(parents.size() - 1);
                }
                errors.add(new UftResultStepData(parents, node.getType(), node.getData().getResult(), error, node.getData().getDuration()));
            }
            if (node.getNodes() != null) {
                node.getNodes().forEach(n -> UftTestResultsUtils.getErrorDataInternal(n, new ArrayList<String>(parents), errors));
            }
        }
    }

    private static void getMBTIterationsInternal(ReportNode node, List<String> parents, List<ReportNode> results, String nodeType, int targetLevel) {
        parents.add(node.getData().getName());
        if (parents.size() == targetLevel && nodeType.equals(node.getType())) {
            results.add(node);
        }
        if (node.getNodes() != null && parents.size() < targetLevel) {
            node.getNodes().forEach(n -> UftTestResultsUtils.getMBTIterationsInternal(n, new ArrayList<String>(parents), results, nodeType, targetLevel));
        }
    }

    private static void getMBTDataInternal(ReportNode node, List<String> parents, List<UftResultStepData> results, String nodeType, int targetLevel) {
        boolean failed;
        parents.add(node.getData().getName());
        boolean bl = failed = "Failed".equalsIgnoreCase(node.getData().getResult()) || "Warning".equalsIgnoreCase(node.getData().getResult());
        if (parents.size() == targetLevel && nodeType.equals(node.getType())) {
            String errorMessage = "";
            if (failed) {
                ArrayList<UftResultStepData> errors = new ArrayList<UftResultStepData>();
                UftTestResultsUtils.getErrorDataInternal(node, new ArrayList<String>(parents), errors);
                errorMessage = UftTestResultsUtils.getAggregatedErrorMessage(errors);
            }
            List<UftResultStepParameter> inputParameters = null;
            if (node.getData().getInputParameters() != null) {
                inputParameters = node.getData().getInputParameters().stream().map(parameter -> new UftResultStepParameter(parameter.getName(), parameter.getValue(), parameter.getType())).collect(Collectors.toList());
            }
            List<UftResultStepParameter> outputParameters = null;
            if (node.getData().getOutputParameters() != null) {
                outputParameters = node.getData().getOutputParameters().stream().map(parameter -> new UftResultStepParameter(parameter.getName(), parameter.getValue(), parameter.getType())).collect(Collectors.toList());
            }
            results.add(new UftResultStepData(parents, node.getType(), node.getData().getResult(), errorMessage, node.getData().getDuration(), inputParameters, outputParameters));
        }
        if (node.getNodes() != null && parents.size() < targetLevel) {
            node.getNodes().forEach(n -> UftTestResultsUtils.getMBTDataInternal(n, new ArrayList<String>(parents), results, nodeType, targetLevel));
        }
    }

    private static boolean isNotEmpty(String str) {
        return str != null && !str.isEmpty();
    }

    public static <T> T fromXml(File xml, Class<T> clazz) {
        try {
            XmlMapper xmlMapper = new XmlMapper();
            xmlMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            T obj = xmlMapper.readValue(xml, clazz);
            return obj;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while deserializing a XML file to Object of type " + clazz, e);
        }
    }
}

