/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.tasking;

import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.connectivity.HttpMethod;
import com.hp.octane.integrations.dto.connectivity.OctaneResponse;
import com.hp.octane.integrations.dto.connectivity.OctaneResultAbridged;
import com.hp.octane.integrations.dto.connectivity.OctaneTaskAbridged;
import com.hp.octane.integrations.dto.connectivity.TaskProcessingErrorBody;
import com.hp.octane.integrations.dto.executor.CredentialsInfo;
import com.hp.octane.integrations.dto.executor.DiscoveryInfo;
import com.hp.octane.integrations.dto.executor.TestConnectivityInfo;
import com.hp.octane.integrations.dto.general.CIBranchesList;
import com.hp.octane.integrations.dto.general.CIBuildStatusInfo;
import com.hp.octane.integrations.dto.general.CIJobsList;
import com.hp.octane.integrations.dto.general.CIPluginSDKInfo;
import com.hp.octane.integrations.dto.general.CIProviderSummaryInfo;
import com.hp.octane.integrations.dto.general.CIServerInfo;
import com.hp.octane.integrations.dto.parameters.CIParameter;
import com.hp.octane.integrations.dto.parameters.CIParameters;
import com.hp.octane.integrations.dto.pipelines.PipelineNode;
import com.hp.octane.integrations.exceptions.ErrorCodeBasedException;
import com.hp.octane.integrations.exceptions.SPIMethodNotImplementedException;
import com.hp.octane.integrations.services.configuration.ConfigurationService;
import com.hp.octane.integrations.services.configurationparameters.factory.ConfigurationParameterFactory;
import com.hp.octane.integrations.services.tasking.TasksProcessor;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.apache.http.entity.ContentType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class TasksProcessorImpl
implements TasksProcessor {
    private static final Logger logger = LogManager.getLogger(TasksProcessorImpl.class);
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();
    private static final String NGA_API = "nga/api/v1";
    private static final String STATUS = "status";
    private static final String SUSPEND_STATUS = "suspend_status";
    private static final String JOBS = "jobs";
    private static final String RUN = "run";
    private static final String STOP = "stop";
    private static final String BUILD_STATUS = "build_status";
    private static final String BRANCHES = "branches";
    private static final String BUILDS = "builds";
    private static final String EXECUTOR = "executor";
    private static final String INIT = "init";
    private static final String UPDATE = "update";
    private static final String TEST_CONN = "test_conn";
    private static final String CREDENTIALS_UPSERT = "credentials_upsert";
    private static final String CREDENTIALS = "credentials";
    private static final String SYNC_NOW = "sync_now";
    private ExecutorService jobListCacheExecutor = Executors.newSingleThreadExecutor();
    private CacheItem jobListCacheItem;
    private final OctaneSDK.SDKServicesConfigurer configurer;
    private final ConfigurationService configurationService;

    TasksProcessorImpl(OctaneSDK.SDKServicesConfigurer configurer, ConfigurationService configurationService) {
        if (configurer == null) {
            throw new IllegalArgumentException("invalid configurer");
        }
        if (configurationService == null) {
            throw new IllegalArgumentException("configurationService shouldnot be null");
        }
        this.configurationService = configurationService;
        this.configurer = configurer;
    }

    @Override
    public OctaneResultAbridged execute(OctaneTaskAbridged task) {
        if (task == null) {
            throw new IllegalArgumentException("task MUST NOT be null");
        }
        if (task.getUrl() == null || task.getUrl().isEmpty()) {
            throw new IllegalArgumentException("task 'URL' MUST NOT be null nor empty");
        }
        if (!task.getUrl().contains(NGA_API)) {
            throw new IllegalArgumentException("task 'URL' expected to contain 'nga/api/v1'; wrong handler call?");
        }
        long startTime = System.currentTimeMillis();
        logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "processing task '" + task.getId() + "': " + (Object)((Object)task.getMethod()) + " " + task.getUrl());
        OctaneResultAbridged result = DTOFactory.getInstance().newDTO(OctaneResultAbridged.class);
        result.setId(task.getId());
        result.setStatus(200);
        result.setHeaders(new HashMap<String, String>());
        result.setServiceId(this.configurer.octaneConfiguration.getInstanceId());
        String[] path = this.pathTokenizer(task.getUrl());
        try {
            if (task.getHeaders() != null && !task.getHeaders().isEmpty()) {
                logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "headers are not empty! passing to plugin");
                this.configurer.pluginServices.setCorrelationId(task.getHeaders());
            }
            if (path.length == 1 && STATUS.equals(path[0])) {
                this.executeStatusRequest(result);
            } else if (path.length == 1 && SUSPEND_STATUS.equals(path[0])) {
                this.suspendCiEvents(result, task.getBody());
            } else if (path[0].startsWith(JOBS)) {
                if (path.length == 1) {
                    Map<String, String> queryParams = this.getQueryParamsMap(path[0]);
                    boolean includingParameters = !"false".equals(queryParams.get("parameters"));
                    Long workspaceId = queryParams.containsKey("workspaceId") ? Long.valueOf(Long.parseLong(queryParams.get("workspaceId"))) : null;
                    this.executeJobsListRequest(result, includingParameters, workspaceId);
                } else if (path.length == 2) {
                    this.executePipelineRequest(result, path[1]);
                } else if (path.length == 3 && RUN.equals(path[2])) {
                    this.executePipelineRunExecuteRequest(result, path[1], task.getBody());
                } else if (path.length == 3 && STOP.equals(path[2])) {
                    this.executePipelineRunStopRequest(result, path[1], task.getBody());
                } else {
                    result.setStatus(404);
                }
            } else if (BUILD_STATUS.equalsIgnoreCase(path[0])) {
                this.executeGetBulkBuildStatusRequest(result, task.getBody());
            } else if (path.length == 2 && path[0].startsWith(BRANCHES)) {
                Map<String, String> queryParams = this.getQueryParamsMap(path[1]);
                String jobCiId = path[1].substring(0, path[1].indexOf("?"));
                String filterBranchName = queryParams.getOrDefault("filterBranchName", null);
                this.executeBranchesListRequest(result, jobCiId, filterBranchName);
            } else if (EXECUTOR.equalsIgnoreCase(path[0])) {
                if (HttpMethod.POST.equals((Object)task.getMethod()) && path.length == 2) {
                    if (INIT.equalsIgnoreCase(path[1])) {
                        DiscoveryInfo discoveryInfo = dtoFactory.dtoFromJson(task.getBody(), DiscoveryInfo.class);
                        discoveryInfo.setConfigurationId(this.configurer.octaneConfiguration.getInstanceId());
                        this.configurer.pluginServices.runTestDiscovery(discoveryInfo);
                        PipelineNode node = this.configurer.pluginServices.createExecutor(discoveryInfo);
                        if (node != null) {
                            result.setBody(dtoFactory.dtoToJson(node));
                            result.getHeaders().put("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
                        }
                        result.setStatus(200);
                    } else if (UPDATE.equalsIgnoreCase(path[1])) {
                        DiscoveryInfo discoveryInfo = dtoFactory.dtoFromJson(task.getBody(), DiscoveryInfo.class);
                        discoveryInfo.setConfigurationId(this.configurer.octaneConfiguration.getInstanceId());
                        this.configurer.pluginServices.updateExecutor(discoveryInfo);
                        result.setStatus(200);
                    } else if (TEST_CONN.equalsIgnoreCase(path[1])) {
                        TestConnectivityInfo testConnectivityInfo = dtoFactory.dtoFromJson(task.getBody(), TestConnectivityInfo.class);
                        OctaneResponse connTestResult = this.configurer.pluginServices.checkRepositoryConnectivity(testConnectivityInfo);
                        result.setStatus(connTestResult.getStatus());
                        result.setBody(connTestResult.getBody());
                    } else if (CREDENTIALS_UPSERT.equalsIgnoreCase(path[1])) {
                        CredentialsInfo credentialsInfo = dtoFactory.dtoFromJson(task.getBody(), CredentialsInfo.class);
                        this.executeUpsertCredentials(result, credentialsInfo);
                    } else if (SYNC_NOW.equalsIgnoreCase(path[1])) {
                        DiscoveryInfo discoveryInfo = dtoFactory.dtoFromJson(task.getBody(), DiscoveryInfo.class);
                        discoveryInfo.setConfigurationId(this.configurer.octaneConfiguration.getInstanceId());
                        this.configurer.pluginServices.syncNow(discoveryInfo);
                    } else {
                        result.setStatus(404);
                    }
                } else if (HttpMethod.DELETE.equals((Object)task.getMethod()) && path.length == 2) {
                    String id = path[1];
                    this.configurer.pluginServices.deleteExecutor(id);
                } else if (HttpMethod.GET.equals((Object)task.getMethod()) && path.length == 2 && CREDENTIALS.equalsIgnoreCase(path[1])) {
                    List<CredentialsInfo> credentials = this.configurer.pluginServices.getCredentials();
                    String json = dtoFactory.dtoCollectionToJson(credentials);
                    result.setBody(json);
                }
            } else {
                result.setStatus(404);
            }
        }
        catch (ErrorCodeBasedException pe) {
            logger.warn(this.configurer.octaneConfiguration.getLocationForLog() + "task execution failed; error: " + pe.getErrorCode() + ", message : " + pe.getMessage());
            result.setStatus(pe.getErrorCode());
            result.setBody(String.valueOf(pe.getErrorCode()));
        }
        catch (SPIMethodNotImplementedException spimnie) {
            result.setStatus(501);
        }
        catch (Throwable e) {
            logger.error(this.configurer.octaneConfiguration.getLocationForLog() + "task execution failed", e);
            result.setStatus(500);
            TaskProcessingErrorBody errorBody = dtoFactory.newDTO(TaskProcessingErrorBody.class).setErrorMessage("Task " + task.getUrl() + " is failed. Server error message: " + e.getMessage());
            result.setBody(dtoFactory.dtoToJson(errorBody));
            result.getHeaders().put("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
            logger.warn(this.configurer.octaneConfiguration.getLocationForLog() + "OctaneResultAbridged.execute failed : " + e.getMessage());
        }
        logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "result for task '" + task.getId() + "' available with status " + result.getStatus() + ", processing time is " + (System.currentTimeMillis() - startTime) / 1000L + " seconds");
        return result;
    }

    private void executeBranchesListRequest(OctaneResultAbridged result, String jobCiId, String filterBranchName) {
        result.getHeaders().put("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        CIBranchesList content = this.configurer.pluginServices.getBranchesList(jobCiId, filterBranchName);
        result.setBody(dtoFactory.dtoToJson(content));
        logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "executeBranchesListRequest: found " + content.getBranches().size() + " branches, body size is " + result.getBody().length());
    }

    @Override
    public Future<Boolean> resetJobListCache() {
        if (ConfigurationParameterFactory.jobListCacheAllowed(this.configurer.octaneConfiguration) && !this.configurer.octaneConfiguration.isDisabled()) {
            return this.jobListCacheExecutor.submit(() -> {
                logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "resetJobListCache submitted");
                try {
                    long startTime = System.currentTimeMillis();
                    CIJobsList content = this.configurer.pluginServices.getJobsList(true, null);
                    if (content != null) {
                        this.jobListCacheItem = CacheItem.create(content);
                        logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "resetJobListCache: cache is reset, found " + content.getJobs().length + " jobs, processing time is " + (System.currentTimeMillis() - startTime) / 1000L + " seconds");
                        return true;
                    }
                    logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "resetJobListCache: failed to update cache. Content is empty.");
                    return false;
                }
                catch (Exception e) {
                    logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "Failed to resetJobListCache : " + e.getMessage());
                    return false;
                }
            });
        }
        if (this.jobListCacheItem != null) {
            logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "resetJobListCache : cache is cleared");
        }
        this.jobListCacheItem = null;
        return CompletableFuture.completedFuture(false);
    }

    private String[] pathTokenizer(String url) {
        HashMap<Integer, String> params = new HashMap<Integer, String>();
        String[] path = Pattern.compile("^.*nga/api/v1/?").matcher(url).replaceFirst("").split("/");
        params.put(0, path[0]);
        for (int i = 1; i < path.length; ++i) {
            if ((path[i].equals(BUILDS) || path[i].equals(RUN) || path[i].equals(STOP)) && i == path.length - 1) {
                params.put(2, path[i]);
                continue;
            }
            if (path[i].equals(BUILDS) && i == path.length - 2) {
                params.put(2, path[i]);
                params.put(3, path[i + 1]);
                break;
            }
            if (params.get(1) == null) {
                params.put(1, path[i]);
                continue;
            }
            params.put(1, (String)params.get(1) + "/" + path[i]);
        }
        ArrayList<String> listAsArray = new ArrayList<String>();
        for (int i = 0; i < params.size(); ++i) {
            listAsArray.add(i, (String)params.get(i));
        }
        return listAsArray.toArray(new String[0]);
    }

    private void executeStatusRequest(OctaneResultAbridged result) {
        CIPluginSDKInfo sdkInfo = dtoFactory.newDTO(CIPluginSDKInfo.class).setApiVersion(OctaneSDK.API_VERSION).setSdkVersion(OctaneSDK.SDK_VERSION);
        CIServerInfo serverInfo = this.configurer.pluginServices.getServerInfo();
        serverInfo.setInstanceId(this.configurer.octaneConfiguration.getInstanceId());
        CIProviderSummaryInfo status = dtoFactory.newDTO(CIProviderSummaryInfo.class).setServer(serverInfo).setPlugin(this.configurer.pluginServices.getPluginInfo()).setSdk(sdkInfo);
        result.setBody(dtoFactory.dtoToJson(status));
        result.getHeaders().put("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
    }

    private void executeJobsListRequest(OctaneResultAbridged result, boolean includingParameters, Long workspaceId) {
        CacheItem myJobListCacheItem;
        result.getHeaders().put("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        boolean cacheAllowed = ConfigurationParameterFactory.jobListCacheAllowed(this.configurer.octaneConfiguration);
        boolean cacheIsUsed = false;
        if (cacheAllowed && (myJobListCacheItem = this.jobListCacheItem) != null) {
            long currentTime = System.currentTimeMillis();
            long hours = (currentTime - myJobListCacheItem.time) / 300000L;
            if (hours >= 1L) {
                try {
                    if (this.resetJobListCache().get(10L, TimeUnit.SECONDS).booleanValue()) {
                        myJobListCacheItem = this.jobListCacheItem;
                    }
                }
                catch (InterruptedException | ExecutionException | TimeoutException exception) {
                    // empty catch block
                }
            }
            CIJobsList content = myJobListCacheItem.value;
            result.setBody(dtoFactory.dtoToJson(content));
            logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "executeJobsListRequest: cache is used, found " + content.getJobs().length + " jobs, body size is " + result.getBody().length());
            cacheIsUsed = true;
        }
        if (!cacheIsUsed) {
            Long myWorkspaceId = cacheAllowed ? null : workspaceId;
            Boolean myIncludingParameters = cacheAllowed ? true : includingParameters;
            logger.info("Starting to get jobs without cache");
            long startGetJobList = System.currentTimeMillis();
            CIJobsList content = this.configurer.pluginServices.getJobsList(myIncludingParameters, myWorkspaceId);
            logger.info("Finish get job content without cache took {} ms", (Object)(System.currentTimeMillis() - startGetJobList));
            if (content != null) {
                result.setBody(dtoFactory.dtoToJson(content));
                if (cacheAllowed) {
                    this.jobListCacheItem = CacheItem.create(content);
                }
                logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "executeJobsListRequest: found " + content.getJobs().length + " jobs, body size is " + result.getBody().length());
            } else {
                TaskProcessingErrorBody errorMessage = dtoFactory.newDTO(TaskProcessingErrorBody.class).setErrorMessage("'getJobsList' API is not implemented OR returns NULL, which contradicts API requirement (MAY be empty list)");
                result.setBody(dtoFactory.dtoToJson(errorMessage));
                result.setStatus(501);
            }
        }
    }

    private void executePipelineRequest(OctaneResultAbridged result, String jobId) {
        PipelineNode content = this.configurer.pluginServices.getPipeline(jobId);
        if (content != null) {
            result.setBody(dtoFactory.dtoToJson(content));
            result.getHeaders().put("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
            this.configurationService.addToOctaneRootsCache(jobId);
        } else {
            result.setStatus(404);
        }
    }

    private void executePipelineRunExecuteRequest(OctaneResultAbridged result, String jobId, String originalBody) {
        CIParameters ciParameters;
        logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "RunExecute job " + jobId);
        this.configurationService.addToOctaneRootsCache(jobId);
        CIParameters cIParameters = ciParameters = originalBody != null ? DTOFactory.getInstance().dtoFromJson(originalBody, CIParameters.class) : null;
        if (ciParameters == null) {
            ciParameters = dtoFactory.newDTO(CIParameters.class);
            ciParameters.setParameters(new ArrayList<CIParameter>());
        }
        CIParameter ciParameter = dtoFactory.newDTO(CIParameter.class);
        ciParameter.setName("octaneConfigId").setValue(this.configurer.octaneConfiguration.getInstanceId());
        ciParameters.getParameters().add(ciParameter);
        CIParameter octaneUrlParameter = dtoFactory.newDTO(CIParameter.class);
        octaneUrlParameter.setName("octaneUrl").setValue(this.configurer.octaneConfiguration.getUrl());
        ciParameters.getParameters().add(octaneUrlParameter);
        this.configurer.pluginServices.runPipeline(jobId, ciParameters);
        result.setStatus(201);
    }

    private void executePipelineRunStopRequest(OctaneResultAbridged result, String jobId, String originalBody) {
        logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "RunStop job " + jobId);
        CIParameters ciParameters = originalBody != null ? DTOFactory.getInstance().dtoFromJson(originalBody, CIParameters.class) : null;
        this.configurer.pluginServices.stopPipelineRun(jobId, ciParameters);
        result.setStatus(200);
    }

    private void executeGetBulkBuildStatusRequest(OctaneResultAbridged result, String originalBody) {
        logger.info(this.configurer.octaneConfiguration.getLocationForLog() + "BulkBuildStatus ");
        CIBuildStatusInfo[] statuses = originalBody != null ? (CIBuildStatusInfo[])DTOFactory.getInstance().dtoCollectionFromJson(originalBody, CIBuildStatusInfo[].class) : new CIBuildStatusInfo[]{};
        ArrayList<CIBuildStatusInfo> output = new ArrayList<CIBuildStatusInfo>();
        for (CIBuildStatusInfo statusInfo : statuses) {
            try {
                CIBuildStatusInfo myStatus = this.configurer.pluginServices.getJobBuildStatus(statusInfo.getJobCiId(), statusInfo.getParamName(), statusInfo.getParamValue());
                output.add(myStatus);
            }
            catch (SPIMethodNotImplementedException notImplemented) {
                result.setStatus(501);
                return;
            }
            catch (ErrorCodeBasedException ex) {
                statusInfo.setExceptionMessage(ex.getMessage());
                statusInfo.setExceptionCode(ex.getErrorCode());
                output.add(statusInfo);
            }
            catch (Exception e) {
                statusInfo.setExceptionMessage(e.getMessage());
                statusInfo.setExceptionCode(500);
                output.add(statusInfo);
            }
        }
        result.setBody(dtoFactory.dtoCollectionToJson(output));
        result.setStatus(200);
    }

    private Map<String, String> getQueryParamsMap(String path) {
        String[] queryParamsParts;
        HashMap<String, String> queryParams = new HashMap<String, String>();
        String queryParamsStr = path.contains("?") ? path.substring(path.indexOf("?") + 1) : path;
        for (String p : queryParamsParts = queryParamsStr.split("&")) {
            String[] parts = p.split("=");
            if (parts.length != 2) continue;
            queryParams.put(parts[0], parts[1]);
        }
        return queryParams;
    }

    private void suspendCiEvents(OctaneResultAbridged result, String suspend) {
        boolean toSuspend = Boolean.parseBoolean(suspend);
        this.configurer.pluginServices.suspendCIEvents(toSuspend);
        result.setStatus(201);
    }

    private void executeUpsertCredentials(OctaneResultAbridged result, CredentialsInfo credentialsInfo) {
        OctaneResponse response = this.configurer.pluginServices.upsertCredentials(credentialsInfo);
        result.setBody(response.getBody());
        result.setStatus(response.getStatus());
    }

    @Override
    public void shutdown() {
        this.jobListCacheExecutor.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.jobListCacheExecutor.isShutdown();
    }

    @Override
    public Map<String, Object> getMetrics() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("jobListCacheAllowed", ConfigurationParameterFactory.jobListCacheAllowed(this.configurer.octaneConfiguration));
        if (this.jobListCacheItem != null) {
            map.put("jobListCache_jobCount", this.jobListCacheItem.value.getJobs().length);
            map.put("jobListCache_time", new Date(this.jobListCacheItem.time));
        }
        return map;
    }

    private static class CacheItem {
        long time;
        CIJobsList value;

        private CacheItem() {
        }

        public static CacheItem create(CIJobsList value) {
            CacheItem ci = new CacheItem();
            ci.value = value;
            ci.time = System.currentTimeMillis();
            return ci;
        }
    }
}

