/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.entities;

import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.connectivity.HttpMethod;
import com.hp.octane.integrations.dto.connectivity.OctaneRequest;
import com.hp.octane.integrations.dto.connectivity.OctaneResponse;
import com.hp.octane.integrations.dto.entities.Entity;
import com.hp.octane.integrations.dto.entities.EntityList;
import com.hp.octane.integrations.dto.entities.OctaneBulkExceptionData;
import com.hp.octane.integrations.dto.entities.OctaneRestExceptionData;
import com.hp.octane.integrations.dto.entities.ResponseEntityList;
import com.hp.octane.integrations.exceptions.OctaneBulkException;
import com.hp.octane.integrations.exceptions.OctaneRestException;
import com.hp.octane.integrations.services.entities.EntitiesService;
import com.hp.octane.integrations.services.entities.QueryHelper;
import com.hp.octane.integrations.services.rest.OctaneRestClient;
import com.hp.octane.integrations.services.rest.RestService;
import com.hp.octane.integrations.utils.SdkStringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections4.ListUtils;
import org.apache.http.entity.ContentType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class EntitiesServiceImpl
implements EntitiesService {
    private static final Logger logger = LogManager.getLogger(EntitiesServiceImpl.class);
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();
    private final OctaneSDK.SDKServicesConfigurer configurer;
    private final RestService restService;
    private static final String FILTERING_FRAGMENT = "query={query}";
    private static final String FIELDS_FRAGMENT = "fields={fields}";
    private static final String PAGING_FRAGMENT = "offset={offset}&limit={limit}";
    private static final String ORDER_BY_FRAGMENT = "order_by={order}";
    private static final String URI_PARAM_ENCODING = "UTF-8";
    private static final int MAX_GET_LIMIT = 1000;
    private static final int MAX_UPDATE_LIMIT = 200;

    EntitiesServiceImpl(OctaneSDK.SDKServicesConfigurer configurer, RestService restService) {
        if (configurer == null) {
            throw new IllegalArgumentException("invalid configurer");
        }
        if (restService == null) {
            throw new IllegalArgumentException("rest service MUST NOT be null");
        }
        this.configurer = configurer;
        this.restService = restService;
        logger.info(configurer.octaneConfiguration.getLocationForLog() + "initialized SUCCESSFULLY");
    }

    @Override
    public List<Entity> deleteEntitiesByIds(Long workspaceId, String entityCollectionName, Collection<?> entitiesIds) {
        if (entitiesIds == null || entitiesIds.isEmpty()) {
            return null;
        }
        String deleteCondition = QueryHelper.conditionIn("id", entitiesIds, true);
        return this.deleteEntities(workspaceId, entityCollectionName, Collections.singletonList(deleteCondition));
    }

    @Override
    public List<Entity> deleteEntities(Long workspaceId, String entityCollectionName, Collection<String> conditions) {
        OctaneRestClient octaneRestClient = this.restService.obtainOctaneRestClient();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("accept", ContentType.APPLICATION_JSON.getMimeType());
        headers.put("HPECLIENTTYPE", "HPE_CI_CLIENT");
        String url = this.buildEntityUrl(workspaceId, entityCollectionName, conditions, null, null, null, null);
        OctaneRequest request = dtoFactory.newDTO(OctaneRequest.class).setMethod(HttpMethod.DELETE).setUrl(url).setHeaders(headers);
        OctaneResponse response = this.executeRequest(octaneRestClient, request);
        ResponseEntityList responseEntityList = EntitiesServiceImpl.parseBody(200, response);
        return responseEntityList.getData();
    }

    @Override
    public List<Entity> updateEntities(Long workspaceId, String entityCollectionName, List<Entity> entities) {
        ArrayList<Entity> results = new ArrayList<Entity>();
        ListUtils.partition(entities, 200).forEach(list -> {
            EntityList entitiesForUpdate = dtoFactory.newDTO(EntityList.class);
            entitiesForUpdate.setData((List<Entity>)list);
            String jsonData = dtoFactory.dtoToJson(entitiesForUpdate);
            List<Entity> temp = this.updateEntities(workspaceId, entityCollectionName, jsonData);
            results.addAll(temp);
        });
        return results;
    }

    @Override
    public List<Entity> updateEntities(Long workspaceId, String entityCollectionName, String jsonData) {
        OctaneRestClient octaneRestClient = this.restService.obtainOctaneRestClient();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("accept", ContentType.APPLICATION_JSON.getMimeType());
        headers.put("content-type", ContentType.APPLICATION_JSON.getMimeType());
        headers.put("HPECLIENTTYPE", "HPE_CI_CLIENT");
        String url = this.buildEntityUrl(workspaceId, entityCollectionName, null, null, null, null, null);
        OctaneRequest request = dtoFactory.newDTO(OctaneRequest.class).setMethod(HttpMethod.PUT).setUrl(url).setBody(jsonData).setHeaders(headers);
        OctaneResponse response = this.executeRequest(octaneRestClient, request);
        ResponseEntityList responseEntityList = EntitiesServiceImpl.parseBody(200, response);
        return responseEntityList.getData();
    }

    @Override
    public List<Entity> postEntities(Long workspaceId, String entityCollectionName, List<Entity> entities) {
        return this.postEntities(workspaceId, entityCollectionName, entities, null);
    }

    @Override
    public List<Entity> postEntities(Long workspaceId, String entityCollectionName, List<Entity> entities, Collection<String> fields) {
        return this.postEntities(workspaceId, entityCollectionName, entities, fields, Collections.emptyMap());
    }

    @Override
    public List<Entity> postEntities(Long workspaceId, String entityCollectionName, List<Entity> entities, Collection<String> fields, Map<String, String> serviceArgument) {
        ArrayList<Entity> results = new ArrayList<Entity>();
        ListUtils.partition(entities, 200).forEach(list -> {
            EntityList entitiesForUpdate = dtoFactory.newDTO(EntityList.class);
            entitiesForUpdate.setData((List<Entity>)list);
            String jsonData = dtoFactory.dtoToJson(entitiesForUpdate);
            List<Entity> temp = this.postEntities(workspaceId, entityCollectionName, jsonData, fields, serviceArgument);
            results.addAll(temp);
        });
        return results;
    }

    @Override
    public List<Entity> postEntities(Long workspaceId, String entityCollectionName, String jsonData) {
        return this.postEntities(workspaceId, entityCollectionName, jsonData, null);
    }

    @Override
    public List<Entity> postEntities(Long workspaceId, String entityCollectionName, String jsonData, Collection<String> fields) {
        return this.postEntities(workspaceId, entityCollectionName, jsonData, null, (Map<String, String>)Collections.EMPTY_MAP);
    }

    @Override
    public List<Entity> postEntities(Long workspaceId, String entityCollectionName, String jsonData, Collection<String> fields, Map<String, String> serviceArgument) {
        OctaneRestClient octaneRestClient = this.restService.obtainOctaneRestClient();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("accept", ContentType.APPLICATION_JSON.getMimeType());
        headers.put("content-type", ContentType.APPLICATION_JSON.getMimeType());
        headers.put("HPECLIENTTYPE", "HPE_CI_CLIENT");
        String url = this.buildEntityUrl(workspaceId, entityCollectionName, null, fields, null, null, null, serviceArgument);
        OctaneRequest request = dtoFactory.newDTO(OctaneRequest.class).setMethod(HttpMethod.POST).setUrl(url).setBody(jsonData).setHeaders(headers);
        OctaneResponse response = this.executeRequest(octaneRestClient, request);
        ResponseEntityList responseEntityList = EntitiesServiceImpl.parseBody(201, response);
        return responseEntityList.getData();
    }

    @Override
    public List<Entity> getEntities(Long workspaceId, String entityCollectionName, Collection<String> conditions, Collection<String> fields) {
        return this.getEntities(workspaceId, entityCollectionName, conditions, null, fields);
    }

    @Override
    public List<Entity> getEntities(Long workspaceId, String entityCollectionName, Collection<String> conditions, String orderBy, Collection<String> fields) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        int limit = 1000;
        boolean fetchedAll = false;
        while (!fetchedAll) {
            String url = this.buildEntityUrl(workspaceId, entityCollectionName, conditions, fields, result.size(), limit, orderBy);
            ResponseEntityList responseEntityList = this.getPagedEntities(url);
            result.addAll(responseEntityList.getData());
            fetchedAll = responseEntityList.getData().isEmpty() || responseEntityList.getTotalCount() == 0 || responseEntityList.getTotalCount() == result.size();
        }
        return result;
    }

    @Override
    public List<Entity> getEntitiesByIds(Long workspaceId, String collectionName, Collection<?> ids) {
        return this.getEntitiesByIds(workspaceId, collectionName, ids, null);
    }

    @Override
    public List<Entity> getEntitiesByIds(Long workspaceId, String collectionName, Collection<?> ids, Collection<String> fields) {
        if (ids == null || ids.size() == 0) {
            return new LinkedList<Entity>();
        }
        int limit = 100;
        if (ids.size() > limit) {
            throw new IllegalArgumentException("List of ids is too long. Only " + limit + " values are allowed.");
        }
        LinkedList<String> conditions = new LinkedList<String>();
        conditions.add(QueryHelper.conditionIn("id", ids, true));
        String url = this.buildEntityUrl(workspaceId, collectionName, conditions, fields, 0, limit, null);
        ResponseEntityList result = this.getPagedEntities(url);
        return result.getData();
    }

    @Override
    public ResponseEntityList getPagedEntities(String url) {
        OctaneRestClient octaneRestClient = this.restService.obtainOctaneRestClient();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("accept", ContentType.APPLICATION_JSON.getMimeType());
        headers.put("HPECLIENTTYPE", "HPE_CI_CLIENT");
        OctaneRequest request = dtoFactory.newDTO(OctaneRequest.class).setMethod(HttpMethod.GET).setUrl(url).setHeaders(headers);
        OctaneResponse response = this.executeRequest(octaneRestClient, request);
        ResponseEntityList pagedEntityList = EntitiesServiceImpl.parseBody(200, response);
        return pagedEntityList;
    }

    private OctaneResponse executeRequest(OctaneRestClient octaneRestClient, OctaneRequest request) {
        try {
            return octaneRestClient.execute(request);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static ResponseEntityList parseBody(int expectedResult, OctaneResponse response) {
        String body = response.getBody();
        if (response.getStatus() == expectedResult) {
            return dtoFactory.dtoFromJson(body, ResponseEntityList.class);
        }
        try {
            if (body.contains("exceeds_total_count")) {
                OctaneBulkExceptionData data = dtoFactory.dtoFromJson(body, OctaneBulkExceptionData.class);
                throw new OctaneBulkException(response.getStatus(), data);
            }
            OctaneRestExceptionData data = dtoFactory.dtoFromJson(body, OctaneRestExceptionData.class);
            throw new OctaneRestException(response.getStatus(), data);
        }
        catch (OctaneBulkException | OctaneRestException ex1) {
            throw ex1;
        }
        catch (Exception ex2) {
            throw new RuntimeException("The request failed : " + body, ex2);
        }
    }

    @Override
    public String buildEntityUrl(Long workspaceId, String collection, Collection<String> conditions, Collection<String> fields, Integer offset, Integer limit, String orderBy) {
        return this.buildEntityUrl(workspaceId, collection, conditions, fields, offset, limit, orderBy, Collections.EMPTY_MAP);
    }

    @Override
    public String buildEntityUrl(Long workspaceId, String collection, Collection<String> conditions, Collection<String> fields, Integer offset, Integer limit, String orderBy, Map<String, String> serviceArgument) {
        StringBuilder template = new StringBuilder(this.configurer.octaneConfiguration.getUrl());
        template.append("/api/shared_spaces/");
        template.append(this.configurer.octaneConfiguration.getSharedSpace());
        if (workspaceId != null) {
            template.append("/workspaces/");
            template.append(workspaceId);
        }
        template.append("/");
        template.append(collection);
        template.append("?");
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (offset != null && limit != null) {
            params.put("offset", offset);
            params.put("limit", limit);
            template.append("&offset={offset}&limit={limit}");
        }
        if (conditions != null && !conditions.isEmpty()) {
            StringBuilder expr = new StringBuilder();
            for (String condition : conditions) {
                if (expr.length() > 0) {
                    expr.append(";");
                }
                expr.append(condition);
            }
            params.put("query", "\"" + expr.toString() + "\"");
            template.append("&query={query}");
        }
        if (fields != null && !fields.isEmpty()) {
            params.put("fields", SdkStringUtils.join(fields, ","));
            template.append("&fields={fields}");
        }
        if (SdkStringUtils.isNotEmpty(orderBy)) {
            params.put("order", orderBy);
            template.append("&order_by={order}");
        }
        if (!serviceArgument.isEmpty()) {
            serviceArgument.forEach((key, value) -> {
                params.put((String)key, value);
                template.append("&" + key + "={" + key + "}");
            });
        }
        return EntitiesServiceImpl.resolveTemplate(template.toString(), params);
    }

    private static String resolveTemplate(String template, Map<String, ?> params) {
        String result = template;
        for (Map.Entry<String, ?> param : params.entrySet()) {
            result = result.replaceAll(Pattern.quote("{" + param.getKey() + "}"), EntitiesServiceImpl.encodeParam(param.getValue() == null ? "" : param.getValue().toString()));
        }
        return result;
    }

    private static String encodeParam(String param) {
        try {
            return URLEncoder.encode(param, URI_PARAM_ENCODING).replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unsupported encoding used for URI parameter encoding.", e);
        }
    }
}

