/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.octaneExecution;

import com.hp.octane.integrations.utils.SdkStringUtils;
import java.io.Serializable;

public enum ExecutionMode implements Serializable
{
    SUITE_RUNS_IN_OCTANE("suite_runs_in_octane", "Execute suite runs in ALM Octane"),
    SUITE_IN_CI("suites_in_ci", "Get tests from suites and trigger execution jobs");

    private final String value;
    private final String desc;

    private ExecutionMode(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String value() {
        return this.value;
    }

    public String description() {
        return this.desc;
    }

    public static ExecutionMode fromValue(String value) {
        if (SdkStringUtils.isEmpty(value)) {
            throw new IllegalArgumentException("value MUST NOT be null nor empty");
        }
        for (ExecutionMode v : ExecutionMode.values()) {
            if (!v.value.equals(value)) continue;
            return v;
        }
        throw new IllegalStateException("ExecutionMode '" + value + "' is not supported");
    }
}

