/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.dto.connectivity.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hp.octane.integrations.dto.connectivity.HttpMethod;
import com.hp.octane.integrations.dto.connectivity.OctaneRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
class OctaneRequestImpl
implements OctaneRequest {
    private String url;
    private HttpMethod method;
    private Map<String, String> headers;
    private InputStream body;
    private int timeoutSec;

    OctaneRequestImpl() {
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public OctaneRequest setUrl(String url) {
        if (url == null || url.isEmpty()) {
            throw new IllegalArgumentException("URL MUST NOT be null nor empty");
        }
        try {
            new URL(url);
        }
        catch (MalformedURLException mue) {
            throw new IllegalArgumentException("URL argument is not valid", mue);
        }
        this.url = url;
        return this;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public OctaneRequest setMethod(HttpMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("method MUST NOT be null");
        }
        this.method = method;
        return this;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public OctaneRequest setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    @Override
    public InputStream getBody() {
        return this.body;
    }

    @Override
    @JsonIgnore
    public OctaneRequest setBody(InputStream body) {
        this.body = body;
        return this;
    }

    @Override
    @JsonProperty
    public OctaneRequest setBody(String body) {
        this.body = new ByteArrayInputStream(body.getBytes(StandardCharsets.UTF_8));
        return this;
    }

    @Override
    public int getTimeoutSec() {
        return this.timeoutSec;
    }

    @Override
    public OctaneRequest setTimeoutSec(int timeoutSec) {
        this.timeoutSec = timeoutSec;
        return this;
    }
}

