/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.plugins.bamboo.rest;

import com.atlassian.bamboo.plugin.BambooApplication;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.hp.octane.integrations.OctaneSDK;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/status")
@Scanned
public class StatusRestResource {
    @Context
    HttpServletRequest request;
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private UserManager userManager;

    @GET
    @Produces(value={"application/json"})
    public Response getStatus() {
        if (!this.hasPermissions(this.request)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"user does not have permission").build();
        }
        return Response.ok(this.getStatusResult()).build();
    }

    private UserManager getUserManager() {
        if (this.userManager == null) {
            this.userManager = (UserManager)ComponentLocator.getComponent(UserManager.class);
        }
        return this.userManager;
    }

    private boolean hasPermissions(HttpServletRequest request) {
        UserProfile username = this.getUserManager().getRemoteUser(request);
        return username != null && (this.getUserManager().isSystemAdmin(username.getUserKey()) || this.getUserManager().isAdmin(username.getUserKey()));
    }

    private Map<String, Object> getStatusResult() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String pluginVersion = ((PluginAccessor)ComponentLocator.getComponent(PluginAccessor.class)).getPlugin("com.hpe.adm.octane.ciplugins.bamboo-ci-plugin").getPluginInformation().getVersion();
        String bambooVersion = ((BambooApplication)ComponentLocator.getComponent(BambooApplication.class)).getVersion();
        HashMap<String, String> serverInfo = new HashMap<String, String>();
        serverInfo.put("sdkVersion", OctaneSDK.SDK_VERSION);
        serverInfo.put("pluginVersion", pluginVersion);
        serverInfo.put("bambooVersion", bambooVersion);
        serverInfo.put("currentTime", this.format.format(new Date()));
        result.put("server", serverInfo);
        HashMap allMetrics = new HashMap();
        OctaneSDK.getClients().forEach(client -> {
            HashMap<String, Map<String, Object>> clientMetrics = new HashMap<String, Map<String, Object>>();
            clientMetrics.put("client", this.format(client.getMetrics()));
            clientMetrics.put("taskPollingService", this.format(client.getBridgeService().getMetrics()));
            clientMetrics.put("eventsService", this.format(client.getEventsService().getMetrics()));
            clientMetrics.put("testsService", this.format(client.getTestsService().getMetrics()));
            clientMetrics.put("configurationService", this.format(client.getConfigurationService().getMetrics()));
            clientMetrics.put("restClient", this.format(client.getRestService().obtainOctaneRestClient().getMetrics()));
            allMetrics.put(client.getConfigurationService().getConfiguration().getLocationForLog(), clientMetrics);
        });
        result.put("server", serverInfo);
        result.put("metrics", allMetrics);
        return result;
    }

    private Map<String, Object> format(Map<String, Object> map) {
        map.keySet().forEach(key -> {
            if (map.get(key) instanceof Date) {
                String value = this.format.format(map.get(key));
                map.put((String)key, value);
            }
        });
        return map;
    }
}

