/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.plugins.bamboo.rest;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.hp.octane.integrations.OctaneClient;
import com.hp.octane.integrations.OctaneConfiguration;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.services.configurationparameters.factory.ConfigurationParameterFactory;
import com.hp.octane.plugins.bamboo.octane.BambooPluginServices;
import com.hp.octane.plugins.bamboo.octane.SDKBasedLoggerProvider;
import com.hp.octane.plugins.bamboo.octane.utils.JsonHelper;
import com.hp.octane.plugins.bamboo.rest.OctaneConnection;
import com.hp.octane.plugins.bamboo.rest.OctaneConnectionCollection;
import com.hp.octane.plugins.bamboo.rest.PreviousVersionsConfigurationHelper_1_7;
import java.io.IOException;
import org.apache.logging.log4j.Logger;

public class OctaneConnectionManager {
    private static final Logger log = SDKBasedLoggerProvider.getLogger(OctaneConnectionManager.class);
    private PluginSettingsFactory settingsFactory;
    private static final String PLUGIN_PREFIX = "com.hp.octane.plugins.bamboo.";
    public static final String CONFIGURATIONS_LIST = "com.hp.octane.plugins.bamboo.configuration_list";
    public static final String PLAIN_PASSWORD = "___PLAIN_PASSWORD____";
    private OctaneConnectionCollection octaneConnectionCollection;
    private static OctaneConnectionManager instance = new OctaneConnectionManager();

    public static OctaneConnectionManager getInstance() {
        return instance;
    }

    private OctaneConnectionManager() {
    }

    public OctaneConnectionCollection getOctaneConnections() {
        return this.octaneConnectionCollection;
    }

    private void saveSettings() {
        try {
            String confStr = JsonHelper.serialize(this.octaneConnectionCollection);
            PluginSettings settings = this.settingsFactory.createGlobalSettings();
            settings.put(CONFIGURATIONS_LIST, (Object)confStr);
        }
        catch (IOException e) {
            log.error("Failed to saveSettings : " + e.getMessage());
        }
    }

    public OctaneConnection getConnectionById(String id) {
        return this.octaneConnectionCollection.getConnectionById(id);
    }

    public void addConfiguration(OctaneConnection newConfiguration) {
        log.info("add new configuration: " + newConfiguration.getLocation());
        this.addSdkClient(newConfiguration);
        this.octaneConnectionCollection.addConnection(newConfiguration);
        this.saveSettings();
    }

    public void updateConfiguration(OctaneConnection octaneConnection) {
        log.info("update configuration: " + octaneConnection.getLocation());
        this.updateClientInSDK(octaneConnection);
        this.octaneConnectionCollection.updateConnection(octaneConnection);
        this.saveSettings();
    }

    public boolean deleteConfiguration(String id) {
        OctaneConnection octaneConnection = this.getConnectionById(id);
        if (octaneConnection != null) {
            log.info("delete configuration: " + octaneConnection.getLocation());
            this.removeClientFromSDK(id);
            boolean removed = this.octaneConnectionCollection.removeConnection(octaneConnection);
            this.saveSettings();
        }
        return octaneConnection != null;
    }

    public void replacePlainPasswordIfRequired(OctaneConnection octaneConnection) {
        if (octaneConnection.getClientSecret().equals(PLAIN_PASSWORD)) {
            octaneConnection.setClientSecret(this.getConnectionById(octaneConnection.getId()).getClientSecret());
        }
    }

    private void addSdkClient(OctaneConnection configuration) {
        OctaneConfiguration octaneConfiguration = OctaneConfiguration.createWithUiLocation(configuration.getId(), configuration.getLocation());
        octaneConfiguration.setClient(configuration.getClientId());
        octaneConfiguration.setSecret(configuration.getClientSecret());
        octaneConfiguration.setImpersonatedUser(configuration.getBambooUser());
        ConfigurationParameterFactory.addParameter(octaneConfiguration, "LOG_EVENTS", "true");
        ConfigurationParameterFactory.addParameter(octaneConfiguration, "SCM_REST_API", "true");
        OctaneSDK.addClient(octaneConfiguration, BambooPluginServices.class);
    }

    private void updateClientInSDK(OctaneConnection configuration) {
        OctaneClient currentClient = OctaneSDK.getClientByInstanceId(configuration.getId());
        OctaneConfiguration config = currentClient.getConfigurationService().getConfiguration();
        config.setUiLocation(configuration.getLocation());
        config.setClient(configuration.getClientId());
        config.setSecret(configuration.getClientSecret());
    }

    private void removeClientFromSDK(String uuid) {
        OctaneClient currentClient = OctaneSDK.getClientByInstanceId(uuid);
        OctaneSDK.removeClient(currentClient);
    }

    public void initSdkClients(PluginSettingsFactory settingsFactory) {
        log.info("");
        log.info("");
        log.info("***********************************************************************************");
        log.info("****************************Enabling plugin - init SDK Clients*********************");
        log.info("***********************************************************************************");
        try {
            String pluginVersion = ((PluginAccessor)ComponentLocator.getComponent(PluginAccessor.class)).getPlugin("com.hpe.adm.octane.ciplugins.bamboo-ci-plugin").getPluginInformation().getVersion();
            log.info("Plugin version : " + pluginVersion);
        }
        catch (Exception e) {
            log.error("Failed to get plugin version : " + e.getMessage());
        }
        this.settingsFactory = settingsFactory;
        try {
            PluginSettings settings = settingsFactory.createGlobalSettings();
            if (settings.get(CONFIGURATIONS_LIST) == null) {
                this.octaneConnectionCollection = new OctaneConnectionCollection();
                OctaneConnection octaneConnection = PreviousVersionsConfigurationHelper_1_7.tryReadConfiguration(settingsFactory);
                if (octaneConnection != null) {
                    this.addConfiguration(octaneConnection);
                }
            } else {
                String confStr = (String)settings.get(CONFIGURATIONS_LIST);
                this.octaneConnectionCollection = JsonHelper.deserialize(confStr, OctaneConnectionCollection.class);
                for (OctaneConnection c : this.octaneConnectionCollection.getOctaneConnections()) {
                    try {
                        this.addSdkClient(c);
                    }
                    catch (Exception e) {
                        log.info(String.format("Failed to add client '%s' to sdk : %s", c.getId(), e.getMessage()));
                    }
                }
            }
        }
        catch (IOException e) {
            log.error("Failed to initSdkClients : " + e.getMessage(), (Throwable)e);
        }
    }

    public void removeClients() {
        log.info("Disabling plugin - removing SDK clients");
        OctaneSDK.getClients().forEach(c -> OctaneSDK.removeClient(c));
    }

    public static boolean hasActiveClients() {
        return OctaneSDK.hasClients();
    }
}

