/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.plugins.bamboo.rest;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.hp.octane.plugins.bamboo.octane.SDKBasedLoggerProvider;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.Logger;

@Path(value="/logs")
@Scanned
public class LogsRestResource {
    @Context
    HttpServletRequest request;
    private static final Logger log = SDKBasedLoggerProvider.getLogger(LogsRestResource.class);
    private UserManager userManager;

    @Path(value="/events")
    @GET
    @Produces(value={"text/plain"})
    public Response getLastEvents() {
        return this.getLogFile("events", null);
    }

    @Path(value="/events/{id}")
    @GET
    @Produces(value={"text/plain"})
    public Response getEventsById(@PathParam(value="id") Integer id) {
        return this.getLogFile("events", null);
    }

    @GET
    @Produces(value={"text/plain"})
    public Response getLastLog() {
        return this.getLogFile("nga", null);
    }

    @Path(value="/{id}")
    @GET
    @Produces(value={"text/plain"})
    public Response getLogById(@PathParam(value="id") Integer id) {
        return this.getLogFile("nga", id);
    }

    private Response getLogFile(String name, Integer id) {
        if (!this.hasPermissions(this.request)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"user does not have permission").build();
        }
        java.nio.file.Path path = Paths.get(SDKBasedLoggerProvider.getAllowedStorageFile().getAbsolutePath(), "nga", "logs", id == null ? name + ".log" : String.format("%s-%s.log", name, id));
        if (path.toFile().exists()) {
            try {
                String str = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
                return Response.ok((Object)str).build();
            }
            catch (IOException e) {
                log.error("Failed to read log file : " + e.getMessage(), (Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Failed to read log file").build();
            }
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No log file is found").build();
    }

    private UserManager getUserManager() {
        if (this.userManager == null) {
            this.userManager = (UserManager)ComponentLocator.getComponent(UserManager.class);
        }
        return this.userManager;
    }

    private boolean hasPermissions(HttpServletRequest request) {
        UserProfile username = this.getUserManager().getRemoteUser(request);
        return username != null && (this.getUserManager().isSystemAdmin(username.getUserKey()) || this.getUserManager().isAdmin(username.getUserKey()));
    }
}

